package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Uint32;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;

/***
 * Time32 ::= Uint32
 */
public class Time32 extends Uint32 {
    private static Logger logger = LoggerFactory.getLogger(Time32.class);

    public Time32(long i) throws IOException {
        super(i);
    }

    public static Time32 getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "Time32 start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 4);
        Time32 time32 = new Time32(integer.longValue());
        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        time32.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "Time32 lave data", time32.getGoal());
        return time32;
    }
}
