package com.xdja.pki.itsca.oer.asn1.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

/**
 * 枚举类型通过编码编码 数 与枚举关联。（这不同于PER，其中，连续的索引分配给每个枚举和索引进入编码。）
 * 可扩展和不可伸长的枚举类型进行编码以相同的方式。规则如下：
 *
 * 1） 如果与相关联的枚举的数量是在0到127的范围内，它被编码为 一个八位字节无符号整数，其最高位设定为零;
 * 2） 否则，与所述枚举相关联的数字编码为 一个签名 二进制整数占用一个 八位位组的数目可变 在大端顺序，
 * 前面是一个八位位组的 长度前缀; 长度前缀包含随后的字节数，并其最高位设置为1。
 */
public class Enumerated extends OERObject {

    public static class Value{
        private int index;
        private String desc;

        public Value(int index, String desc) {
            this.index = index;
            this.desc = desc;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Value value = (Value) o;
            return index == value.index &&
                    Objects.equals(desc, value.desc);
        }

        @Override
        public int hashCode() {
            return Objects.hash(index, desc);
        }

        public int getIndex() {
            return index;
        }

        public String getDesc() {
            return desc;
        }

        @Override
        public String toString() {
            return "Value{" +
                    "index=" + index +
                    ", desc='" + desc + '\'' +
                    '}';
        }
    }

    private List<Value> enumList = new ArrayList<>();

    private Value value;

    private Enumerated() {
    }

    public Enumerated(Value value) {
        this.value = value;
    }

    public static Enumerated getInstance(byte[] obj) throws Exception {
        Enumerated enumerated = new Enumerated();
        enumerated.fromByteArray(obj);
        return enumerated;
    }

    public void addValueToList(Value value){
        this.enumList.add(value);
    }

    public Value readValue() throws IOException {
        for (Value v : enumList) {
            if (v.index == this.readInt()){
                return v;
            }
        }
        throw new IOException("can not get value for index " + this.readInt());
    }

    @Override
    public Vector getValues() {
        int enumLen = enumList.size();
        if (enumLen >=0 && enumLen <= 127){
            Vector vector = new Vector();
            vector.add(value.getIndex());
            return vector;
        }
        return null;
    }
}
