package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ByteArrayUtils {

    private static Logger logger = LoggerFactory.getLogger(X509Utils.class.getName());


    /************************************************************************************
     *                                OER编码使用方法 写入
     ************************************************************************************/
    public static byte[] buildUpByte(byte[] var1, byte[] var2) {
        byte[] data = new byte[var1.length + var2.length];
        System.arraycopy(var1, 0, data, 0, var1.length);
        System.arraycopy(var2, 0, data, var1.length, var2.length);
        return data;
    }

    public static String splitPublicKey(PublicKey publicKey) {
        ECPublicKey ecPublicKey = (ECPublicKey) publicKey;
        byte[] x = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineY());
        String xx = Hex.toHexString(x);
        int xLength = xx.length();
        if (xx.length() < 64) {
            for (int i = xLength; i < 64; i++) {
                xx = "0" + xx;
            }
        }
        String yy = Hex.toHexString(y);
        int yLength = yy.length();
        if (yy.length() < 64) {
            for (int i = yLength; i < 64; i++) {
                yy = "0" + yy;
            }
        }
        return xx + yy;
    }

    public static byte[] getHashId(byte[] data, int len) throws Exception {
        byte[] hash = GMSSLSM3DigestUtils.digestByYunhsm(data);
        byte[] bytes = new byte[len];
        System.arraycopy(hash, hash.length - len, bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] subByteHashId(byte[] data, int len) throws Exception {
        byte[] bytes = new byte[len];
        System.arraycopy(data, data.length - len, bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] getHashId8(byte[] data) throws Exception {
        return getHashId(data, 8);
    }

    public static byte[] getHashId10(byte[] data) throws Exception {
        return getHashId(data, 10);
    }


    /************************************************************************************
     *                                Binary 二进制转换
     ************************************************************************************/

    public static byte[] hexDecode(String hexData) {
//        int len = hexData.length();
//        byte[] data = new byte[len / 2];
//        for (int i = 0; i < len; i += 2) {
//            data[i / 2] = (byte) ((Character.digit(hexData.charAt(i), 16) << 4)
//                    + Character.digit(hexData.charAt(i+1), 16));
//        }
//        return data;
        return Hex.decode(hexData);
    }

    public static String hexEncode(byte[] data) {
//        char[] hexCode = "0123456789ABCDEF".toCharArray();
//        StringBuilder r = new StringBuilder(data.length * 2);
//        for (byte b : data) {
//            r.append(hexCode[(b >> 4) & 0xF]);
//            r.append(hexCode[(b & 0xF)]);
//        }
//        return r.toString();
        return Hex.toHexString(data);
    }

    public static String hexEncodeSubString(byte[] data) {
        List<String> list = new ArrayList<>();
        String hexString = Hex.toHexString(data);
        for (int i = 0; i <= hexString.length() / 8; i++) {
            int start = i * 8;
            int end = start + 8;
            if (end > hexString.length() - 1) {
                end = hexString.length();
            }
            String substring = hexString.substring(start, end);
            list.add(substring);
        }
        return String.join(" ", list);
    }

    public static String hexEncode(BigInteger data) {
        return hexEncode(asUnsignedByteArray32(data));
    }

    public static int printTag = -1;

    public static void printHexBinary(int tab, String message, byte[] data) {
        if (printTag == -1) {
            return;
        }
        if (tab > printTag) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tab; i++) {
            sb.append("|  ");
        }

        if (data != null) {
            sb.append(": ");
            sb.append(message);
            sb.append(" [length=");
            sb.append(data.length);
            sb.append("] 0x ");
            sb.append(hexEncodeSubString(data));
            System.out.println(sb.toString());
        } else {
            sb.append(message);
            System.out.println(sb.toString());
        }
    }

    public static void printHexBinary(Logger log, String message, byte[] data) {
        if (log != null) {
            log.debug(message + " >> Hex len : " + data.length + " data : " + hexEncode(data));
        } else {
            logger.debug(message + " >> Hex len : " + data.length + " data : " + hexEncode(data));
        }
    }

    public static boolean compareHexBinary(Logger log, String message, String hexData, byte[] data) {
        boolean equals = Arrays.equals(hexDecode(hexData), data);
        String s = hexEncode(data);
        if (log != null) {
            log.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        } else {
            logger.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        }
        return equals;
    }

    public static byte[] base64Decode(String base64Data) {
        return Base64.decode(base64Data);
    }

    public static String base64Encode(byte[] data) {
        return Base64.toBase64String(data);
    }

    public static void printBase64Binary(Logger log, String message, byte[] data) {
        if (log != null) {
            log.debug(message + " >> Base64 len : " + data.length + " data : " + base64Encode(data));
        } else {
            logger.debug(message + " >> Base64 len : " + data.length + " data : " + base64Encode(data));
        }
    }

    public static String asciiToHex(String asciiValue) {
        char[] chars = asciiValue.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; i++) {
            hex.append(Integer.toHexString((int) chars[i]));
        }
        return hex.toString();
    }

    public static String hexToASCII(String hexValue) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexValue.length(); i += 2) {
            String str = hexValue.substring(i, i + 2);
            output.append((char) Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static byte[] changeByteArrayLength(BigInteger b) {
        byte[] bb = BigIntegers.asUnsignedByteArray(b);
        return changeByteArrayLength(bb);
    }

    public static byte[] changeByteArrayLength(byte[] b) {
        return changeByteArrayLength(b, 32);
    }

    public static byte[] changeByteArrayLength(byte[] bb, int len) {
        if (bb.length == len) {
            return bb;
        } else if (bb.length < len) {
            return ByteArrayUtils.fillByteArrayWithZeroInHead(bb);
        } else {
            return ByteArrayUtils.filterByteArrayZeroInHead(bb);
        }
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss) {
        return fillByteArrayWithZeroInFoot(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte) (0x00));
        System.arraycopy(ss, 0, bs, 0, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss) {
        return filterByteArrayZeroInFoot(ss, 32);
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, 0, bs, 0, len);
        return bs;
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss) {
        return fillByteArrayWithZeroInHead(ss, 32);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte) (0x00));
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss) {
        return filterByteArrayZeroInHead(ss, 32);
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, ss.length - len, bs, 0, len);
        return bs;
    }

    public static byte[] asUnsignedByteArray32(BigInteger value) {
        return BigIntegers.asUnsignedByteArray(32, value);
    }
}
