package com.xdja.pki.itsca.oer.utils;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {

    public static long getStartTime() throws IOException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = "2004-01-01 00:00:00";
            Date start = sdf.parse(str);
            return (start.getTime()) / 1000;
        } catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static String getTime(long i) throws IOException {
        long startTime = getStartTime() * 1000;
        long a = startTime + i * 1000;
        Date date = new Date(a);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static long getNowTime() throws IOException {
        Date now = new Date();
        long nowTime = now.getTime() / 1000;
        long startTime = getStartTime();

        return nowTime - startTime;
    }

    public static long getTimeAfterYear(int amount) throws IOException {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(Calendar.YEAR, amount);
        long afterTime = calendar.getTime().getTime() / 1000;
        long startTime = getStartTime();
        return afterTime - startTime;
    }

    public static long getTimeAfterWeek(int amount) throws IOException {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(Calendar.WEEK_OF_YEAR, amount);
        long afterTime = calendar.getTime().getTime() / 1000;
        long startTime = getStartTime();
        return afterTime - startTime;
    }

    public static long getTimeFromDate(Date date) throws IOException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = "2004-01-01 00:00:00";
            Date start = sdf.parse(str);
            return (date.getTime() - start.getTime()) / 1000;
        } catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static Date getTimeFromNumber(long i) throws IOException {
        long startTime = getStartTime() * 1000;
        long a = startTime + i * 1000;
        return new Date(a);
    }
}
