/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.ItsAidInt;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredMessageBuilder {
    private static Logger logger = LoggerFactory.getLogger(SecuredMessageBuilder.class);

    public static SecuredMessage buildSignedDataSecuredMessage(ItsAidInt itsAidInt, PrivateKey caPrivateKey, Certificate caCertificate, byte[] data) throws Exception {
        SecuredMessage sign = new SecuredMessage();
        SignedData signedData = new SignedData();
        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        sequenceOfCertificate.addCertificate(caCertificate);
        SignerInfo signerInfo = new SignerInfo(sequenceOfCertificate);
        signedData.setSignerInfo(signerInfo);
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(itsAidInt);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        signedData.setTbs(tbsData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ecaEncode = caCertificate.getEncode();
        byte[] ecaHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])ecaEncode);
        byte[] tbsDataEncode = tbsData.getEncode();
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsDataEncode);
        bos.write(tbsHash);
        bos.write(ecaHash);
        Signature signature = SignatureBuild.build(caPrivateKey, bos.toByteArray());
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        sign.setPayload(payload);
        return sign;
    }

    public static SecuredMessage buildEncryptedDataSecuredMessage(Certificate caCertificate, byte[] data) throws Exception {
        SecuredMessage enc = new SecuredMessage();
        byte[] key = GMSSLByteArrayUtils.base64Decode((String)GMSSLRandomUtils.generateRandomByYunhsm((int)16));
        EncryptedData encryptedData = new EncryptedData();
        SequenceOfRecipientInfo sequenceOfRecipientInfo = SecuredMessageBuilder.buildSequenceOfRecipientInfo(caCertificate, key);
        encryptedData.setRecipients(sequenceOfRecipientInfo);
        CipherText cipherText = new CipherText();
        byte[] cipher = GMSSLSM4ECBEncryptUtils.sm4SymmetricWithPaddingByYunHsm((boolean)true, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (byte[])key, (byte[])data);
        ByteArrayUtils.printHexBinary(logger, "cipher", cipher);
        cipherText.setString(cipher);
        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);
        Payload payload = new Payload(encryptedData);
        enc.setPayload(payload);
        ByteArrayUtils.printHexBinary(logger, "payload", payload.getEncode());
        logger.info("\u52a0\u5bc6\u6570\u636e\u52a0\u5bc6\u5b8c\u6210");
        return enc;
    }

    public static SequenceOfRecipientInfo buildSequenceOfRecipientInfo(Certificate caCertificate, byte[] key) throws Exception {
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        byte[] certHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])caCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        EccPoint publicKey = caCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        logger.info("\u6784\u5efasequenceOfRecipientInfo\u5b8c\u6210");
        return sequenceOfRecipientInfo;
    }
}

