/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.ATTbsCert;
import com.xdja.pki.itsca.oer.asn1.EcSignature;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.InnerATRequest;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.SharedATRequest;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.util.BigIntegers;

public class InnerATRequestBuilder {
    public static InnerATRequest build(PublicKey signPublicKey, PublicKey encPublicKey, PublicKey snapPublicKey, EcSignature ecSignature, ATTbsCert atTbsCert) throws IOException {
        SharedATRequest sharedATRequest = new SharedATRequest();
        sharedATRequest.setCurrentTime(new Time32(TimeUtils.getNowTime()));
        PublicEncryptionKey snapPublic = new PublicEncryptionKey();
        snapPublic.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        snapPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        snapPublic.setPublicKey(InnerATRequestBuilder.buildEccPoint(snapPublicKey));
        sharedATRequest.setEncryptionKey(snapPublic);
        sharedATRequest.setTbsCert(atTbsCert);
        return InnerATRequestBuilder.build(signPublicKey, encPublicKey, ecSignature, sharedATRequest);
    }

    public static InnerATRequest build(PublicKey signPublicKey, PublicKey encPublicKey, EcSignature ecSignature, SharedATRequest sharedATRequest) throws IOException {
        InnerATRequest innerATRequest = new InnerATRequest();
        innerATRequest.setEcSignature(ecSignature);
        innerATRequest.setSharedATRequest(sharedATRequest);
        PublicEncryptionKey encPublic = new PublicEncryptionKey();
        encPublic.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        encPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        encPublic.setPublicKey(InnerATRequestBuilder.buildEccPoint(encPublicKey));
        innerATRequest.setEncryptionKey(encPublic);
        PublicVerifyKey signPublic = new PublicVerifyKey();
        signPublic.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        signPublic.setEccPoint(InnerATRequestBuilder.buildEccPoint(signPublicKey));
        innerATRequest.setVerificationKey(signPublic);
        return innerATRequest;
    }

    public static EccPoint buildEccPoint(PublicKey publicKey) {
        EccPoint eccPoint = new EccPoint();
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey snapKey = (ECPublicKey)publicKey;
        byte[] x = BigIntegers.asUnsignedByteArray((BigInteger)snapKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray((BigInteger)snapKey.getW().getAffineY());
        uncompressed.setX(x);
        uncompressed.setY(y);
        eccPoint.setUncompressed(uncompressed);
        return eccPoint;
    }
}

