/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.CertDataBuilder;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.security.PublicKey;

public class NormalCertRequestEnc
extends CertDataBuilder {
    public SecuredMessage build(CertRequest certRequest, PublicKey publicKey, byte[] key) throws Exception {
        return this.buildSecuredMessage(certRequest, publicKey, false, key, certRequest.getEncode());
    }

    private SecuredMessage buildSecuredMessage(CertRequest certRequest, PublicKey publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        pkRecipientInfo.setHashAlg(hashAlg);
        byte[] certReqHash = GMSSLSM3DigestUtils.digestByBC((byte[])certRequest.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certReqHash, certReqHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        ByteArrayUtils.printHexBinary(null, "hashID data ", certHashId8);
        HashedId8 recipientId = new HashedId8(certHashId8);
        pkRecipientInfo.setRecipientId(recipientId);
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        pkRecipientInfo.setKek(kek);
        EncryptedData encData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        RecipientInfo recipientInfo = isSignedDataRecip ? new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.SIGNEDDATA_RECIPINFO) : new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.CERT_RECIPINFO);
        recipients.addRecipientInfo(recipientInfo);
        encData.setRecipients(recipients);
        byte[] bytes = GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf((boolean)true, (SdfCryptoType)SdfCryptoType.YUNHSM, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (byte[])key, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM4_ECB, (byte[])data);
        ByteArrayUtils.printHexBinary(null, "BCUtils bytes", bytes);
        CipherText cipherData = new CipherText();
        cipherData.setString(bytes);
        SymmetricCipherText cipherText = new SymmetricCipherText(cipherData);
        encData.setCipherText(cipherText);
        Payload payload = new Payload(encData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

