/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SubjectAssurance;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.SequenceOf;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATSubjectAttributes
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ATSubjectAttributes.class);
    private SubjectAssurance assuranceLevel;
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsSspList;

    public ATSubjectAttributes() {
        super(true, true);
    }

    public static ATSubjectAttributes getInstance(byte[] data) throws Exception {
        SequenceOf instance;
        ByteArrayUtils.printHexBinary(logger, "ATSubjectAttributes start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        ATSubjectAttributes atSubjectAttributes = new ATSubjectAttributes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            logger.debug("ATSubjectAttributes choice assuranceLevel");
            goal = new byte[1];
            System.arraycopy(data, 0, goal, 0, goal.length);
            SubjectAssurance assuranceLevel = new SubjectAssurance(goal);
            atSubjectAttributes.setAssuranceLevel(assuranceLevel);
            ByteArrayUtils.printHexBinary(logger, "ATSubjectAttributes assuranceLevel data", assuranceLevel.getEncode());
            goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
        }
        if (integers.contains(2)) {
            logger.debug("ATSubjectAttributes choice itsAidList");
            instance = SequenceOfItsAidList.getInstance(data);
            atSubjectAttributes.setItsAidList((SequenceOfItsAidList)instance);
            ByteArrayUtils.printHexBinary(logger, "ATSubjectAttributes itsAidList data", instance.getEncode());
            data = instance.getGoal();
        }
        if (integers.contains(3)) {
            logger.debug("ATSubjectAttributes choice itsSspList");
            instance = SequenceOfItsAidSspList.getInstance(data);
            atSubjectAttributes.setItsSspList((SequenceOfItsAidSspList)instance);
            ByteArrayUtils.printHexBinary(logger, "ATSubjectAttributes itsSspList data", instance.getEncode());
            data = instance.getGoal();
        }
        atSubjectAttributes.setGoal(data);
        return atSubjectAttributes;
    }

    public SubjectAssurance getAssuranceLevel() {
        return this.assuranceLevel;
    }

    public void setAssuranceLevel(SubjectAssurance assuranceLevel) {
        this.assuranceLevel = assuranceLevel;
    }

    public SequenceOfItsAidList getItsAidList() {
        return this.itsAidList;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public SequenceOfItsAidSspList getItsSspList() {
        return this.itsSspList;
    }

    public void setItsSspList(SequenceOfItsAidSspList itsSspList) {
        this.itsSspList = itsSspList;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.assuranceLevel != null) {
            optionals.add(7);
        }
        if (this.itsAidList != null) {
            optionals.add(6);
        }
        if (this.itsSspList != null) {
            optionals.add(5);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.assuranceLevel);
        vector.add(this.itsAidList);
        vector.add(this.itsSspList);
        return vector;
    }
}

