/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.ATSubjectAttributes;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationValidationResponse
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(AuthorizationValidationResponse.class);
    private OctetString requestHash;
    private Int responseCode;
    private ATSubjectAttributes confirmedSubjectAttributes;
    private GeographicRegion region;

    public AuthorizationValidationResponse() {
        super(false, true);
    }

    public AuthorizationValidationResponse(byte[] requestHash, int responseCode, ATSubjectAttributes confirmedSubjectAttributes, GeographicRegion region) {
        super(false, true);
        logger.info("AuthorizationValidationResponse new");
        this.setRequestHash(requestHash);
        logger.info("AuthorizationValidationResponse new start set code");
        this.setResponseCode(responseCode);
        logger.info("AuthorizationValidationResponse new done set code");
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
        this.region = region;
    }

    public static AuthorizationValidationResponse getInstance(byte[] data) throws Exception {
        AuthorizationValidationResponse response = new AuthorizationValidationResponse();
        ByteArrayUtils.printHexBinary(logger, "AuthorizationValidationRequest start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        goal = new byte[32];
        System.arraycopy(data, 0, goal, 0, goal.length);
        OctetString requestHash = new OctetString();
        requestHash.setString(goal);
        logger.info("getInstance  start set request hash");
        response.setRequestHash(requestHash.getString());
        ByteArrayUtils.printHexBinary(logger, "AuthorizationValidationRequest requestHash data", requestHash.getEncode());
        goal = new byte[data.length - 32];
        System.arraycopy(data, 32, goal, 0, goal.length);
        data = goal;
        response.setResponseCode((short)BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1).intValue());
        goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        ATSubjectAttributes attributes = ATSubjectAttributes.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "AuthorizationValidationRequest ATSubjectAttributes data", attributes.getEncode());
        response.setConfirmedSubjectAttributes(attributes);
        data = attributes.getGoal();
        if (integers.contains(0)) {
            GeographicRegion geographicRegion = GeographicRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "AuthorizationValidationRequest geographicRegion data", geographicRegion.getEncode());
            response.setRegion(geographicRegion);
            data = geographicRegion.getGoal();
        }
        response.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "AuthorizationValidationRequest lave data", data);
        return response;
    }

    public byte[] getRequestHash() {
        return this.requestHash.getString();
    }

    public void setRequestHash(byte[] requestHash) {
        this.requestHash = new OctetString(32);
        this.requestHash.setString(requestHash);
        try {
            ByteArrayUtils.printHexBinary(logger, "requestHash", this.requestHash.getEncode());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    public int getResponseCode() {
        return this.responseCode.getValue();
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = new Int((byte)responseCode, 1);
    }

    public ATSubjectAttributes getConfirmedSubjectAttributes() {
        return this.confirmedSubjectAttributes;
    }

    public void setConfirmedSubjectAttributes(ATSubjectAttributes confirmedSubjectAttributes) {
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
    }

    public static void setLogger(Logger logger) {
        AuthorizationValidationResponse.logger = logger;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public void setResponseCode(Int responseCode) {
        this.responseCode = responseCode;
    }

    public GeographicRegion getRegion() {
        return this.region;
    }

    public void setRegion(GeographicRegion region) {
        this.region = region;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.region != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add(this.responseCode);
        vector.add(this.confirmedSubjectAttributes);
        vector.add(this.region);
        return vector;
    }
}

