/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.CertificateDigest;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuerId
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(IssuerId.class);
    private Null self;
    private CertificateDigest certificateDigest;

    public static IssuerId getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "IssuerId start data ", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        IssuerId issuerId = new IssuerId();
        if (choice.intValue() - 128 == 0) {
            logger.debug("IssuerId choice self");
            issuerId.setSelf(new Null());
            issuerId.setGoal(data);
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("IssuerId choice certificateDigest");
            CertificateDigest certificateDigest = CertificateDigest.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "IssuerId certificateDigest data ", certificateDigest.getEncode());
            issuerId.setCertificateDigest(certificateDigest);
            issuerId.setGoal(certificateDigest.getGoal());
        } else {
            logger.error("IssuerId choice is error " + choice.intValue());
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        ByteArrayUtils.printHexBinary(logger, "IssuerId certificateDigest d ", issuerId.getGoal());
        return issuerId;
    }

    public Null getSelf() {
        return this.self;
    }

    public void setSelf(Null self) {
        this.self = self;
    }

    public CertificateDigest getCertificateDigest() {
        return this.certificateDigest;
    }

    public void setCertificateDigest(CertificateDigest certificateDigest) {
        this.addIndex(1);
        this.certificateDigest = certificateDigest;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.self);
        vector.add(this.certificateDigest);
        return vector;
    }
}

