/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicEncryptionKey
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PublicEncryptionKey.class);
    private SymmetricAlgorithm supportedSymmAlg;
    private EccCurve eccCurve;
    private EccPoint publicKey;

    public PublicEncryptionKey() {
        super(false, false);
    }

    public static PublicEncryptionKey getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey start data", data);
        SymmetricAlgorithm supportedSymmAlg = SymmetricAlgorithm.getInstance(data);
        data = supportedSymmAlg.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey supportedSymmAlg data", supportedSymmAlg.getEncode());
        EccCurve eccCurve = EccCurve.getInstance(data);
        data = eccCurve.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey eccCurve data", eccCurve.getEncode());
        EccPoint eccPoint = EccPoint.getInstance(data);
        data = eccPoint.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey eccPoint data", eccPoint.getEncode());
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(supportedSymmAlg);
        publicEncryptionKey.setPublicKey(eccPoint);
        publicEncryptionKey.setEccCurve(eccCurve);
        publicEncryptionKey.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey lave data", publicEncryptionKey.getGoal());
        return publicEncryptionKey;
    }

    public void setSupportedSymmAlg(SymmetricAlgorithm supportedSymmAlg) {
        this.supportedSymmAlg = supportedSymmAlg;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public void setPublicKey(EccPoint publicKey) {
        this.publicKey = publicKey;
    }

    public SymmetricAlgorithm getSupportedSymmAlg() {
        return this.supportedSymmAlg;
    }

    public EccCurve getEccCurve() {
        return this.eccCurve;
    }

    public EccPoint getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.supportedSymmAlg);
        vector.add(this.eccCurve);
        vector.add(this.publicKey);
        return vector;
    }
}

