/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId10;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeInfo
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(RevokeInfo.class);
    private HashAlgorithm hashAlgorithm;
    private HashedId10 hashedId10;
    private Time32 expiry;

    public RevokeInfo() {
        super(true, true);
    }

    public static RevokeInfo getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo start data", data);
        RevokeInfo revokeInfo = new RevokeInfo();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(choice.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        data = hashAlgorithm.getGoal();
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo hashAlgorithm data", hashAlgorithm.getEncode());
        HashedId10 hashedId10 = HashedId10.getInstance(data);
        ByteArrayUtils.printHexBinary(logger, "RevokeInfo hashedId10 data", hashedId10.getEncode());
        data = hashedId10.getGoal();
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            Time32 expiry = Time32.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "RevokeInfo expiry data", expiry.getEncode());
            revokeInfo.setExpiry(expiry);
            data = expiry.getGoal();
        }
        revokeInfo.setHashedId10(hashedId10);
        revokeInfo.setHashAlgorithm(hashAlgorithm);
        revokeInfo.setGoal(data);
        return revokeInfo;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public HashedId10 getHashedId10() {
        return this.hashedId10;
    }

    public void setHashedId10(HashedId10 hashedId10) {
        this.hashedId10 = hashedId10;
    }

    public Time32 getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Time32 expiry) {
        this.expiry = expiry;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.hashAlgorithm);
        vector.add(this.hashedId10);
        if (this.expiry != null) {
            this.addOptional(Arrays.asList(7));
            vector.add(this.expiry);
        }
        return vector;
    }
}

