/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectType
extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(SubjectType.class);
    public static final Enumerated.Value ENROLLMENT_CREDENTIAL = new Enumerated.Value(0, "ENROLLMENT_CREDENTIAL");
    public static final Enumerated.Value AUTHORIZATION_TICKET = new Enumerated.Value(1, "AUTHORIZATION_TICKET");
    public static final Enumerated.Value AUTHORIZATION_AUTHORITY = new Enumerated.Value(2, "AUTHORIZATION_AUTHORITY");
    public static final Enumerated.Value ENROLLMENT_AUTHORITY = new Enumerated.Value(3, "ENROLLMENT_AUTHORITY");
    public static final Enumerated.Value ROOT_CA = new Enumerated.Value(4, "ROOT_CA");
    public static final Enumerated.Value CRL_SIGNER = new Enumerated.Value(5, "CRL_SIGNER");
    public static final Enumerated.Value PSEUDONYM_CERTIFICATE = new Enumerated.Value(6, "PSEUDONYM_CERTIFICATE");
    public static final Enumerated.Value PSEUDONYM_AUTHORITY = new Enumerated.Value(7, "PSEUDONYM_AUTHORITY");

    public static SubjectType getInstance(byte[] data) throws Exception {
        SubjectType subjectType;
        ByteArrayUtils.printHexBinary(logger, "SubjectType start data", data);
        BigInteger type = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (type.intValue() == 0) {
            logger.debug("SubjectType choice ENROLLMENT_CREDENTIAL");
            subjectType = new SubjectType(ENROLLMENT_CREDENTIAL);
        } else if (type.intValue() == 1) {
            logger.debug("SubjectType choice AUTHORIZATION_TICKET");
            subjectType = new SubjectType(AUTHORIZATION_TICKET);
        } else if (type.intValue() == 2) {
            logger.debug("SubjectType choice AUTHORIZATION_AUTHORITY");
            subjectType = new SubjectType(AUTHORIZATION_AUTHORITY);
        } else if (type.intValue() == 3) {
            logger.debug("SubjectType choice ENROLLMENT_AUTHORITY");
            subjectType = new SubjectType(ENROLLMENT_AUTHORITY);
        } else if (type.intValue() == 4) {
            logger.debug("SubjectType choice ROOT_CA");
            subjectType = new SubjectType(ROOT_CA);
        } else if (type.intValue() == 5) {
            logger.debug("SubjectType choice CRL_SIGNER");
            subjectType = new SubjectType(CRL_SIGNER);
        } else if (type.intValue() == 6) {
            logger.debug("SubjectType choice PSEUDONYM_CERTIFICATE");
            subjectType = new SubjectType(PSEUDONYM_CERTIFICATE);
        } else if (type.intValue() == 7) {
            logger.debug("SubjectType choice PSEUDONYM_AUTHORITY");
            subjectType = new SubjectType(PSEUDONYM_AUTHORITY);
        } else {
            logger.error("SubjectType choice is error " + type.intValue());
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        subjectType.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "SubjectType start data", subjectType.getGoal());
        return subjectType;
    }

    public SubjectType(Enumerated.Value value) {
        super(value);
        this.addValueToList(ENROLLMENT_CREDENTIAL);
        this.addValueToList(AUTHORIZATION_TICKET);
        this.addValueToList(AUTHORIZATION_AUTHORITY);
        this.addValueToList(ENROLLMENT_AUTHORITY);
        this.addValueToList(ROOT_CA);
        this.addValueToList(CRL_SIGNER);
        this.addValueToList(PSEUDONYM_CERTIFICATE);
        this.addValueToList(PSEUDONYM_AUTHORITY);
    }
}

