/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.cert.bean.EccPointType;
import com.xdja.pki.itsca.oer.cert.bean.OEREccPoint;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.math.BigInteger;
import java.security.PublicKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccPointHolder {
    private static Logger logger = LoggerFactory.getLogger(EccPointHolder.class);

    public static OEREccPoint build(byte[] data) throws Exception {
        EccPoint eccPoint = EccPoint.getInstance(data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        OEREccPoint oerEccPoint = new OEREccPoint();
        if (choice.intValue() - 128 == 0) {
            logger.debug("EccPoint choice xOnly");
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("EccPoint choice fill");
        } else {
            if (choice.intValue() - 128 == 2) {
                logger.debug("EccPoint choice compressedY0");
                oerEccPoint.setEccPointType(EccPointType.COMPRESSED_Y0);
                oerEccPoint.setPublicKey(X509Utils.decodePoint(false, eccPoint.getCompressedY0().getString()));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getCompressedY0().getString()));
                return oerEccPoint;
            }
            if (choice.intValue() - 128 == 3) {
                logger.debug("EccPoint choice compressedY1");
                oerEccPoint.setEccPointType(EccPointType.COMPRESSED_Y0);
                oerEccPoint.setPublicKey(X509Utils.decodePoint(true, eccPoint.getCompressedY1().getString()));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getCompressedY1().getString()));
                return oerEccPoint;
            }
            if (choice.intValue() - 128 == 4) {
                logger.debug("EccPoint choice Uncompressed");
                oerEccPoint.setEccPointType(EccPointType.UNCOMPRESSED);
                oerEccPoint.setPublicKey(EccPointHolder.getUncompressed(eccPoint.getUncompressed()));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getUncompressed().getEncode()));
                return oerEccPoint;
            }
            logger.error("EccPoint choice is error " + choice.intValue());
            throw new Exception("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        return null;
    }

    private static PublicKey getUncompressed(Uncompressed uncompressed) throws Exception {
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        return X509Utils.convertSM2PublicKey(x, y);
    }
}

