/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.CircularRegion;
import com.xdja.pki.itsca.oer.asn1.ItsAid;
import com.xdja.pki.itsca.oer.asn1.ItsAidSsp;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SubjectType;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TwoDLocation;
import com.xdja.pki.itsca.oer.asn1.ValidityRestriction;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.cert.EccPointHolder;
import com.xdja.pki.itsca.oer.cert.bean.GeographicRegionType;
import com.xdja.pki.itsca.oer.cert.bean.OERCircularRegion;
import com.xdja.pki.itsca.oer.cert.bean.OEREccPoint;
import com.xdja.pki.itsca.oer.cert.bean.OERItsAidSsp;
import com.xdja.pki.itsca.oer.cert.bean.OERPolygonalRegion;
import com.xdja.pki.itsca.oer.cert.bean.OERRectangularRegion;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class TbsCertHolder {
    public static OERTbsCert build(byte[] data) throws Exception {
        Object region;
        ArrayList<OERRectangularRegion> regions;
        TbsCert tbsCert = TbsCert.getInstance(data);
        OctetString subject = tbsCert.getSubjectInfo().getSubjectName();
        String subjectName = new String(subject.getString());
        PublicVerifyKey verifyKey = tbsCert.getSubjectAttribute().getVerifyKey();
        OERTbsCert oerTbsCert = new OERTbsCert();
        OEREccPoint oerSignEccPoint = EccPointHolder.build(verifyKey.getEccPoint().getEncode());
        PublicKey signPublicKey = oerSignEccPoint.getPublicKey();
        oerTbsCert.setSignPublicKeyStr(oerSignEccPoint.getPublicKeyStr());
        oerTbsCert.setSignEccPointType(oerSignEccPoint.getEccPointType());
        SubjectType subjectType = tbsCert.getSubjectInfo().getSubjectType();
        BigInteger type = BigIntegers.fromUnsignedByteArray((byte[])subjectType.getEncode());
        String subType = "";
        if (type.intValue() == 0) {
            subType = "\u6ce8\u518c\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.ENROLLMENT_CREDENTIAL);
        } else if (type.intValue() == 1) {
            subType = "\u6388\u6743\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.AUTHORIZATION_TICKET);
        } else if (type.intValue() == 2) {
            subType = "\u6388\u6743CA\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.AUTHORIZATION_AUTHORITY);
        } else if (type.intValue() == 3) {
            subType = "\u6ce8\u518cCA\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.ENROLLMENT_AUTHORITY);
        } else if (type.intValue() == 4) {
            subType = "\u6839CA\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.ROOT_CA);
        } else if (type.intValue() == 5) {
            subType = "CRL\u7b7e\u53d1\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.CRL_SIGNER);
        } else if (type.intValue() == 6) {
            subType = "\u5047\u540d\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.PSEUDONYM_CERTIFICATE);
        } else if (type.intValue() == 7) {
            subType = "\u5047\u540dCA\u8bc1\u4e66";
            oerTbsCert.setType(SubjectType.PSEUDONYM_AUTHORITY);
        } else {
            throw new Exception("unknown subject type " + type.intValue());
        }
        ValidityRestriction validityRestriction = tbsCert.getValidityRestriction();
        String startTime = "";
        String endTime = "";
        if (null != validityRestriction.getValidityPeriod().getTimeEnd()) {
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeEnd();
            BigInteger time = BigIntegers.fromUnsignedByteArray((byte[])timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(time.longValue()));
        }
        if (null != validityRestriction.getValidityPeriod().getTimeStartAndEnd()) {
            Time32 timeStart = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getStartValidity();
            BigInteger sTime = BigIntegers.fromUnsignedByteArray((byte[])timeStart.getEncode());
            startTime = TimeUtils.getTime(sTime.longValue());
            oerTbsCert.setStartDate(TimeUtils.getTimeFromNumber(sTime.longValue()));
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getEndValidity();
            BigInteger eTime = BigIntegers.fromUnsignedByteArray((byte[])timeEnd.getEncode());
            endTime = TimeUtils.getTime(eTime.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(eTime.longValue()));
        }
        try {
            List<RectangularRegion> rectangularRegions = validityRestriction.getGeographicRegion().getRectangularRegion().getRectangularRegions();
            regions = new ArrayList<OERRectangularRegion>();
            for (RectangularRegion rectangularRegion : rectangularRegions) {
                region = new OERRectangularRegion();
                ((OERRectangularRegion)region).setNorthWestLatitude(rectangularRegion.getNorthWest().getLatitude().getValue());
                ((OERRectangularRegion)region).setNorthWestLongitude(rectangularRegion.getNorthWest().getLongitude().getValue());
                ((OERRectangularRegion)region).setSouthEastLatitude(rectangularRegion.getSouthEast().getLatitude().getValue());
                ((OERRectangularRegion)region).setSouthEastLongitude(rectangularRegion.getSouthEast().getLongitude().getValue());
                regions.add((OERRectangularRegion)region);
            }
            oerTbsCert.setRectangularRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.RECTANGULAR_REGION);
        }
        catch (Exception rectangularRegions) {
            // empty catch block
        }
        try {
            CircularRegion circularRegion = validityRestriction.getGeographicRegion().getCircularRegion();
            OERCircularRegion region2 = new OERCircularRegion();
            BigInteger r = BigIntegers.fromUnsignedByteArray((byte[])circularRegion.getRadius().getEncode());
            region2.setR(r.intValue());
            region2.setLatitude(circularRegion.getCenter().getLatitude().getValue());
            region2.setLongitude(circularRegion.getCenter().getLongitude().getValue());
            oerTbsCert.setCircularRegion(region2);
            oerTbsCert.setRegionType(GeographicRegionType.CIRCULAR_REGION);
        }
        catch (Exception circularRegion) {
            // empty catch block
        }
        try {
            List<TwoDLocation> twoDLocations = validityRestriction.getGeographicRegion().getPolygonalRegion().getTwoDLocations();
            regions = new ArrayList();
            for (TwoDLocation twoDLocation : twoDLocations) {
                region = new OERPolygonalRegion();
                ((OERPolygonalRegion)region).setLatitude(twoDLocation.getLatitude().getValue());
                ((OERPolygonalRegion)region).setLongitude(twoDLocation.getLongitude().getValue());
                regions.add((OERRectangularRegion)region);
            }
            oerTbsCert.setPolygonalRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionType.POLYGONAL_REGION);
        }
        catch (Exception twoDLocations) {
            // empty catch block
        }
        ArrayList<String> itsAidList = new ArrayList<String>();
        try {
            List<ItsAid> itsAid = tbsCert.getSubjectAttribute().getItsAidList().getItsAid();
            for (int i = 0; i < itsAid.size(); ++i) {
                String s = Hex.toHexString((byte[])itsAid.get(i).getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                itsAidList.add(aid);
            }
        }
        catch (Exception itsAid) {
            // empty catch block
        }
        ArrayList<OERItsAidSsp> sspList = new ArrayList<OERItsAidSsp>();
        try {
            List<ItsAidSsp> itsAidSsp = tbsCert.getSubjectAttribute().getItsSspList().getItsAidSsp();
            for (int i = 0; i < itsAidSsp.size(); ++i) {
                OERItsAidSsp ssp = new OERItsAidSsp();
                List<Integer> list = itsAidSsp.get(i).getServiceSpecificPermissionsList();
                ssp.setList(list);
                ItsAid itsAid = itsAidSsp.get(i).getItsAid();
                String s = Hex.toHexString((byte[])itsAid.getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                ssp.setItsAid(aid);
                sspList.add(ssp);
            }
        }
        catch (Exception itsAidSsp) {
            // empty catch block
        }
        try {
            PublicEncryptionKey encryptionKey = tbsCert.getSubjectAttribute().getEncryptionKey();
            OEREccPoint oerEncPoint = EccPointHolder.build(encryptionKey.getPublicKey().getEncode());
            oerTbsCert.setEncPublic(oerEncPoint.getPublicKey());
            oerTbsCert.setEncEccPointType(oerEncPoint.getEccPointType());
            oerTbsCert.setEncPublicKeyStr(oerEncPoint.getPublicKeyStr());
        }
        catch (Exception exception) {
            // empty catch block
        }
        oerTbsCert.setItsAid(itsAidList);
        oerTbsCert.setItsAidSspList(sspList);
        oerTbsCert.setSubjectType(subType);
        oerTbsCert.setStartTime(startTime);
        oerTbsCert.setEndTime(endTime);
        oerTbsCert.setSignPublicKey(signPublicKey);
        oerTbsCert.setSubjectName(subjectName);
        return oerTbsCert;
    }
}

