/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securityaudit.dao;

import com.xdja.pki.ca.core.bean.CertDTO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.securityaudit.dao.models.CertStatusEnum;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ManagerCerSearchDao
extends BaseJdbcDao {
    private static StringBuilder roleTypeSql = new StringBuilder(" AND id IN(select manage_cert_id from admin_role WHERE role_id = :roleId) ");
    private static StringBuilder managerNormalSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 1 AS status FROM manage_cert WHERE type=1 AND after_time > NOW() AND status=1  ").append((CharSequence)roleTypeSql);
    private static StringBuilder managerFreezeSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 2 AS status FROM manage_cert WHERE type=1 AND after_time > NOW() AND status=2  ").append((CharSequence)roleTypeSql);
    private static StringBuilder managerExpiredSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime,4 AS status FROM manage_cert WHERE type=1 AND after_time < NOW()  ").append((CharSequence)roleTypeSql);
    private static StringBuilder revokeSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 3 AS status FROM revoked_manage_cert WHERE type=1 AND after_time > NOW()  ").append((CharSequence)roleTypeSql);
    private static StringBuilder revokeExpiredSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 4 AS status FROM revoked_manage_cert WHERE type=1 AND after_time < NOW()  ").append((CharSequence)roleTypeSql);
    private static StringBuilder expiredSql = new StringBuilder(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime, after_time AS notAfterTime, 4 AS status FROM outdate_manage_cert WHERE type=1  ").append((CharSequence)roleTypeSql);

    public PageInfo getManagerOldCertList(long roleId, int pageNo, int pageSize) {
        try {
            StringBuilder selectSql = new StringBuilder();
            StringBuilder countSql = new StringBuilder();
            selectSql.append((CharSequence)managerFreezeSql).append(" UNION ALL ").append((CharSequence)managerExpiredSql).append(" UNION ALL ").append((CharSequence)revokeSql).append(" UNION ALL ").append((CharSequence)revokeExpiredSql).append(" UNION ALL ").append((CharSequence)expiredSql);
            countSql.append("SELECT COUNT(0) FROM (").append((CharSequence)selectSql).append(") AS result");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("roleId", (Object)roleId);
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.queryForInt(countSql.toString(), (SqlParameterSource)params));
            selectSql.append(" ORDER BY notBeforeTime DESC limit :offset, :pageSize");
            params.addValue("offset", (Object)((pageNo - 1) * pageSize));
            params.addValue("pageSize", (Object)pageSize);
            pageInfo.setDatas((Collection)this.daoTemplate.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertDTO.class)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public PageInfo getCertList(long roleId, String dn, String sn, Integer status, int pageNo, int pageSize) {
        StringBuilder selectSql = new StringBuilder();
        StringBuilder countSql = new StringBuilder();
        StringBuilder andSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("roleId", (Object)roleId);
        if (StringUtils.isNotEmpty((CharSequence)dn)) {
            andSql.append(" AND subject LIKE :dn ");
            params.addValue("dn", (Object)("%" + dn + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)sn)) {
            andSql.append(" AND ( sn LIKE :sgSn OR pair_cert_sn  LIKE :sgSn ) ");
            params.addValue("sgSn", (Object)("%" + sn + "%"));
        }
        StringBuilder pageSql = new StringBuilder();
        pageSql.append(" ORDER BY notBeforeTime DESC LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)((pageNo - 1) * pageSize));
        params.addValue("pageSize", (Object)pageSize);
        PageInfo pageInfo = null;
        countSql.append(" SELECT COUNT(0) FROM ");
        if (status.intValue() == CertStatusEnum.NORMAL.getValue()) {
            selectSql.append((CharSequence)managerNormalSql).append((CharSequence)andSql);
        }
        if (status.intValue() == CertStatusEnum.FREEZE.getValue()) {
            selectSql.append((CharSequence)managerFreezeSql).append((CharSequence)andSql);
        }
        if (status.intValue() == CertStatusEnum.REVOKED.getValue()) {
            selectSql.append((CharSequence)revokeSql).append((CharSequence)andSql);
        }
        if (status.intValue() == CertStatusEnum.OUTDATE.getValue()) {
            selectSql.append((CharSequence)managerExpiredSql).append((CharSequence)andSql).append(" UNION ALL ").append((CharSequence)revokeExpiredSql).append((CharSequence)andSql).append(" UNION ALL ").append((CharSequence)expiredSql).append((CharSequence)andSql);
        }
        countSql.append("( ").append((CharSequence)selectSql).append(" ) AS result");
        pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.queryForInt(countSql.toString(), (SqlParameterSource)params));
        selectSql.append((CharSequence)pageSql);
        pageInfo.setDatas((Collection)this.daoTemplate.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertDTO.class)));
        return pageInfo;
    }
}

