/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitystatistics.dao;

import com.xdja.pki.ca.certmanager.dao.models.RaDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.securitystatistics.dao.models.StatisticsCertDTO;
import com.xdja.pki.ca.securitystatistics.dao.models.StatisticsRaDTO;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class StatisticsDao
extends BaseJdbcDao {
    public List<TemplateDO> getTemplate() {
        return this.daoTemplate.query(TemplateDO.class, (Condition)Cnd.where((String)"type", (String)"=", (Object)1).and("status", "!=", (Object)1).orderBy("name", "asc"));
    }

    public List<RaDO> getRaName() {
        Cnd cnd = Cnd.NEW();
        cnd.orderBy("name", "asc");
        return this.daoTemplate.query(RaDO.class, (Condition)cnd);
    }

    public List<StatisticsRaDTO> getRaStatistics(Integer raID, String startTime, String endTime) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String raReqSql = "";
        if (null != raID) {
            raReqSql = "WHERE ra.id = :raID ";
            params.addValue("raID", (Object)raID);
        }
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = StringUtils.isNotBlank((CharSequence)raReqSql) ? "AND  c.gmt_create >= :startTime  AND c.gmt_create <= :endTime " : "WHERE  c.gmt_create >= :startTime  AND c.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String sql = "SELECT \nCASE WHEN ra_name IS NOT NULL THEN ra_name ELSE \"\u5408\u8ba1\" END AS ra_name,\nSUM(sign_total_count) sign_total_count, SUM(sign_count) sign_count, SUM(update_count) update_count,\nSUM(revoked_count) revoked_count, SUM(frozen_count) frozen_count FROM (\n\nSELECT\nNAME ra_name,\n0 sign_total_count,\n0 sign_count,\n0 update_count,\n0 revoked_count,\n0 frozen_count\nFROM ra \n" + raReqSql + "GROUP BY ra_name\n\nUNION ALL \nSELECT ra.name ra_name, \nCOUNT(IF(c.confirmation_status=2, TRUE, NULL)) sign_total_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NULL, TRUE, NULL)) sign_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NOT NULL, TRUE, NULL)) update_count,\n0 revoked_count,\nSUM(IF(c.confirmation_status=2, frozen_num, 0)) frozen_count\nFROM cert c\nLEFT JOIN ra_cert ON c.id = ra_cert.cert_id \nLEFT JOIN ra ON ra_cert.ra_id = ra.id\n#%%REPLACE_FOR_QUERY%%#\nGROUP BY ra.name\n\nUNION ALL\n\nSELECT ra.name ra_name,\nCOUNT(IF(c.confirmation_status=2, TRUE, NULL)) sign_total_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NULL, TRUE, NULL)) sign_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NOT NULL, TRUE, NULL)) update_count,\nCOUNT(IF(c.status=3 AND c.revoke_reason!=4, TRUE, NULL)) revoked_count,\nSUM(IF(c.confirmation_status=2, frozen_num, 0)) frozen_count\nFROM outdate_cert c\nLEFT JOIN ra_cert ON c.id = ra_cert.cert_id \nLEFT JOIN ra ON ra_cert.ra_id = ra.id\n#%%REPLACE_FOR_QUERY%%#\nGROUP BY ra.name\n\nUNION ALL\n\nSELECT ra.name ra_name,\nCOUNT(IF(c.confirmation_status=2, TRUE, NULL)) sign_total_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NULL, TRUE, NULL)) sign_count,\nCOUNT(IF(c.confirmation_status=2 AND c.old_cert_id IS NOT NULL, TRUE, NULL)) update_count,\nCOUNT(IF(c.revoke_reason!=4, TRUE, NULL)) revoked_count,\nSUM(IF(c.confirmation_status=2, frozen_num, 0)) frozen_count\nFROM revoked_cert c\nLEFT JOIN ra_cert ON c.id = ra_cert.cert_id \nLEFT JOIN ra ON ra_cert.ra_id = ra.id\n#%%REPLACE_FOR_QUERY%%#\nGROUP BY ra.name\n\n) AS t GROUP BY ra_name WITH ROLLUP\n";
        sql = sql.replaceAll("#%%REPLACE_FOR_QUERY%%#", raReqSql + timeReqSql);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsRaDTO.class));
    }

    public List<StatisticsCertDTO> getCertStatistics(Integer certTemplateNumber, Integer raID, String startTime, String endTime) {
        String certTemplateReqSql;
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (null != certTemplateNumber) {
            certTemplateReqSql = "WHERE t.id = :certTemplateNumber ";
            params.addValue("certTemplateNumber", (Object)certTemplateNumber);
        } else {
            certTemplateReqSql = "WHERE t.type = 1 AND t.status != 1 ";
        }
        String raReqSql = "";
        if (null != raID) {
            raReqSql = "AND ra_cert.ra_id = :raID ";
            params.addValue("raID", (Object)raID);
        }
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = "AND  c.gmt_create >= :startTime  AND c.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String sql = "SELECT \nCASE WHEN template_name IS NOT NULL THEN template_name ELSE \"\u5408\u8ba1\" END AS template_name,\nSUM(normal) normal, SUM(revoked) revoked, SUM(expired) expired, SUM(frozen) frozen, SUM(total) total FROM (\n\n       SELECT\n       NAME template_name,\n       0 normal,\n       0 revoked,\n       0 expired,\n       0 frozen,\n       0 total\n       FROM template AS t\n" + certTemplateReqSql + "       GROUP BY id\n       \n       UNION ALL\n\n       SELECT \n       t.name template_name,\n       COUNT(IF(c.not_after_time > NOW() AND c.status=1, TRUE, NULL)) normal,\n       0 revoked,\n       COUNT(IF(c.not_after_time <= NOW(), TRUE, NULL)) expired,\n       COUNT(IF(c.status=2, TRUE, NULL)) frozen,\n       COUNT(*) AS total\n       FROM cert c\n       LEFT JOIN template t ON c.template_id = t.id\n       LEFT JOIN ra_cert ON c.id = ra_cert.cert_id\n       #%%REPLACE_FOR_QUERY%%#\n       GROUP BY c.template_id\n\n       UNION ALL\n\n       SELECT \n       t.name template_name,\n       0 normal,\n       COUNT(IF(c.after_time > NOW(), TRUE, NULL)) revoked,\n       COUNT(IF(c.after_time <= NOW(), TRUE, NULL)) expired,\n       0 frozen,\n       COUNT(*) AS total\n       FROM revoked_cert c\n       LEFT JOIN template t ON c.template_id = t.id\n       LEFT JOIN ra_cert ON c.id = ra_cert.cert_id\n       #%%REPLACE_FOR_QUERY%%#\n       GROUP BY c.template_id\n       \n       UNION ALL\n       \n       SELECT \n       t.name template_name,\n       0 normal,\n       0 revoked,\n       COUNT(*) AS expired,\n       0 frozen,\n       COUNT(*) AS total\n       FROM outdate_cert c\n       LEFT JOIN template t ON c.template_id = t.id\n       LEFT JOIN ra_cert ON c.id = ra_cert.cert_id\n       #%%REPLACE_FOR_QUERY%%#\n       GROUP BY c.template_id\n\n) AS t GROUP BY template_name WITH ROLLUP\n";
        sql = sql.replaceAll("#%%REPLACE_FOR_QUERY%%#", certTemplateReqSql + raReqSql + timeReqSql);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCertDTO.class));
    }
}

