/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.ldap.service.impl;

import com.xdja.pki.ca.core.CrlConstants;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CrlUtil;
import com.xdja.pki.ca.ldap.service.CrlLdapUrlService;
import com.xdja.pki.ca.ldap.service.url.LdapUrlUtil;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CrlLdapUrlServiceImpl
implements CrlLdapUrlService {
    public LdapOcspUrlVO getLdapOcspUrl(BigInteger sn, String subject, CaInfoVO caInfoVO, boolean isCA, Integer templateId) {
        LdapOcspUrlVO ldapOcspUrlVO = new LdapOcspUrlVO();
        try {
            if (null != caInfoVO.getCrlConfig() && CrlPublishEnum.isSignCRL((Integer)caInfoVO.getCrlConfig().getCrlPublish())) {
                String rootCertUrl;
                String userCertUrl;
                String drlUrl;
                int flag;
                LdapUrlUtil ldapUrlUtil = new LdapUrlUtil();
                int n = CrlUtil.computeSnFragmentantation((BigInteger)sn, (int)caInfoVO.getCrlConfig().getCertCounts());
                String crlUrl = ldapUrlUtil.getCrl(caInfoVO, n, flag = null == templateId ? CrlConstants.COMMON_CRL_TEMPLATE_ID * CrlConstants.TRANSLATION_17 + n : templateId * CrlConstants.TRANSLATION_17 + n, isCA);
                if (StringUtils.isNotBlank((CharSequence)crlUrl)) {
                    ldapOcspUrlVO.setCrlLdapUrl(crlUrl);
                }
                if (caInfoVO.getCrlConfig().isDelta() && StringUtils.isNotBlank((CharSequence)(drlUrl = ldapUrlUtil.getDrl(caInfoVO, n, flag, isCA)))) {
                    ldapOcspUrlVO.setDrlLdapUrl(drlUrl);
                }
                if (StringUtils.isNotBlank((CharSequence)(userCertUrl = ldapUrlUtil.getCertDownloadUrl(caInfoVO, subject, isCA)))) {
                    ldapOcspUrlVO.setCertLdapUrl(userCertUrl);
                }
                if (StringUtils.isNotBlank((CharSequence)(rootCertUrl = ldapUrlUtil.getRootCertDownloadUrl(caInfoVO)))) {
                    ldapOcspUrlVO.setRootCertLdapUrl(rootCertUrl);
                }
            }
            if (caInfoVO.isOcsp() && null != caInfoVO.getOcspConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getOcspConfig().getNetworkURL())) {
                ldapOcspUrlVO.setNetworkUrl(caInfoVO.getOcspConfig().getNetworkURL());
            }
            if (StringUtils.isNotBlank((CharSequence)caInfoVO.getCertPolicy())) {
                ldapOcspUrlVO.setCertPolicy(caInfoVO.getCertPolicy());
            }
            if (null != caInfoVO.getRootCert()) {
                ldapOcspUrlVO.setRootCert(caInfoVO.getRootCert());
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8ba1\u7b97\u8bc1\u4e66\u5206\u7247CRL\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        return ldapOcspUrlVO;
    }
}

