/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.ldap.service.url;

import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.CrlConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ldap.sdk.ca.LDAPUrlUtils;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;

public class LdapUrlUtil {
    public static final String CRL_FORMAT = ".crl";
    public static final String CRL_NAME_HEAD = "crl";
    public static final String ARL_NAME_HEAD = "arl";
    public static final String DRL_NAME_HEAD = "drl";
    public static final String ISSUER_DRL_NAME_HEAD = "adrl";

    private String getCrl(CaInfoVO caInfoVO, int n) throws InvalidNameException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish()) && StringUtils.isNotBlank((CharSequence)crlConfigBean.getCrlRemoteURL())) {
            return crlConfigBean.getCrlRemoteURL() + CRL_NAME_HEAD + n + CRL_FORMAT;
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL())) {
            return LDAPUrlUtils.genCertCrlLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)caInfoVO.getSubject(), (int)n, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    private String getArl(CaInfoVO caInfoVO, int n) throws InvalidNameException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish()) && StringUtils.isNotBlank((CharSequence)crlConfigBean.getCrlRemoteURL())) {
            return crlConfigBean.getCrlRemoteURL() + ARL_NAME_HEAD + n + CRL_FORMAT;
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL())) {
            return LDAPUrlUtils.genCertArlLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)caInfoVO.getSubject(), (int)n, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    public String getCrl(CaInfoVO caInfoVO, int n, int flag, boolean isCA) throws InvalidNameException {
        if (isCA) {
            return this.getArl(caInfoVO, n);
        }
        return this.getCrl(caInfoVO, flag);
    }

    private String getDrl(CaInfoVO caInfoVO, int n) throws InvalidNameException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish()) && StringUtils.isNotBlank((CharSequence)crlConfigBean.getCrlRemoteURL())) {
            return crlConfigBean.getCrlRemoteURL() + DRL_NAME_HEAD + n + CRL_FORMAT;
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL())) {
            return LDAPUrlUtils.genCertCrlDrlLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)caInfoVO.getSubject(), (int)n, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    private String getADrl(CaInfoVO caInfoVO, int n) throws InvalidNameException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish()) && StringUtils.isNotBlank((CharSequence)crlConfigBean.getCrlRemoteURL())) {
            return crlConfigBean.getCrlRemoteURL() + ISSUER_DRL_NAME_HEAD + n + CRL_FORMAT;
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL())) {
            return LDAPUrlUtils.genCertArlDrlLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)caInfoVO.getSubject(), (int)n, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    public String getDrl(CaInfoVO caInfoVO, int n, int flag, boolean isCa) throws InvalidNameException {
        if (isCa) {
            return this.getADrl(caInfoVO, n);
        }
        return this.getDrl(caInfoVO, flag);
    }

    public String getCertDownloadUrl(CaInfoVO caInfoVO, String subject, boolean isCA) {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL())) {
            if (isCA) {
                return LDAPUrlUtils.genCACertSubjectLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)subject, (String)caInfoVO.getBaseDn());
            }
            return LDAPUrlUtils.genUserCertSubjectLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)subject, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    public String getRootCertDownloadUrl(CaInfoVO caInfoVO) throws NamingException, CertificateEncodingException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish()) && caInfoVO.isLadp() && null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getSlaveURL()) && null != caInfoVO.getRootCert()) {
            return LDAPUrlUtils.genCertAuthorityLdapUri((String)caInfoVO.getLdapConfig().getSlaveURL(), (String)CertUtil.getSubjectByX509Cert((X509Certificate)caInfoVO.getRootCert()), (String)caInfoVO.getBaseDn());
        }
        return "";
    }
}

