package com.xdja.ca.sdk;

import java.io.Serializable;

/**
 * 通用基础CMP消息体
 * @author syg
 */
public class BaseCMPInfo implements Serializable {

    /**
     * SenderNonce. This is base64 encoded bytes
     */
    private byte[] senderNonce = null;
    /**
     * RecipientNonce in a response is the senderNonce from the request. This is base64 encoded bytes
     */
    private byte[] recipientNonce = null;

    /** transaction id */
    private byte[] transactionId = null;

    private int nonce = 0;

    /** used to match request with response */
    private long requestId = -1;

    public BaseCMPInfo() {
    }

    public BaseCMPInfo(byte[] senderNonce, byte[] recipientNonce, byte[] transactionId, long requestId, int nonce) {
        this.senderNonce = senderNonce;
        this.recipientNonce = recipientNonce;
        this.transactionId = transactionId;
        this.requestId = requestId;
    }

    public byte[] getSenderNonce() {
        return senderNonce;
    }

    public void setSenderNonce(byte[] senderNonce) {
        this.senderNonce = senderNonce;
    }

    public byte[] getRecipientNonce() {
        return recipientNonce;
    }

    public void setRecipientNonce(byte[] recipientNonce) {
        this.recipientNonce = recipientNonce;
    }

    public byte[] getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(byte[] transactionId) {
        this.transactionId = transactionId;
    }

    public long getRequestId() {
        return requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }


    public int getNonce() {
        return nonce;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }
}
