package com.xdja.ca.sdk;

import java.io.Serializable;

/**
 * 通用返回结果Bean
 * @author syg
 *
 */
public class Result implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 执行结果
	 */
	private boolean isSuccess = false;
	/**
	 * 错误码
	 */
	private int errCode;
	/**
	 *  错误信息
	 */
	private String errMsg;
	/**
	 * 业务数据
	 */
	private Object info;
	
	public Result() {}

	public Result(boolean isSuccess) {
		this.isSuccess = isSuccess;
	}

	public Result(boolean isSuccess, Object info) {
		super();
		this.isSuccess = isSuccess;
		this.info = info;
	}
	
	public Result(int errCode, String errMsg) {
		this.errCode = errCode;
		this.errMsg = errMsg;
	}

	public Object getInfo() {
		return info;
	}

	public void setInfo(Object info) {
		this.info = info;
	}

	public boolean isSuccess() {
		return isSuccess;
	}

	public void setSuccess(boolean success) {
		isSuccess = success;
	}

	public int getErrCode() {
		return errCode;
	}

	public void setErrCode(int errCode) {
		this.errCode = errCode;
	}

	public String getErrMsg() {
		return errMsg;
	}

	public void setErrMsg(String errMsg) {
		this.errMsg = errMsg;
	}
}
