package com.xdja.ca.test;

import com.alibaba.fastjson.JSON;
import com.xdja.ca.sdk.CmpApi;
import com.xdja.ca.sdk.Result;
import com.xdja.ca.utils.P10Utils;
import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.ca.utils.SdkFileUtils;
import com.xdja.ca.vo.TempInfo;
import com.xdja.ca.vo.UpdateCertInfo;
import com.xdja.ca.vo.UserCertInfo;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CmpRaTest {
    protected static transient final Logger logger = Logger.getLogger(CmpRaTest.class.getClass());
    static final ASN1ObjectIdentifier smAlgorithm = new ASN1ObjectIdentifier("1.2.156.10197.1");

    static final ASN1ObjectIdentifier SM3withSM2 = smAlgorithm.branch("501");

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());

        CmpApi cmpApi = new CmpApi();

        // 生成事务id  TODO 定义生成
        SecureRandom secureRandom = new SecureRandom();
        byte[] trans = new byte[16];
        secureRandom.nextBytes(trans);
        byte[] transId = trans;


        String url = "http://11.12.85.40:8080/cmp/ca";
        // 请求获取随机数recipNonce
//        byte[] recipNonce = cmpApi.sendRandomNumReq(transId, url);
//        logger.info("transId:" + Base64.toBase64String(transId) + " 的recipNonce：" + new String(recipNonce));

        // CA证书   TODO 从本地获取上级CA证书
        String certStr = SdkFileUtils.readByBytes("F:\\cmp_cert\\root.cer");
        X509Certificate cacert = SdkCertUtils.getCertFromStr(certStr);


        // 申请签发证书
        String raDN = "CN = gr3gr3egvreg,L = 金水区,L = 郑州市,C = CN";
        String caDN = "CN = grgrgvreg,L = 金水区,L = 郑州市,C = CN";
        String userCertDN = "CN = syg,L = 光明区,L = 郑州市,C = CN";
        TempInfo tempInfo = new TempInfo();
        tempInfo.setTempNo("temp_no.1");
        List<TempParasInfo> list = new ArrayList<TempParasInfo>();
        list.add(new TempParasInfo("身份证号","412898236482763487264"));
        list.add(new TempParasInfo("税号","001001002"));
        tempInfo.setTempParas(JSON.toJSONString(list));
        String base6410 = SdkFileUtils.readByBytes("F:\\cmp_cert\\certreq.p10");
        Result result = new Result();

//        logger.info("=============签发证书申请 【开始】===================");
//        result = cmpApi.sendIssuerCertReqMessages(raDN, caDN, transId, 111, tempInfo, base6410, userCertDN, url);
//        logger.info("=============签发证书申请 【结果输出】===================");
//        if (result.isSuccess()){
//            UserCertInfo userCertInfo = (UserCertInfo) result.getInfo();
//            logger.info("成功结果：userCertInfo:"+JSON.toJSONString(userCertInfo));
//            SdkFileUtils.saveAs(userCertInfo.getSignCert(),"F:\\cmp_cert\\aaa.cer");
//        }else {
//            String errMsg = result.getErrMsg();
//            int errCode = result.getErrCode();
//            Object info = result.getInfo();
//            logger.info("失败结果：errCode:"+errCode+" errMsg："+errMsg +" info:"+info);
//        }
//        logger.info("=============签发证书申请 【结束】===================");


        logger.info("=============更新证书申请 【开始】===================");
        UpdateCertInfo updateCertInfo = new UpdateCertInfo();
        byte[] publicKey = P10Utils.p10ToPublicKey(base6410).getEncoded();
        updateCertInfo.setPublicKey(publicKey);
        updateCertInfo.setSignAlgo(SM3withSM2);
        String signSn= "signSn";
        result = cmpApi.sendUpdateCertReqMessages(raDN, caDN, transId, 10, tempInfo, updateCertInfo, signSn, userCertDN, url);
        logger.info("=============更新证书申请 【结果输出】===================");
        if (result.isSuccess()) {
            UserCertInfo userCertInfo = (UserCertInfo) result.getInfo();
            logger.info("成功结果：userCertInfo:" + JSON.toJSONString(userCertInfo));
            SdkFileUtils.saveAs(userCertInfo.getSignCert(), "F:\\cmp_cert\\bbb.cer");
        } else {
            String errMsg = result.getErrMsg();
            int errCode = result.getErrCode();
            Object info = result.getInfo();
            logger.info("失败结果：errCode:" + errCode + " errMsg：" + errMsg + " info:" + info);
        }
        logger.info("=============更新证书申请 【结束】===================");

//        logger.info("=============撤销证书申请 【开始】===================");
//        result = cmpApi.sendRecoveryCertReqMessages(raDN, caDN, transId, 111, "signSn", userCertDN, url);
//        if (result.isSuccess()){
//            logger.info("成功结果：result:"+JSON.toJSONString(result));
//        }else {
//            String errMsg = result.getErrMsg();
//            int errCode = result.getErrCode();
//            Object info = result.getInfo();
//            logger.info("失败结果：errCode:"+errCode+" errMsg："+errMsg +" info:"+info);
//        }
//        logger.info("=============撤销证书申请 【结束】===================");

        logger.info("=============确认消息 【开始】===================");
        logger.info("=============确认消息 【结束】===================");

        logger.info("=============错误消息 【开始】===================");
        logger.info("=============错误消息 【结束】===================");

    }
}
