package com.xdja.ca.utils;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

import java.security.PublicKey;
import java.security.Security;

/**
 * P10解析结构体
 */
public class P10Utils {

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
    /**
     * 解析标准Pem格式的P10内容(去头尾)
     * @param pemP10
     * @return
     */
    private static String unFormatP10(String pemP10){
        String p10Vaule = null;
        String P10_HEAD = "-----BEGIN CERTIFICATE REQUEST-----";
        String P10_TAIL = "-----END CERTIFICATE REQUEST-----";
        pemP10 = pemP10.replace(P10_HEAD, "");
        pemP10 = pemP10.replace(P10_TAIL, "");
        pemP10 = pemP10.replace("\r", "");
        pemP10 = pemP10.replace("\n", "");
        p10Vaule = pemP10;
        return p10Vaule;
    }

    /**
     * 从P10中获取DN
     * @param p10
     * @return
     */
    public static String p10ToCertDn(String p10) {
        String p10Vaule = P10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode(p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getCertificationRequestInfo().getSubject().toString();
        } catch (Exception e) {
            return null;
        }
    }


    /**
     * 从P10中获取公钥
     *
     * @param p10
     * @return
     */
    public static PublicKey p10ToPublicKey(String p10) {
        String p10Vaule = P10Utils.unFormatP10(p10);
        byte[] bsCert = Base64.decode(p10Vaule);
        try {
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(bsCert);
            PublicKey pk = re.getPublicKey("BC");
            return pk;
        } catch (Exception e) {
            return null;
        }
    }
    /**
     * 从P10中获取签名值
     * @param p10
     * @return
     */
    public static String p10ToSignValue(String p10) {
        String p10Vaule = P10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode(p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignature().toString();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 从P10中获取签名算法
     * @param p10
     * @return
     */
    public static ASN1ObjectIdentifier p10ToSignAlgo(String p10) {
        String p10Vaule = P10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode(p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignatureAlgorithm().getAlgorithm();
        } catch (Exception e) {
            return null;
        }
    }
}
