package com.xdja.ca.utils;

import org.apache.log4j.Logger;

import java.io.*;

/**
 * 文件上传下载工具类
 * syg
 */
public class SdkFileUtils {

    protected static transient final Logger logger = Logger.getLogger(SdkFileUtils.class.getClass());

    /**
     * 以字节为单位读取文件，通常用于读取二进制文件，如图片
     *
     * @param path
     * @return
     */
    public static String readByBytes(String path) {
        String content = null;
        try {
            InputStream inputStream = new FileInputStream(path);
            StringBuffer sb = new StringBuffer();
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = inputStream.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, c, "utf-8"));
            }
            content = sb.toString();
            inputStream.close();
        } catch (Exception e) {
            logger.error("以字节为单位读取文件"+ e.getMessage());
            throw new RuntimeException("以字节为单位读取文件异常"+e.getMessage(),e);
        }
        return content;
    }

    /**
     * 以行为单位读取文件，常用于读取面向行的格式化文件
     *
     * @param path
     * @return
     */
    public static String readByLines(String path) {
        String content = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(path), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String temp = null;

            while ((temp = bufferedReader.readLine()) != null) {
                sb.append(temp);
            }
            content = sb.toString();
            bufferedReader.close();
        } catch (Exception e) {
            logger.error("以行为单位读取文件"+ e.getMessage());
            throw new RuntimeException("以行为单位读取文件异常"+e.getMessage(), e);
        }
        return content;
    }

    /**
     * 以字符为单位读取文件，常用于读取文本文件
     *
     * @param path
     * @return
     */
    public static String readByChars(String path){
        String content = null;

        try {
            Reader reader = new InputStreamReader(new FileInputStream(path), "utf-8");
            StringBuffer sb = new StringBuffer();
            char[] tempchars = new char[1024];
            while (reader.read(tempchars) != -1) {
                sb.append(tempchars);
            }
            content = sb.toString();
            reader.close();
        } catch (Exception e) {
            logger.error("以字符为单位读取文件"+ e.getMessage());
            throw new RuntimeException(" 以字符为单位读取文件异常"+e.getMessage(),e);
        }
        return content;
    }


    /**
     * 把内容content写的path文件中
     *
     * @param content
     * @param path
     * @return
     */
    public static boolean saveAs(String content, String path) {
        FileWriter fw = null;
        try {
            synchronized (SdkFileUtils.class) {
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                fw = new FileWriter(file, false);
                if (content != null) {
                    fw.write(content);
                }
            }
        } catch (IOException e) {
            logger.error("写入配置文件异常"+ e.getMessage());
            throw new RuntimeException("写入配置文件异常"+e.getMessage());
        } finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                } catch (IOException e) {
                    logger.error("写入配置文件异常"+ e.getMessage());
                    throw new RuntimeException("写入配置文件异常"+e.getMessage(),e);
                }
            }
        }
        return true;
    }

    /**
     * 向文件保存内容 （字符串）
     *
     * @param content 待保存内容
     * @param path 文件全路径
     * @throws IOException
     */
    public static void saveFile(String content, String path) {
        FileWriter fw = null;

        try {
            synchronized (SdkFileUtils.class) {
                fw = new FileWriter(new File(path), false);

                if (content != null) {
                    fw.write(content);
                }

                fw.flush();
            }
        } catch (IOException e) {
            logger.error("写入配置文件异常"+ e.getMessage());
            throw new RuntimeException("写入配置文件异常" + e.getMessage(), e);
        } finally {
            if (fw != null) {
                try {
                    fw.close();
                } catch (IOException e) {
                    logger.error("关闭文件写入流异常"+ e.getMessage());
                }
            }
        }
    }

    /**
     * 向文件保存内容 (字节)
     *
     * @param content 待保存内容
     * @param path 文件全路径
     * @throws IOException
     */
    public static void saveFile(byte[] content, String path) {
        OutputStream out = null;
        try {
            synchronized (SdkFileUtils.class) {
                out = new FileOutputStream(new File(path), false);
                InputStream is = new ByteArrayInputStream(content);
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = is.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
                is.close();
                out.close();
            }
        } catch (IOException e) {
            logger.error("写入配置文件异常"+ e.getMessage());
            throw new RuntimeException("写入配置文件异常" + e.getMessage(), e);
        } finally {
            if (out != null) {
                try {
                    out.close();
//                    ScriptUtils.executeScript(PathConstants.SHELL_SCRIPT_CONF + "/yunhsm_modify.sh");
                } catch (IOException e) {
                    logger.error("关闭文件写入流异常"+ e.getMessage());
                }
            }
        }
    }


    /**
     * 读取文件二进制内容
     * @param path
     * @return
     * @throws IOException
     */
	public static byte[] readByBinary(String path) {
        InputStream inputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(path);
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = inputStream.read(bytes)) != -1) {
                baos.write(bytes, 0, c);
            }
            inputStream.close();
        } catch (Exception e) {
            throw new RuntimeException("读取文件二进制内容异常"+e.getMessage(), e);
        }
        return baos.toByteArray();
    }

	/**
	 * 向文件写入二进制数据
	 * @param path
	 * @param datas
	 * @throws IOException
	 */
	public static void writeByBinary(String path, byte[] datas) throws IOException {
		File file = new File(path);
        if (!file.getParentFile().exists()){
            boolean mkdir = file.getParentFile().mkdir();
            if (!mkdir){
                throw new RuntimeException("创建目标文件所在目录失败！");
            }
        }
		if (!file.exists()) {
			file.createNewFile();
		}
		OutputStream os = new FileOutputStream(path);
		os.write(datas);
		os.close();
	}
	
	/**
	 * 将指定文件写入到输出流中
	 * 
	 * @param out 输出流
	 * @param file 待写入输出流文件
	 * @throws Exception
	 */
	public final static void write(OutputStream out, File file) throws Exception {
		InputStream in = null;
		
		try {
			in = new FileInputStream(file);
			
			byte[] data = new byte[1024];
			int size = 0;
			while ((size = in.read(data)) != -1) {
				out.write(data, 0, size);
			}
		} finally {
			if (null != in) {
				in.close();
			}
		}
	}
}


