/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.helper;

import com.xdja.ca.asn1.DigestObjectIdentifiers;
import com.xdja.ca.asn1.NISTObjectIdentifiers;
import com.xdja.ca.asn1.RsaObjectIdentifiers;
import com.xdja.ca.asn1.SM2EnvelopedData;
import com.xdja.ca.asn1.SM2ObjectIdentifiers;
import com.xdja.ca.asn1.SymmetryObjectIdentifiers;
import com.xdja.ca.bean.BaseCMPInfo;
import com.xdja.ca.bean.SignedAndEnvelopedData;
import com.xdja.ca.constant.SdkCommonVariable;
import com.xdja.ca.constant.SdkConstants;
import com.xdja.ca.error.ErrorEnum;
import com.xdja.ca.pkcs7.Pkcs7Utils;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.ca.utils.ClientHttpUtils;
import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.ca.utils.SdkHsmUtils;
import com.xdja.ca.utils.SdkJsonUtils;
import com.xdja.ca.vo.FreeText;
import com.xdja.ca.vo.ManagerCertInfo;
import com.xdja.ca.vo.UserCertInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.KeyRecRepContent;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpMessageHelper {
    public static Logger logger = LoggerFactory.getLogger(CmpMessageHelper.class);

    public static CertRequest genCertRequest(int certValidity, String userCertDN, byte[] publicKey, ASN1ObjectIdentifier signAlg, long certReqId, int certType) throws Exception {
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        OptionalValidity myOptionalValidity = null;
        if (certValidity != 0) {
            Date notBefore = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(notBefore);
            calendar.add(5, certValidity);
            Date notAfter = calendar.getTime();
            ASN1EncodableVector optionalValidityV = new ASN1EncodableVector();
            optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new Time(notBefore)));
            optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new Time(notAfter)));
            myOptionalValidity = OptionalValidity.getInstance((Object)new DERSequence(optionalValidityV));
            myCertTemplate.setValidity(myOptionalValidity);
        }
        myCertTemplate.setVersion(1);
        myCertTemplate.setSigningAlg(new AlgorithmIdentifier(signAlg));
        myCertTemplate.setSubject(DnUtil.getRFC4519X500Name(userCertDN));
        SubjectPublicKeyInfo keyInfo = null;
        if (publicKey != null) {
            PublicKey pubKey;
            if (SM2ObjectIdentifiers.sm2SignWithSm3.equals((Object)signAlg)) {
                if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
                } else {
                    pubKey = SdkCertUtils.convertSM2PublicKey(Base64.toBase64String((byte[])publicKey));
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
                }
            } else if (NISTObjectIdentifiers.nistSignAlgorithm.equals((Object)signAlg)) {
                if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
                } else {
                    pubKey = SdkCertUtils.convertECPublicKey(Base64.toBase64String((byte[])publicKey), NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1));
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
                }
            } else if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
            } else {
                KeyFactory kf = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])publicKey), BigInteger.valueOf(65537L));
                PublicKey pubKey2 = kf.generatePublic(rsaPublicKeySpec);
                keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey2.getEncoded());
            }
        }
        myCertTemplate.setPublicKey(keyInfo);
        ExtensionsGenerator extgen = new ExtensionsGenerator();
        try {
            int bcku = 0;
            if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                bcku = 192;
            } else if (certType == SdkConstants.CERT_TYPE_ENC_3) {
                bcku = 56;
            }
            X509KeyUsage ku = new X509KeyUsage(bcku);
            extgen.addExtension(Extension.keyUsage, false, (ASN1Encodable)ku);
        }
        catch (IOException e) {
            logger.info("\u5c01\u88c5CertRequest\u7684\u6269\u5c55\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            throw new IOException();
        }
        myCertTemplate.setExtensions(extgen.generate());
        return new CertRequest(new ASN1Integer(certReqId), myCertTemplate.build(), null);
    }

    public static CertReqMessages genCertReqMessages(CertRequest[] certRequests) {
        CertReqMsg[] certReqMsgs = new CertReqMsg[certRequests.length];
        for (int i = 0; i < certRequests.length; ++i) {
            CertReqMsg certReqMsg;
            if (certRequests[i] == null) continue;
            certReqMsgs[i] = certReqMsg = new CertReqMsg(certRequests[i], null, null);
        }
        CertReqMessages myCertReqMessages = new CertReqMessages(certReqMsgs);
        return myCertReqMessages;
    }

    public static PKIMessage genPKIMessage(int keyIndex, String pwd, byte[] privateKey, X509Certificate caCert, String raDN, String caDN, int tagNo, byte[] recipNonce, byte[] senderNonce, String transId, ASN1Encodable asn1Encodable, String freeText, boolean isUseHsm) throws Exception {
        PKIBody myPKIBody = new PKIBody(tagNo, asn1Encodable);
        GeneralName raName = new GeneralName(DnUtil.getRFC4519X500Name(raDN));
        GeneralName caName = new GeneralName(DnUtil.getRFC4519X500Name(caDN));
        PKIHeaderBuilder myPKIHeader = new PKIHeaderBuilder(1, raName, caName);
        myPKIHeader.setMessageTime(new ASN1GeneralizedTime(new Date()));
        myPKIHeader.setSenderNonce((ASN1OctetString)new DEROctetString(senderNonce));
        myPKIHeader.setRecipNonce((ASN1OctetString)new DEROctetString(recipNonce));
        myPKIHeader.setTransactionID(transId.getBytes());
        String sigAlgName = caCert.getSigAlgName();
        ASN1ObjectIdentifier protectionAlg = null;
        protectionAlg = "SM3withSM2".equalsIgnoreCase(sigAlgName) ? SM2ObjectIdentifiers.sm2SignWithSm3 : ("SHA1withRSA".equalsIgnoreCase(sigAlgName) ? RsaObjectIdentifiers.sha1WithRSA : ("SHA256withRSA".equalsIgnoreCase(sigAlgName) ? RsaObjectIdentifiers.sha256WithRSA : NISTObjectIdentifiers.nistSignAlgorithm));
        logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + sigAlgName + " \u7b97\u6cd5oid\u4e3a\uff1a" + protectionAlg.getId());
        myPKIHeader.setProtectionAlg(new AlgorithmIdentifier(protectionAlg));
        myPKIHeader.setFreeText(new PKIFreeText(freeText));
        PKIHeader myHeader = myPKIHeader.build();
        String protectionValue = null;
        protectionValue = privateKey == null ? SdkHsmUtils.signByYunHsm(sigAlgName, keyIndex, pwd, Base64.toBase64String((byte[])CmpMessageHelper.getProtectedBytes(myHeader, myPKIBody))) : SdkHsmUtils.signByBC(sigAlgName, privateKey, Base64.toBase64String((byte[])CmpMessageHelper.getProtectedBytes(myHeader, myPKIBody)));
        if (StringUtils.isBlank((CharSequence)protectionValue)) {
            throw new Exception("\u4f7f\u7528\u5bc6\u7801\u673a\u7b7e\u540d\u5931\u8d25");
        }
        PKIMessage pkiMessage = new PKIMessage(myHeader, myPKIBody, new DERBitString(Base64.decode((String)protectionValue)));
        return pkiMessage;
    }

    public static SdkResult genErrorPKIMsg(int keyIndex, String pwd, byte[] privateKey, X509Certificate caCert, X509Certificate[] caCerts, String raSignSn, int applyUserType, String errMsg, int errCode, String raDN, String caDN, byte[] recipNonce, byte[] senderNonce, String transId, String url, String protectAlgName, boolean isHttps, boolean isUseHsm) {
        SdkResult sdkResult = new SdkResult();
        logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 1.\u5c01\u88c5ErrorMsgContent\u7ed3\u6784\u4f53");
        ErrorMsgContent errorMsgContent = null;
        try {
            errorMsgContent = CmpMessageHelper.genErrorMsgContent(PKIStatus.rejection, errCode, errMsg);
        }
        catch (Exception e) {
            logger.error("=============== \u5c01\u88c5ErrorMsgContent\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.ERROR_MSG_CONTENT_EXCEPTION);
            return sdkResult;
        }
        logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 2.\u5c01\u88c5PKIMesage\u7ed3\u6784\u4f53");
        FreeText freeText = new FreeText();
        freeText.setApplyUserType(applyUserType);
        freeText.setRaSignSn(raSignSn);
        PKIMessage errorPKIMessage = null;
        try {
            errorPKIMessage = CmpMessageHelper.genPKIMessage(keyIndex, pwd, privateKey, caCert, raDN, caDN, 23, recipNonce, senderNonce, transId, (ASN1Encodable)errorMsgContent, SdkJsonUtils.object2Json(freeText), isUseHsm);
        }
        catch (Exception e) {
            logger.error("=============== \u5c01\u88c5ErrorMsg\u7684PKIMessage\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 3.\u53d1\u9001\u8bc1\u4e66\u9519\u8bef\u6d88\u606f");
        SdkResult postResult = null;
        try {
            postResult = ClientHttpUtils.sendApacheClientRequest(keyIndex, pwd, privateKey, errorPKIMessage.getEncoded(), null, url, "application/pkixcmp", raSignSn, caCerts, protectAlgName, isHttps, isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setError(postResult.getError());
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.error(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        return sdkResult;
    }

    public static SdkResult checkCmpHeaderAndSign(byte[] pkiMessage, String raName, String caName, byte[] senderNonce, String transId, X509Certificate caCert, boolean isUseHsm) throws NamingException {
        logger.debug("CmpApi.checkCmpHeaderAndSign>>>>> raName:" + raName + " caName:" + caName + " senderNonce:" + Base64.toBase64String((byte[])senderNonce) + " transId:" + transId + " caCert:" + SdkCertUtils.certToFullB64(caCert));
        SdkResult sdkResult = new SdkResult();
        PKIMessage respObject = PKIMessage.getInstance((Object)pkiMessage);
        if (respObject == null) {
            logger.error(" =================== No pkiMessage response message.");
            sdkResult.setError(ErrorEnum.NO_PKI_MESSAGE_RESP_MESSAGE);
            return sdkResult;
        }
        PKIHeader header = respObject.getHeader();
        if (header == null) {
            logger.error(" =================== No header in response message.");
            sdkResult.setError(ErrorEnum.NO_HEADER_IN_RESPONSE_MESSAGE);
            return sdkResult;
        }
        logger.info("=================" + header.getSender().getName().toString());
        X500Name caDN = DnUtil.getRFC4519X500Name(header.getSender().getName());
        if (caDN == null || !caDN.toString().equalsIgnoreCase(DnUtil.getRFC4519X500Name(caName).toString())) {
            logger.error(" =================== received caDn is:" + caDN.toString() + " but expect:" + DnUtil.getRFC4519X500Name(caName).toString());
            sdkResult.setError(ErrorEnum.RECEIVED_CA_DN_NOT_EXPECT);
            return sdkResult;
        }
        if (header.getSenderNonce().getOctets().length != 16) {
            logger.error(" =================== Wrong length of received sender nonce (made up by server). Is " + header.getSenderNonce().getOctets().length + " byte but should be 16.");
            sdkResult.setError(ErrorEnum.WRONG_LEN_OF_RECEIVED_SENDER_NONCE);
            return sdkResult;
        }
        if (!Arrays.equals(header.getSenderNonce().getOctets(), senderNonce)) {
            logger.error(" =================== recipient nonce not the same as we sent away as the sender nonce. Sent: " + Arrays.toString(senderNonce) + " Received: " + Arrays.toString(header.getRecipNonce().getOctets()));
            sdkResult.setError(ErrorEnum.RECIPIENT_NONCE_NOT_THE_SAME_AS_WE_SENT);
            return sdkResult;
        }
        String s = new String(header.getTransactionID().getOctets());
        if (!transId.equalsIgnoreCase(s)) {
            logger.error(" =================== transid is not the same as the one we sent");
            sdkResult.setError(ErrorEnum.TRANS_ID_IS_NOT_THE_SAME_AS_WE_SENT);
            return sdkResult;
        }
        if (caCert == null) {
            sdkResult.setError(ErrorEnum.CA_CERT_INFO_IS_ERROR);
            return sdkResult;
        }
        AlgorithmIdentifier algId = header.getProtectionAlg();
        String protectionAlgId = algId.getAlgorithm().getId();
        if (algId == null || algId.getAlgorithm() == null || protectionAlgId == null) {
            logger.error("\u68c0\u67e5\u6d88\u606f\u5934\u548c\u7b7e\u540d ======  Not possible to get algorithm.");
            sdkResult.setError(ErrorEnum.NO_PROTECTION_ALG_IN_PKI_HEADER);
            return sdkResult;
        }
        logger.debug(" ============= RA\u6536\u5230CA\u7684\u8fd4\u56de\u5185\u5bb9\u7684\u4fdd\u62a4\u6570\u636e\u7b97\u6cd5oid:" + protectionAlgId);
        PublicKey caPublicKey = caCert.getPublicKey();
        byte[] data = CmpMessageHelper.getProtectedBytes(respObject);
        byte[] signData = respObject.getProtection().getBytes();
        boolean verifyResult = false;
        logger.debug("data>>>" + Base64.toBase64String((byte[])data) + " signData>>>" + Base64.toBase64String((byte[])signData) + " caPublicKey>>>" + Base64.toBase64String((byte[])caPublicKey.getEncoded()));
        try {
            verifyResult = isUseHsm ? SdkHsmUtils.verifyCertByYunHsm(protectionAlgId, caPublicKey, data, signData) : SdkHsmUtils.verifyCertByBC(protectionAlgId, caPublicKey, data, signData);
        }
        catch (Exception e) {
            logger.error(" =================== \u52a0\u5bc6\u673a\u9a8c\u7b7e\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_VERIFY_SIGN_DATA_IS_EXCEPTION);
            return sdkResult;
        }
        if (!verifyResult) {
            logger.error(" =================== \u52a0\u5bc6\u673a\u9a8c\u7b7e\u5931\u8d25");
            sdkResult.setError(ErrorEnum.GMSSL_VERIFY_SIGN_DATA_IS_ERROR);
            return sdkResult;
        }
        return sdkResult;
    }

    public static SdkResult resolveVarietyRepMessage(byte[] raSignPriKey, X509Certificate caCert, int applyUserType, int applyType, byte[] pkiMessage, String transId, String userCertDN, String raSignSn, int keyIndex, String pwd, boolean isUseHsm) {
        SdkResult sdkResult = new SdkResult();
        PKIMessage respObject = PKIMessage.getInstance((Object)pkiMessage);
        PKIBody body = respObject.getBody();
        if (body.getType() == 23) {
            SdkResult errMsgSdkResult = null;
            try {
                errMsgSdkResult = CmpMessageHelper.resolveErrorMsgContent(body);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790ErrorMsgContent\u5f02\u5e38{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.RESOLVE_ERROR_MSG_CONTENT_EXCEPTION);
                return sdkResult;
            }
            sdkResult.setError(errMsgSdkResult.getError());
            return sdkResult;
        }
        if (body.getType() == 1 || body.getType() == 3) {
            SdkResult certRepSdkResult = null;
            try {
                certRepSdkResult = CmpMessageHelper.resolveCertRepMessage(applyUserType, raSignPriKey, body, userCertDN, transId, caCert, keyIndex, pwd, isUseHsm);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790CertRepMessage\u5f02\u5e38{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.RESOLVE_CERT_REP_MESSAGE_EXCEPTION);
                return sdkResult;
            }
            if (!certRepSdkResult.isSuccess()) {
                sdkResult.setError(certRepSdkResult.getError());
                return sdkResult;
            }
            sdkResult.setInfo(certRepSdkResult.getInfo());
            return sdkResult;
        }
        if (body.getType() == 12) {
            SdkResult revRepSdkResult = null;
            try {
                revRepSdkResult = CmpMessageHelper.resolveRevRepContent(body);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790RevRepContent\u5f02\u5e38{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.RESOLVE_REV_REP_CONTENT_EXCEPTION);
                return sdkResult;
            }
            if (!revRepSdkResult.isSuccess()) {
                sdkResult.setError(revRepSdkResult.getError());
                return sdkResult;
            }
            sdkResult.setInfo(revRepSdkResult.getInfo());
        } else if (body.getType() == 10) {
            SdkResult recRepSdkResult = null;
            try {
                recRepSdkResult = CmpMessageHelper.resolveKeyRecRepContent(raSignPriKey, caCert, body, userCertDN, raSignSn, keyIndex, pwd, isUseHsm);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790KeyRecRepContent\u5f02\u5e38{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.RESOLVE_KEY_REC_REP_CONTENT_EXCEPTION);
                return sdkResult;
            }
            if (!recRepSdkResult.isSuccess()) {
                sdkResult.setError(recRepSdkResult.getError());
                return sdkResult;
            }
            sdkResult.setInfo(recRepSdkResult.getInfo());
        } else {
            logger.info("Cert body tag is:" + body.getType());
            sdkResult.setError(ErrorEnum.RA_NOT_SUPPORT_THIS_CERT_BODY_TAG);
        }
        return sdkResult;
    }

    public static SdkResult resolveCertRepMessage(int applyUserType, byte[] raSignPriKey, PKIBody body, String userCertDN, String transId, X509Certificate caCert, int keyIndex, String pwd, boolean isUseHsm) throws IOException, NamingException {
        SdkResult sdkResult = new SdkResult();
        CertRepMessage certRepMessage = (CertRepMessage)body.getContent();
        if (certRepMessage == null) {
            logger.info("============== No CertRepMessage for certificate received.");
            sdkResult.setError(ErrorEnum.NO_CERT_REQ_MESSAGE_RECEIVED);
            return sdkResult;
        }
        CMPCertificate[] caPubs = certRepMessage.getCaPubs();
        CertResponse[] certResponses = certRepMessage.getResponse();
        UserCertInfo userCertInfo = new UserCertInfo();
        ManagerCertInfo managerCertInfo = new ManagerCertInfo();
        X509Certificate signCert = null;
        for (CertResponse resp : certResponses) {
            SdkResult checkResult;
            String errMsg;
            long receiveCertReqId;
            long requestId;
            boolean isSignCert;
            BaseCMPInfo baseCMPInfo;
            Map<String, Object> headerMap;
            if (resp == null) {
                logger.info("============== No CertResponse for certificate received.");
                sdkResult.setError(ErrorEnum.NO_CERT_RESPONSE_MESSAGE_RECEIVED);
                return sdkResult;
            }
            PKIStatusInfo info = resp.getStatus();
            if (info == null) {
                logger.info("No PKIStatusInfo for certificate received.");
                sdkResult.setError(ErrorEnum.NO_PKI_STATUS_INFO_FOR_RECEIVE);
                return sdkResult;
            }
            int pkiStatus = info.getStatus().intValue();
            if (pkiStatus != 0) {
                DERUTF8String stringAt = info.getStatusString().getStringAt(0);
                logger.info("Received Status is " + pkiStatus + " but should be 0 because " + stringAt);
                String failInfo = String.valueOf(info.getFailInfo().intValue());
                ErrorEnum errorEnumByCode = ErrorEnum.getErrorEnumByCode(failInfo);
                if (null != errorEnumByCode) {
                    sdkResult.setError(errorEnumByCode);
                } else if ("10001".equals(failInfo)) {
                    sdkResult.setError(ErrorEnum.CA_ILLEGAL_REQUEST_PARAMETER);
                } else {
                    sdkResult.setError(ErrorEnum.CA_OPEN_API_INNER_EXCEPTION);
                }
                return sdkResult;
            }
            CertifiedKeyPair certifiedKeyPair = resp.getCertifiedKeyPair();
            if (certifiedKeyPair == null) {
                logger.info("No CertifiedKeyPair for certificate received.");
                sdkResult.setError(ErrorEnum.NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED);
                return sdkResult;
            }
            CertOrEncCert certOrEncCert = certifiedKeyPair.getCertOrEncCert();
            if (certOrEncCert == null) {
                logger.info("No CertOrEncCert for certificate received.");
                sdkResult.setError(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
                return sdkResult;
            }
            CMPCertificate cmpCertificate = certOrEncCert.getCertificate();
            if (applyUserType == SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1) {
                headerMap = SdkCommonVariable.getHeaderMap();
                baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
                if (baseCMPInfo == null) {
                    logger.info(" ============= No ra send transId.");
                    sdkResult.setError(ErrorEnum.NO_RA_SEND_TRANS_ID);
                    return sdkResult;
                }
                isSignCert = false;
                requestId = baseCMPInfo.getRequestId();
                receiveCertReqId = resp.getCertReqId().getValue().longValue();
                if (receiveCertReqId == requestId) {
                    isSignCert = true;
                } else if (receiveCertReqId == -1L) {
                    isSignCert = false;
                } else {
                    errMsg = "=============== Received CertReqId is " + receiveCertReqId + " but should be " + requestId;
                    logger.info(errMsg);
                    sdkResult.setError(ErrorEnum.RA_RECEIVED_CERT_REQ_ID_IS_ERROR);
                    return sdkResult;
                }
                checkResult = CmpMessageHelper.checkCMPCert(caCert, cmpCertificate, userCertDN);
                if (!checkResult.isSuccess()) {
                    sdkResult.setError(checkResult.getError());
                    return sdkResult;
                }
                if (isSignCert) {
                    signCert = (X509Certificate)checkResult.getInfo();
                    String base64SignCert = SdkCertUtils.certToFullB64(signCert);
                    userCertInfo.setSignCert(base64SignCert);
                } else {
                    X509Certificate encCert = (X509Certificate)checkResult.getInfo();
                    String base64EncCert = SdkCertUtils.certToFullB64(encCert);
                    userCertInfo.setEncCert(base64EncCert);
                }
                EncryptedValue privateKey = certifiedKeyPair.getPrivateKey();
                if (privateKey == null) continue;
                if (signCert == null) {
                    CertResponse signCertResp = certResponses[1];
                    try {
                        signCert = SdkCertUtils.convertDerCertToCert(signCertResp.getCertifiedKeyPair().getCertOrEncCert().getCertificate().getEncoded());
                    }
                    catch (Exception e) {
                        logger.error("Not possible to create certificate.{}", (Throwable)e);
                        sdkResult.setError(ErrorEnum.NOT_POSSIBLE_TO_CREATE_CERT);
                        return sdkResult;
                    }
                }
                SignedAndEnvelopedData signedAndEnvelopedData = null;
                try {
                    signedAndEnvelopedData = CmpMessageHelper.buildSignedAndEnvelopedData(raSignPriKey, isUseHsm, caCert.getSigAlgName(), userCertDN, privateKey, signCert.getSerialNumber().toString(), keyIndex, pwd);
                }
                catch (Exception e) {
                    logger.error("Build SignedAndEnvelopedData From Encryptedvalue Exception.", (Throwable)e);
                    sdkResult.setError(ErrorEnum.BUILD_SIGNEDANDENVLOPEDDATA_FROM_ENCRYPTEDVALUE_EXCPTION);
                    return sdkResult;
                }
                userCertInfo.setEncPriKey(Base64.toBase64String((byte[])signedAndEnvelopedData.getDEREncoded()));
                continue;
            }
            if (applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) continue;
            headerMap = SdkCommonVariable.getHeaderMap();
            baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
            if (baseCMPInfo == null) {
                logger.info("================ No ra send transId.");
                sdkResult.setError(ErrorEnum.NO_RA_SEND_TRANS_ID);
                return sdkResult;
            }
            isSignCert = false;
            requestId = baseCMPInfo.getRequestId();
            receiveCertReqId = resp.getCertReqId().getValue().longValue();
            if (receiveCertReqId == requestId) {
                isSignCert = true;
            } else if (receiveCertReqId == -1L) {
                isSignCert = false;
            } else {
                errMsg = "================== Received CertReqId is " + receiveCertReqId + " but should be " + requestId;
                logger.info(errMsg);
                sdkResult.setError(ErrorEnum.RA_RECEIVED_CERT_REQ_ID_IS_ERROR);
                return sdkResult;
            }
            if (cmpCertificate != null) {
                checkResult = CmpMessageHelper.checkCMPCert(caCert, cmpCertificate, userCertDN);
                if (!checkResult.isSuccess()) {
                    sdkResult.setError(checkResult.getError());
                    return sdkResult;
                }
                signCert = (X509Certificate)checkResult.getInfo();
            }
            if (isSignCert) {
                String base64SignCert = SdkCertUtils.certToFullB64(signCert);
                managerCertInfo.setSignCert(base64SignCert);
                continue;
            }
            EncryptedValue encryptedCert = certifiedKeyPair.getCertOrEncCert().getEncryptedCert();
            if (signCert == null) {
                CertResponse signCertResp = certResponses[1];
                try {
                    signCert = SdkCertUtils.convertDerCertToCert(signCertResp.getCertifiedKeyPair().getCertOrEncCert().getCertificate().getEncoded());
                }
                catch (Exception e) {
                    logger.error("Not possible to create certificate.{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.NOT_POSSIBLE_TO_CREATE_CERT);
                    return sdkResult;
                }
            }
            SM2EnvelopedData envelopedData = null;
            try {
                envelopedData = CmpMessageHelper.buildEnvelopedData(caCert.getSigAlgName(), userCertDN, encryptedCert, signCert.getSerialNumber().toString());
            }
            catch (Exception e) {
                logger.error("Build SignedAndEnvelopedData From Encryptedvalue Exception.", (Throwable)e);
                sdkResult.setError(ErrorEnum.BUILD_SIGNEDANDENVLOPEDDATA_FROM_ENCRYPTEDVALUE_EXCPTION);
                return sdkResult;
            }
            managerCertInfo.setEncEncCert(Base64.toBase64String((byte[])envelopedData.getEncoded()));
        }
        if (applyUserType == SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1) {
            sdkResult.setInfo(userCertInfo);
        } else if (applyUserType == SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            logger.info("managerCertInfo===========" + SdkJsonUtils.object2Json(managerCertInfo));
            sdkResult.setInfo(managerCertInfo);
        }
        return sdkResult;
    }

    public static SdkResult resolveErrorMsgContent(PKIBody body) {
        SdkResult sdkResult = new SdkResult();
        ErrorMsgContent errorMsgContent = (ErrorMsgContent)body.getContent();
        PKIStatusInfo info = errorMsgContent.getPKIStatusInfo();
        logger.info("========== CA\u8fd4\u56de\u7684\u9519\u8bef\u6d88\u606f\u7ed3\u6784\u4f53 =========  errorCode:" + info.getFailInfo().intValue());
        logger.info("========== CA\u8fd4\u56de\u7684\u9519\u8bef\u6d88\u606f\u7ed3\u6784\u4f53 =========  errorMsg:" + info.getStatusString().getStringAt(0));
        if (ErrorEnum.RA_CERT_ISSUE_STATUS_REVOKED.code == info.getFailInfo().intValue()) {
            sdkResult.setError(ErrorEnum.RA_CERT_ISSUE_STATUS_REVOKED);
        } else {
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_PKI_ERROR_MSG);
        }
        return sdkResult;
    }

    public static SdkResult resolveRevRepContent(PKIBody body) {
        SdkResult sdkResult = new SdkResult();
        int status = 0;
        RevRepContent revRepContent = (RevRepContent)body.getContent();
        PKIStatusInfo[] pkiStatusInfos = revRepContent.getStatus();
        if (status == pkiStatusInfos[0].getStatus().intValue()) {
            logger.info("==========CA\u8fd4\u56de\u7684\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u6210\u529f=========");
            return sdkResult;
        }
        String code = String.valueOf(pkiStatusInfos[0].getFailInfo().intValue());
        PKIFreeText pkiFreeTexts = pkiStatusInfos[0].getStatusString();
        String failInfo = pkiFreeTexts.getStringAt(0).toString();
        logger.info("==========CA\u8fd4\u56de\u7684\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u5931\u8d25=========\u539f\u56e0\uff1a " + failInfo);
        ErrorEnum errorEnumByCode = ErrorEnum.getErrorEnumByCode(code);
        if (null != errorEnumByCode) {
            sdkResult.setError(errorEnumByCode);
        } else if ("10001".equals(failInfo)) {
            sdkResult.setError(ErrorEnum.CA_ILLEGAL_REQUEST_PARAMETER);
        } else {
            sdkResult.setError(ErrorEnum.CA_OPEN_API_INNER_EXCEPTION);
        }
        return sdkResult;
    }

    private static SdkResult resolveKeyRecRepContent(byte[] raSignPriKey, X509Certificate caCert, PKIBody body, String userCertDN, String raSignSn, int keyIndex, String pwd, boolean isUseHsm) throws NamingException {
        SdkResult sdkResult = new SdkResult();
        KeyRecRepContent keyRecRepContent = (KeyRecRepContent)body.getContent();
        if (keyRecRepContent == null) {
            logger.info("============== No CertRepMessage for certificate received.");
            sdkResult.setError(ErrorEnum.NO_KEY_REC_REP_CONTENT_MESSAGE_RECEIVED);
            return sdkResult;
        }
        PKIStatusInfo pkiStatusInfo = keyRecRepContent.getStatus();
        if (pkiStatusInfo == null) {
            logger.info("No PKIStatusInfo for certificate received.");
            sdkResult.setError(ErrorEnum.NO_PKI_STATUS_INFO_FOR_RECEIVE);
            return sdkResult;
        }
        int pkiStatus = pkiStatusInfo.getStatus().intValue();
        if (0 != pkiStatus) {
            DERUTF8String stringAt = pkiStatusInfo.getStatusString().getStringAt(0);
            logger.info("Received Status is " + pkiStatus + " but should be 0 because " + stringAt);
            String failInfo = String.valueOf(pkiStatusInfo.getFailInfo().intValue());
            ErrorEnum errorEnumByCode = ErrorEnum.getErrorEnumByCode(failInfo);
            if (null != errorEnumByCode) {
                sdkResult.setError(errorEnumByCode);
            } else if ("10001".equals(failInfo)) {
                sdkResult.setError(ErrorEnum.CA_ILLEGAL_REQUEST_PARAMETER);
            } else {
                sdkResult.setError(ErrorEnum.CA_OPEN_API_INNER_EXCEPTION);
            }
            return sdkResult;
        }
        CMPCertificate newSigCert = keyRecRepContent.getNewSigCert();
        CertifiedKeyPair[] keyPairHist = keyRecRepContent.getKeyPairHist();
        CertOrEncCert oldEncCert = keyPairHist[0].getCertOrEncCert();
        EncryptedValue encPprKey = keyPairHist[0].getPrivateKey();
        UserCertInfo userCertInfo = new UserCertInfo();
        if (null == newSigCert) {
            logger.info("No NewSignCert for certificate received.");
            sdkResult.setError(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
            return sdkResult;
        }
        SdkResult checkResult = CmpMessageHelper.checkCMPCert(caCert, newSigCert, userCertDN);
        if (!checkResult.isSuccess()) {
            sdkResult.setError(checkResult.getError());
            return sdkResult;
        }
        X509Certificate signCert = (X509Certificate)checkResult.getInfo();
        String base64SignCert = SdkCertUtils.certToFullB64(signCert);
        userCertInfo.setSignCert(base64SignCert);
        if (null == oldEncCert || null == oldEncCert.getCertificate()) {
            logger.info("No OldEncCert for certificate received.");
            sdkResult.setError(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
            return sdkResult;
        }
        checkResult = CmpMessageHelper.checkCMPCert(caCert, oldEncCert.getCertificate(), userCertDN);
        if (!checkResult.isSuccess()) {
            sdkResult.setError(checkResult.getError());
            return sdkResult;
        }
        X509Certificate encCert = (X509Certificate)checkResult.getInfo();
        String base64EncCert = SdkCertUtils.certToFullB64(encCert);
        userCertInfo.setEncCert(base64EncCert);
        if (encPprKey == null) {
            logger.info("No encPprKey for certificate received.");
            sdkResult.setError(ErrorEnum.NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED);
            return sdkResult;
        }
        if (encPprKey != null) {
            SignedAndEnvelopedData signedAndEnvelopedData = null;
            try {
                signedAndEnvelopedData = CmpMessageHelper.buildSignedAndEnvelopedData(raSignPriKey, isUseHsm, caCert.getSigAlgName(), SdkCertUtils.getSubjectByX509Cert(signCert), encPprKey, signCert.getSerialNumber().toString(), keyIndex, pwd);
            }
            catch (Exception e) {
                logger.error("Build SignedAndEnvelopedData From Encryptedvalue Exception.", (Throwable)e);
                sdkResult.setError(ErrorEnum.BUILD_SIGNEDANDENVLOPEDDATA_FROM_ENCRYPTEDVALUE_EXCPTION);
                return sdkResult;
            }
            userCertInfo.setEncPriKey(Base64.toBase64String((byte[])signedAndEnvelopedData.getDEREncoded()));
        }
        sdkResult.setInfo(userCertInfo);
        return sdkResult;
    }

    public static CertConfirmContent genCertConfirmContent(String hash, long certReqId) {
        CertStatus certStatus = new CertStatus(hash.getBytes(), new BigInteger(String.valueOf(certReqId)));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)certStatus);
        CertConfirmContent certConfirmContent = CertConfirmContent.getInstance((Object)new DERSequence(v));
        return certConfirmContent;
    }

    public static RevReqContent genRevReqContent(String caDN, String userCertDN, String signSn) throws NamingException {
        CertTemplateBuilder certTemplateBuilder = new CertTemplateBuilder();
        certTemplateBuilder.setIssuer(DnUtil.getRFC4519X500Name(caDN));
        String signSnDecimal = new BigInteger(signSn, 16).toString(10);
        certTemplateBuilder.setSerialNumber(new ASN1Integer(Long.valueOf(signSnDecimal).longValue()));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)certTemplateBuilder.build());
        DERSequence seq = new DERSequence(v);
        RevDetails revDetails = RevDetails.getInstance((Object)seq);
        RevReqContent revReqContent = new RevReqContent(revDetails);
        return revReqContent;
    }

    public static ErrorMsgContent genErrorMsgContent(PKIStatus pkiStatus, int errorCode, String errorDetails) {
        PKIFreeText pkiFreeText = new PKIFreeText(errorDetails);
        PKIStatusInfo pkiStatusInfo = new PKIStatusInfo(pkiStatus);
        ErrorMsgContent errorMessage = new ErrorMsgContent(pkiStatusInfo, new ASN1Integer((long)errorCode), pkiFreeText);
        return errorMessage;
    }

    public static ErrorMsgContent genErrorMsgContent(int pkiStatus, String statusString, int failInfo, int errorCode, String errorDetails) {
        PKIFailureInfo pkiFailureInfo = new PKIFailureInfo(failInfo);
        PKIFreeText pkiFreeText = new PKIFreeText(statusString);
        PKIStatusInfo pkiStatusInfo = new PKIStatusInfo(PKIStatus.getInstance((Object)pkiStatus), pkiFreeText, pkiFailureInfo);
        PKIFreeText errorDetailsPkiFreeText = new PKIFreeText(errorDetails);
        ErrorMsgContent errorMessage = new ErrorMsgContent(pkiStatusInfo, new ASN1Integer((long)errorCode), errorDetailsPkiFreeText);
        return errorMessage;
    }

    public static byte[] getProtectedBytes(PKIMessage msg) {
        return CmpMessageHelper.getProtectedBytes(msg.getHeader(), msg.getBody());
    }

    public static byte[] getProtectedBytes(PKIHeader header, PKIBody body) {
        byte[] res = null;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)header);
        v.add((ASN1Encodable)body);
        DERSequence protectedPart = new DERSequence(v);
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream((OutputStream)bao);
            out.writeObject((ASN1Encodable)protectedPart);
            res = bao.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        return res;
    }

    public static String createP10FromPubKeyDer(byte[] pubDer, String dn, String caAlg) {
        String p10 = "";
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)pubDer);
            SubjectPublicKeyInfo spi = new SubjectPublicKeyInfo(seq);
            CertificationRequestInfo cf1 = new CertificationRequestInfo(new X509Name(dn), spi, null);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DEROutputStream derOutStream = new DEROutputStream((OutputStream)outStream);
            derOutStream.writeObject((ASN1Encodable)cf1);
            byte[] tbsdata = outStream.toByteArray();
            DERBitString dbs = new DERBitString(tbsdata);
            CertificationRequest cr = new CertificationRequest(cf1, new AlgorithmIdentifier((ASN1ObjectIdentifier)new DERObjectIdentifier("1.2.840.113549.1.1.4")), dbs);
            ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
            DEROutputStream derOutStream1 = new DEROutputStream((OutputStream)outStream1);
            derOutStream1.writeObject((ASN1Encodable)cr);
            byte[] p10data = outStream1.toByteArray();
            p10 = new String(Base64.encode((byte[])p10data)).replace("\n", "").replaceAll("\r", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            p10 = "";
        }
        return p10;
    }

    private static SdkResult checkCMPCert(X509Certificate caCert, CMPCertificate cmpCertificate, String userCertDN) throws NamingException {
        SdkResult sdkResult = new SdkResult();
        if (cmpCertificate == null) {
            logger.info("No X509CertificateStructure for certificate received.");
            sdkResult.setError(ErrorEnum.NO_X509_CERT_FOR_RECEIVED);
            return sdkResult;
        }
        byte[] encoded = new byte[]{};
        try {
            encoded = cmpCertificate.getEncoded();
            if (encoded == null || encoded.length <= 0) {
                logger.info("No encoded certificate received");
                sdkResult.setError(ErrorEnum.NO_ENCODE_CERT_FOR_RECEIVED);
                return sdkResult;
            }
        }
        catch (IOException e) {
            logger.error("CMPCertificate Encode Exception.{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CMP_CERT_ENCODE_EXCEPTION);
            return sdkResult;
        }
        X509Certificate cert = null;
        try {
            cert = SdkCertUtils.convertDerCertToCert(encoded);
        }
        catch (Exception e) {
            logger.error("Not possible to create certificate.{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.NOT_POSSIBLE_TO_CREATE_CERT);
            return sdkResult;
        }
        String certDN = SdkCertUtils.getSubjectByX509Cert(cert);
        userCertDN = DnUtil.getRFC4519X500Name(userCertDN).toString();
        if (!certDN.equalsIgnoreCase(userCertDN)) {
            String errMsg = "Subject is '" + certDN + "' but should be '" + userCertDN + "'";
            logger.info(errMsg);
            sdkResult.setError(ErrorEnum.RECEIVE_SUBJECT_DN_IS_NOT_SAME_APPLY);
            return sdkResult;
        }
        if (caCert == null) {
            sdkResult.setError(ErrorEnum.CA_CERT_INFO_IS_ERROR);
            return sdkResult;
        }
        String caDN = SdkCertUtils.getSubjectByX509Cert(caCert);
        if (!SdkCertUtils.getIssuerByX509Cert(cert).equals(caDN)) {
            logger.info("Issuer is '" + SdkCertUtils.getIssuerByX509Cert(cert) + "' but should be '" + caDN);
            sdkResult.setError(ErrorEnum.RECEIVE_ISSUE_DN_IS_NOT_SAME_APPLY);
            return sdkResult;
        }
        try {
            cert.verify(caCert.getPublicKey());
        }
        catch (Exception e) {
            logger.error("Certificate not verifying.{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.RA_VERIFY_CA_REP_CERT_ERROR);
            return sdkResult;
        }
        sdkResult.setInfo(cert);
        return sdkResult;
    }

    private static SignedAndEnvelopedData buildSignedAndEnvelopedData(byte[] raSignPriKey, boolean isUseHsm, String caAlg, String recipCertDn, EncryptedValue encryptedValue, String recipSignSn, int keyIndex, String pwd) throws Exception {
        ASN1Integer version = new ASN1Integer(1L);
        DERSet digestAlgorithms = null;
        digestAlgorithms = "SHA-1WithRSA".equalsIgnoreCase(caAlg) || "SHA1WithRSA".equalsIgnoreCase(caAlg) || "SHA256WithRSA".equalsIgnoreCase(caAlg) ? new DERSet((ASN1Encodable)new AlgorithmIdentifier(DigestObjectIdentifiers.sha1)) : new DERSet((ASN1Encodable)new AlgorithmIdentifier(DigestObjectIdentifiers.sm3));
        RecipientIdentifier rid = new RecipientIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(recipCertDn), new BigInteger(recipSignSn, 16)));
        KeyTransRecipientInfo keyTransRecipientInfo = new KeyTransRecipientInfo(rid, encryptedValue.getKeyAlg(), (ASN1OctetString)new DEROctetString(encryptedValue.getEncSymmKey().getOctets()));
        DERSet recipientInfos = new DERSet((ASN1Encodable)keyTransRecipientInfo);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(SymmetryObjectIdentifiers.sm4, encryptedValue.getSymmAlg(), (ASN1OctetString)new DEROctetString(encryptedValue.getEncValue().getOctets()));
        byte[] mergeData = SdkCertUtils.byteMergerAll(version.getEncoded(), recipientInfos.getEncoded(), digestAlgorithms.getEncoded(), encryptedContentInfo.getEncoded());
        ASN1Set signerInfos = Pkcs7Utils.makeSignerInfos(raSignPriKey, isUseHsm, caAlg, recipCertDn, new BigInteger(recipSignSn, 16), keyIndex, pwd, mergeData);
        SignedAndEnvelopedData envelopedData = new SignedAndEnvelopedData(version, (ASN1Set)recipientInfos, (ASN1Set)digestAlgorithms, encryptedContentInfo, null, null, signerInfos);
        return envelopedData;
    }

    private static SM2EnvelopedData buildEnvelopedData(String caAlg, String recipCertDn, EncryptedValue encryptedValue, String recipSignSn) throws Exception {
        logger.info("caAlg:" + caAlg + " recipCertDn:" + recipCertDn + "recipSignSn:" + recipSignSn + " encryptedValue:" + Base64.toBase64String((byte[])encryptedValue.getEncoded()));
        ASN1Integer version = new ASN1Integer(1L);
        RecipientIdentifier rid = new RecipientIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(recipCertDn), new BigInteger(recipSignSn, 16)));
        KeyTransRecipientInfo keyTransRecipientInfo = new KeyTransRecipientInfo(rid, encryptedValue.getKeyAlg(), (ASN1OctetString)new DEROctetString(encryptedValue.getEncSymmKey().getOctets()));
        DERSet recipientInfos = new DERSet((ASN1Encodable)keyTransRecipientInfo);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(SymmetryObjectIdentifiers.sm4, encryptedValue.getSymmAlg(), (ASN1OctetString)new DEROctetString(encryptedValue.getEncValue().getOctets()));
        SM2EnvelopedData envelopedData = new SM2EnvelopedData(version, (ASN1Set)recipientInfos, encryptedContentInfo);
        return envelopedData;
    }

    public static byte[] genRandomByHsm(int length) {
        byte[] normalSenderNonce = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(normalSenderNonce);
        return normalSenderNonce;
    }
}

