/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.sdk;

import com.alibaba.fastjson.JSON;
import com.xdja.ca.asn1.NISTObjectIdentifiers;
import com.xdja.ca.asn1.RsaObjectIdentifiers;
import com.xdja.ca.asn1.SM2ObjectIdentifiers;
import com.xdja.ca.bean.BaseCMPInfo;
import com.xdja.ca.constant.SdkCommonVariable;
import com.xdja.ca.constant.SdkConstants;
import com.xdja.ca.error.ErrorEnum;
import com.xdja.ca.helper.CmpMessageHelper;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.ca.utils.ClientHttpUtils;
import com.xdja.ca.utils.SdkJsonUtils;
import com.xdja.ca.vo.FreeText;
import com.xdja.ca.vo.RevokeCertInfo;
import com.xdja.ca.vo.TempInfo;
import com.xdja.ca.vo.UpdateCertInfo;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int keyIndex;
    private String pwd;
    private X509Certificate caCert;
    private X509Certificate[] caCerts;
    private String caServiceIp;
    private int caServicePort;
    private String raSignSn;
    private String caBaseUrl;
    private boolean isHttps;
    private boolean isUseHsm;
    private String protectAlgName;
    private byte[] raSignPriKey;

    public CmpApi(int keyIndex, String pwd, X509Certificate[] caCerts, X509Certificate caCert, String caServiceIp, int caServicePort, String raSignSn, String protectAlgName, boolean isHttps, boolean isUseHsm) {
        this.keyIndex = keyIndex;
        this.pwd = pwd;
        this.caCerts = caCerts;
        this.caCert = caCert;
        this.caServiceIp = caServiceIp;
        this.caServicePort = caServicePort;
        this.caBaseUrl = caServiceIp + ":" + caServicePort + "/ca-openapi";
        this.raSignSn = raSignSn;
        this.protectAlgName = protectAlgName;
        this.isHttps = isHttps;
        this.isUseHsm = isUseHsm;
    }

    public CmpApi(byte[] privateKey, X509Certificate[] caCerts, X509Certificate caCert, String caServiceIp, int caServicePort, String raSignSn, String protectAlgName, boolean isHttps, boolean isUseHsm) {
        this.raSignPriKey = privateKey;
        this.caCerts = caCerts;
        this.caCert = caCert;
        this.caServiceIp = caServiceIp;
        this.caServicePort = caServicePort;
        this.caBaseUrl = caServiceIp + ":" + caServicePort + "/ca-openapi";
        this.raSignSn = raSignSn;
        this.protectAlgName = protectAlgName;
        this.isHttps = isHttps;
        this.isUseHsm = isUseHsm;
    }

    public SdkResult sendIssuerCertReqMessages(int applyUserType, String transId, String raDN, String caDN, int certValidity, TempInfo tempInfo, String signPubKey, String encPubKey, String signAlg, String certDN, Integer keyFormat) {
        SdkResult checkCRGSdkResult;
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a:{} \uff0c\u7528\u6237\u7c7b\u578b\u4e3a:{},raDN\u4e3a:{},caDN\u4e3a:{},\u7533\u8bf7\u6709\u6548\u671f\u4e3a:{},\u6a21\u677f\u4fe1\u606f\u4e3a:{},\u7b7e\u540d\u516c\u94a5\u4e3a:{},\u52a0\u5bc6\u516c\u94a5\u4e3a:{},\u7533\u8bf7\u7b7e\u540d\u7b97\u6cd5\u4e3a:{},\u7533\u8bf7\u8bc1\u4e66\u4e3b\u4f53\u4e3a:{}", new Object[]{transId, applyUserType, raDN, caDN, certValidity, SdkJsonUtils.object2Json(tempInfo), signPubKey, encPubKey, signAlg, certDN});
        SdkResult sdkResult = new SdkResult();
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (applyUserType != SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1 && applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            this.logger.error("=============== \u8bf7\u6c42\u7528\u6237\u7c7b\u578b\u9519\u8bef");
            sdkResult.setError(ErrorEnum.APPLY_USER_TYPE_IS_ERROR);
            return sdkResult;
        }
        if (certValidity <= 0) {
            this.logger.error("=============== \u53c2\u6570\u4e2d\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u7b49\u4e8e0");
            sdkResult.setError(ErrorEnum.CERT_VALIDITY_CANNOT_LESS_ZERO);
            return sdkResult;
        }
        if (tempInfo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN, signPubKey, signAlg, certDN, tempInfo.tempNo})) {
            this.logger.error("=============== \u53c2\u6570\u4e2dtempNo,transId,raDN,caDN,signPubKey,protectionAlg,certDN\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 1.\u5411CA\u83b7\u53d6\u968f\u673a\u6570");
        String url = "/v1/cmp";
        byte[] recipNonce = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transId", transId);
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, paramMap, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            recipNonce = (byte[])getResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CMP\u8bf7\u6c42\u968f\u673a\u6570\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_CMP_RANDOM_IS_EXCEPTION);
            return sdkResult;
        }
        if (recipNonce == null) {
            this.logger.error("============== CA\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        ASN1ObjectIdentifier signAlgIde = null;
        if ("SM3withSM2".equalsIgnoreCase(signAlg)) {
            signAlgIde = SM2ObjectIdentifiers.sm2SignWithSm3;
        } else if ("sha-1WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha1WithRSA;
        } else if ("sha256WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha256WithRSA;
        } else if ("SHA256WithECDSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = NISTObjectIdentifiers.nistSignAlgorithm;
        } else {
            this.logger.error("===============  \u8bc1\u4e66\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301\uff1a" + signAlg);
            sdkResult.setError(ErrorEnum.CERT_SIGN_ALG_IS_NOT_SUPPORT);
            return sdkResult;
        }
        long certReqId = System.nanoTime();
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 2.\u5c01\u88c5CertRequest\u7ed3\u6784\u4f53");
        CertRequest[] certRequests = null;
        if (applyUserType == SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1) {
            certRequests = new CertRequest[1];
            CertRequest certRequest = null;
            try {
                certRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, signPubKey == null ? null : Base64.decode((String)signPubKey), signAlgIde, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
            }
            catch (Exception e) {
                this.logger.error(" ===============  \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[0] = certRequest;
        } else if (applyUserType == SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            CertRequest signCertRequest;
            certRequests = new CertRequest[2];
            try {
                signCertRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, signPubKey == null ? null : Base64.decode((String)signPubKey), signAlgIde, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
            }
            catch (Exception e) {
                this.logger.error(" ============= \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[0] = signCertRequest;
            CertRequest encCertRequest = null;
            try {
                encCertRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, Base64.decode((String)encPubKey), signAlgIde, -1L, SdkConstants.CERT_TYPE_ENC_3);
            }
            catch (Exception e) {
                this.logger.error("============= \u5c01\u88c5\u3010\u52a0\u5bc6\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[1] = encCertRequest;
        }
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 3.\u5c01\u88c5CertReqMessages\u7ed3\u6784\u4f53");
        CertReqMessages certReqMessages = null;
        try {
            certReqMessages = CmpMessageHelper.genCertReqMessages(certRequests);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u5c01\u88c5certRequestMessage\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        byte[] senderNonce = new byte[16];
        try {
            senderNonce = CmpMessageHelper.genRandomByHsm(senderNonce.length);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u901a\u8fc7\u5bc6\u7801\u673a\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_RANDOM_BY_HSM_EXCEPTION);
            return sdkResult;
        }
        FreeText freeText = new FreeText();
        freeText.setApplyUserType(applyUserType);
        freeText.setTempInfo(tempInfo);
        freeText.setRaSignSn(this.raSignSn);
        freeText.setKeyFormat(keyFormat);
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        headerMap.put(transId, new BaseCMPInfo(senderNonce, recipNonce, transId, certReqId, 0));
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 4.\u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage pkiMessage = null;
        try {
            pkiMessage = CmpMessageHelper.genPKIMessage(this.keyIndex, this.pwd, this.raSignPriKey, this.caCert, raDN, caDN, 0, recipNonce, senderNonce, transId, (ASN1Encodable)certReqMessages, JSON.toJSONString((Object)freeText), this.isUseHsm);
        }
        catch (Exception e) {
            this.logger.error(" =============== \u5c01\u88c5PKIMessage\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 5.\u53d1\u9001\u8bc1\u4e66\u7533\u8bf7\u8bf7\u6c42");
        url = "/v1/cmp";
        byte[] pkiInfo = null;
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, pkiMessage.getEncoded(), null, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
            pkiInfo = (byte[])postResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        if (pkiInfo == null) {
            this.logger.info("============== \u63a5\u6536CA\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 6.\u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f");
        try {
            checkCRGSdkResult = CmpMessageHelper.checkCmpHeaderAndSign(pkiInfo, raDN, caDN, senderNonce, transId, this.caCert, this.isUseHsm);
        }
        catch (NamingException e) {
            this.logger.error(" ============= \u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CERT_DN_IS_NOT_FORMAT);
            return sdkResult;
        }
        if (!checkCRGSdkResult.isSuccess()) {
            sdkResult.setErrorBean(checkCRGSdkResult.getErrorBean());
            this.logger.error("\u7b7e\u53d1\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u5934\u548c\u7b7e\u540d\u9519\u8bef");
            return sdkResult;
        }
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== 7.\u83b7\u53d6CA\u8fd4\u56de\u7684\u8bc1\u4e66\u4fe1\u606f");
        SdkResult resolveCmpRepSdkResult = CmpMessageHelper.resolveVarietyRepMessage(this.raSignPriKey, this.caCert, applyUserType, SdkConstants.CERT_APPLY_TYPE_ISSUE_1, pkiInfo, transId, certDN, this.raSignSn, this.keyIndex, this.pwd, this.isUseHsm);
        if (!resolveCmpRepSdkResult.isSuccess()) {
            this.logger.error("\u7b7e\u53d1\u7533\u8bf7 ======== 7.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
            sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
            return sdkResult;
        }
        sdkResult.setInfo(resolveCmpRepSdkResult.getInfo());
        this.logger.info("\u7b7e\u53d1\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return sdkResult;
    }

    public SdkResult sendUpdateCertReqMessages(int applyUserType, String transId, String raDN, String caDN, int certValidity, TempInfo tempInfo, UpdateCertInfo updateCertInfo, String signSn, String certDN, Integer keyFormat) {
        SdkResult checkCRGSdkResult;
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a:{} \uff0c\u7528\u6237\u7c7b\u578b\u4e3a:{},raDN\u4e3a:{},caDN\u4e3a:{},\u7533\u8bf7\u6709\u6548\u671f\u4e3a:{},\u6a21\u677f\u4fe1\u606f\u4e3a:{},\u5f85\u66f4\u65b0\u5185\u5bb9\u4e3a:{},\u5f85\u66f4\u65b0\u8bc1\u4e66\u7b7e\u540dsn\u4e3a:{},\u7533\u8bf7\u8bc1\u4e66\u4e3b\u4f53\u4e3a:{}", new Object[]{transId, applyUserType, raDN, caDN, certValidity, SdkJsonUtils.object2Json(tempInfo), SdkJsonUtils.object2Json(updateCertInfo), signSn, certDN});
        SdkResult sdkResult = new SdkResult();
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (applyUserType != SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1 && applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            this.logger.info("\u8bf7\u6c42\u7528\u6237\u7c7b\u578b\u9519\u8bef");
            sdkResult.setError(ErrorEnum.APPLY_USER_TYPE_IS_ERROR);
            return sdkResult;
        }
        if (certValidity < 0) {
            this.logger.info("=============== \u53c2\u6570\u4e2d\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u53ef\u4ee5\u5c0f\u4e8e0");
            sdkResult.setError(ErrorEnum.CERT_VALIDITY_CANNOT_LESS_ZERO);
            return sdkResult;
        }
        if (tempInfo == null || updateCertInfo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN, updateCertInfo.getSignAlg(), certDN, tempInfo.tempNo})) {
            this.logger.info("=============== \u53c2\u6570\u4e2dtempNo,transId,raDN,caDN,signAlg,certDN\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        String url = "/v1/cmp";
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 1.\u5411CA\u83b7\u53d6\u968f\u673a\u6570");
        byte[] recipNonce = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transId", transId);
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, paramMap, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            recipNonce = (byte[])getResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CMP\u8bf7\u6c42\u968f\u673a\u6570\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_CMP_RANDOM_IS_EXCEPTION);
            return sdkResult;
        }
        if (recipNonce == null) {
            this.logger.info("============== CA\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        byte[] signPublicKey = null;
        if (updateCertInfo != null) {
            signPublicKey = updateCertInfo.getSignPublicKey() == null ? null : Base64.decode((String)updateCertInfo.getSignPublicKey());
        }
        String signAlg = updateCertInfo.getSignAlg();
        ASN1ObjectIdentifier signAlgIde = null;
        if ("SM3withSM2".equalsIgnoreCase(signAlg)) {
            signAlgIde = SM2ObjectIdentifiers.sm2SignWithSm3;
        } else if ("sha-1WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha1WithRSA;
        } else if ("sha256WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha256WithRSA;
        } else if ("SHA256WithECDSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = NISTObjectIdentifiers.nistSignAlgorithm;
        } else {
            this.logger.info("===============  \u8bc1\u4e66\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301\uff1a" + signAlg);
            sdkResult.setError(ErrorEnum.CERT_SIGN_ALG_IS_NOT_SUPPORT);
            return sdkResult;
        }
        long certReqId = System.nanoTime();
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 2.\u5c01\u88c5CertRequset\u7ed3\u6784\u4f53");
        CertRequest[] certRequests = null;
        if (applyUserType == SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1) {
            certRequests = new CertRequest[1];
            CertRequest certRequest = null;
            try {
                certRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, signPublicKey, signAlgIde, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
            }
            catch (Exception e) {
                this.logger.error(" ================= \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[0] = certRequest;
        } else if (applyUserType == SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            certRequests = new CertRequest[2];
            CertRequest signCertRequest = null;
            try {
                signCertRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, signPublicKey, signAlgIde, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
            }
            catch (Exception e) {
                this.logger.error(" ================ \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[0] = signCertRequest;
            CertRequest encCertRequest = null;
            try {
                byte[] encPublicKey = StringUtils.isBlank((CharSequence)updateCertInfo.getEncPublicKey()) ? null : Base64.decode((String)updateCertInfo.getEncPublicKey());
                encCertRequest = CmpMessageHelper.genCertRequest(certValidity, certDN, encPublicKey, signAlgIde, certReqId, SdkConstants.CERT_TYPE_ENC_3);
            }
            catch (Exception e) {
                this.logger.error(" ============== \u5c01\u88c5\u3010\u52a0\u5bc6\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
                return sdkResult;
            }
            certRequests[1] = encCertRequest;
        }
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 3.\u5c01\u88c5CertReqMessages\u7ed3\u6784\u4f53");
        CertReqMessages certReqMessages = null;
        try {
            certReqMessages = CmpMessageHelper.genCertReqMessages(certRequests);
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5certRequestMessage\u5f02\u5e38\uff1a{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        byte[] senderNonce = new byte[16];
        try {
            senderNonce = CmpMessageHelper.genRandomByHsm(senderNonce.length);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u901a\u8fc7\u5bc6\u7801\u673a\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_RANDOM_BY_HSM_EXCEPTION);
            return sdkResult;
        }
        FreeText freeText = new FreeText();
        freeText.setApplyUserType(applyUserType);
        freeText.setTempInfo(tempInfo);
        freeText.setSignSn(signSn);
        freeText.setRaSignSn(this.raSignSn);
        freeText.setKeyFormat(keyFormat);
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        headerMap.put(transId, new BaseCMPInfo(senderNonce, recipNonce, transId, certReqId, 0));
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 4.\u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage pkiMessage = null;
        try {
            pkiMessage = CmpMessageHelper.genPKIMessage(this.keyIndex, this.pwd, this.raSignPriKey, this.caCert, raDN, caDN, 7, recipNonce, senderNonce, transId, (ASN1Encodable)certReqMessages, JSON.toJSONString((Object)freeText), this.isUseHsm);
        }
        catch (Exception e) {
            this.logger.error(" =============== \u5c01\u88c5PKIMessage\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 5.\u53d1\u9001\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42");
        byte[] pkiInfo = null;
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, pkiMessage.getEncoded(), null, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
            pkiInfo = (byte[])postResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        if (pkiInfo == null) {
            this.logger.info("============== \u63a5\u6536CA\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 6.\u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f");
        try {
            checkCRGSdkResult = CmpMessageHelper.checkCmpHeaderAndSign(pkiInfo, raDN, caDN, senderNonce, transId, this.caCert, this.isUseHsm);
        }
        catch (NamingException e) {
            this.logger.error(" ============= \u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CERT_DN_IS_NOT_FORMAT);
            return sdkResult;
        }
        if (!checkCRGSdkResult.isSuccess()) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u5934\u548c\u7b7e\u540d\u9519\u8bef");
            sdkResult.setErrorBean(checkCRGSdkResult.getErrorBean());
            return sdkResult;
        }
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 7.\u83b7\u53d6CA\u8fd4\u56debody\u4e2d\u7684\u66f4\u65b0\u540e\u7684\u8bc1\u4e66\u4fe1\u606f");
        SdkResult resolveCmpRepSdkResult = CmpMessageHelper.resolveVarietyRepMessage(this.raSignPriKey, this.caCert, applyUserType, SdkConstants.CERT_APPLY_TYPE_UPDATE_2, pkiInfo, transId, certDN, this.raSignSn, this.keyIndex, this.pwd, this.isUseHsm);
        if (!resolveCmpRepSdkResult.isSuccess()) {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== 7.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
            sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
            return sdkResult;
        }
        sdkResult.setInfo(resolveCmpRepSdkResult.getInfo());
        this.logger.info("\u66f4\u65b0\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return sdkResult;
    }

    public SdkResult sendRevokeCertReqMessages(int applyUserType, String transId, String raDN, String caDN, String signSn, String userCertDN, int revokeType, String revokeReason) {
        SdkResult checkCRGSdkResult;
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a:{},\u7528\u6237\u7c7b\u578b\u4e3a:{},raDN\u4e3a:{},caDN\u4e3a:{},\u5f85\u64a4\u9500\u7b7e\u540d\u8bc1\u4e66sn\u4e3a:{},\u5f85\u64a4\u9500\u8bc1\u4e66\u4e3b\u4f53\u4e3a:{},\u64a4\u9500\u7c7b\u578b\u4e3a:{},\u64a4\u9500\u539f\u56e0\u4e3a:{}", new Object[]{transId, applyUserType, raDN, caDN, signSn, userCertDN, revokeType, revokeReason});
        SdkResult sdkResult = new SdkResult();
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (applyUserType != SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1 && applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            this.logger.info("=============== \u8bf7\u6c42\u7528\u6237\u7c7b\u578b\u9519\u8bef");
            sdkResult.setError(ErrorEnum.APPLY_USER_TYPE_IS_ERROR);
            return sdkResult;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN, signSn})) {
            this.logger.info("=============== \u53c2\u6570\u4e2dtransId,raDN,caDN,signSn\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        String url = "/v1/cmp";
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 1.\u5411CA\u83b7\u53d6\u968f\u673a\u6570");
        byte[] recipNonce = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transId", transId);
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, paramMap, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            recipNonce = (byte[])getResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CMP\u8bf7\u6c42\u968f\u673a\u6570\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_CMP_RANDOM_IS_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 2.\u5c01\u88c5RevReqContent\u7ed3\u6784\u4f53");
        RevReqContent revReqContent = null;
        try {
            revReqContent = CmpMessageHelper.genRevReqContent(caDN, userCertDN, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5RevReqContent\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_REV_REQ_CONTENT_EXCEPTION);
            return sdkResult;
        }
        byte[] senderNonce = new byte[16];
        try {
            senderNonce = CmpMessageHelper.genRandomByHsm(senderNonce.length);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u901a\u8fc7\u5bc6\u7801\u673a\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_RANDOM_BY_HSM_EXCEPTION);
            return sdkResult;
        }
        FreeText freeText = new FreeText();
        freeText.setApplyUserType(applyUserType);
        freeText.setRevokeCertInfo(new RevokeCertInfo(revokeType, revokeReason));
        freeText.setRaSignSn(this.raSignSn);
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 3.\u5c01\u88c5PkiMessage\u7ed3\u6784\u4f53");
        PKIMessage pkiMessage = null;
        try {
            pkiMessage = CmpMessageHelper.genPKIMessage(this.keyIndex, this.pwd, this.raSignPriKey, this.caCert, raDN, caDN, 11, recipNonce, senderNonce, transId, (ASN1Encodable)revReqContent, JSON.toJSONString((Object)freeText), this.isUseHsm);
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5PKIMessage\u5f02\u5e38\uff1a{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 4.\u53d1\u9001\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42");
        byte[] pkiInfo = null;
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, pkiMessage.getEncoded(), null, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
            pkiInfo = (byte[])postResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        if (pkiInfo == null) {
            this.logger.info("============== \u63a5\u6536CA\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 5.\u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f");
        try {
            checkCRGSdkResult = CmpMessageHelper.checkCmpHeaderAndSign(pkiInfo, raDN, caDN, senderNonce, transId, this.caCert, this.isUseHsm);
        }
        catch (NamingException e) {
            this.logger.error(" ============= \u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CERT_DN_IS_NOT_FORMAT);
            return sdkResult;
        }
        if (!checkCRGSdkResult.isSuccess()) {
            this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 5.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u5934\u548c\u7b7e\u540d\u9519\u8bef");
            sdkResult.setErrorBean(checkCRGSdkResult.getErrorBean());
            return sdkResult;
        }
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== 6.\u83b7\u53d6CA\u8fd4\u56debody\u4e2d\u7684\u64a4\u9500\u540e\u7684\u4fe1\u606f");
        SdkResult resolveCmpRepSdkResult = CmpMessageHelper.resolveVarietyRepMessage(this.raSignPriKey, this.caCert, applyUserType, SdkConstants.CERT_APPLY_TYPE_REVOKE_3, pkiInfo, transId, userCertDN, this.raSignSn, this.keyIndex, this.pwd, this.isUseHsm);
        if (!resolveCmpRepSdkResult.isSuccess()) {
            if (revokeType == SdkConstants.REV_REASON_CERTIFICATE_HOLD_6) {
                if (ErrorEnum.RA_CERT_ISSUE_STATUS_FROZEND.code == resolveCmpRepSdkResult.getErrorBean().getErrCode()) {
                    this.logger.info("\u51bb\u7ed3\u7533\u8bf7 ======== RA\u7533\u8bf7\u64a4\u9500\u7684\u8bc1\u4e66\u5df2\u88ab\u51bb\u7ed3");
                } else {
                    this.logger.info("\u51bb\u7ed3\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
                    sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
                }
            } else if (revokeType == SdkConstants.REV_REASON_REMOVE_FROM_CRL_8) {
                if (ErrorEnum.RA_CERT_ISSUE_STATUE_NORMAL.code == resolveCmpRepSdkResult.getErrorBean().getErrCode()) {
                    this.logger.info("\u89e3\u51bb\u7533\u8bf7 ======== RA\u7533\u8bf7\u64a4\u9500\u7684\u8bc1\u4e66\u5df2\u88ab\u89e3\u51bb");
                } else {
                    this.logger.info("\u89e3\u51bb\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
                    sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
                }
            } else if (ErrorEnum.RA_CERT_ISSUE_STATUS_REVOKED.code == resolveCmpRepSdkResult.getErrorBean().getErrCode()) {
                this.logger.info("\u64a4\u9500\u7533\u8bf7 ======== RA\u7533\u8bf7\u64a4\u9500\u7684\u8bc1\u4e66\u5df2\u88ab\u64a4\u9500");
            } else {
                this.logger.info("\u64a4\u9500\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
                sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
            }
            sdkResult.setInfo(resolveCmpRepSdkResult.getInfo());
            this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
            return sdkResult;
        }
        sdkResult.setInfo(resolveCmpRepSdkResult.getInfo());
        this.logger.info("\u64a4\u9500/\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return sdkResult;
    }

    public SdkResult sendRecoveryCertReqMessages(String transId, String raDN, String caDN, String signPubKey, String signAlg, String certDN, String recoverySignCertSn, Integer keyFormat) {
        SdkResult checkCRGSdkResult;
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a:{},raDN\u4e3a:{},caDN\u4e3a:{},\u7b7e\u540d\u516c\u94a5\u4e3a:{},\u7b7e\u540d\u7b97\u6cd5\u4e3a:{},\u7533\u8bf7\u8bc1\u4e66\u4e3b\u4f53\u4e3a:{},\u5f85\u6062\u590d\u7684\u7b7e\u540d\u8bc1\u4e66sn:{}", new Object[]{transId, raDN, caDN, signPubKey, signAlg, certDN, recoverySignCertSn});
        SdkResult sdkResult = new SdkResult();
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN, signPubKey, signAlg, certDN})) {
            this.logger.info("=============== \u53c2\u6570\u4e2dtransId,raDN,caDN,signPubKey,signAlg,certDN\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 1.\u5411CA\u83b7\u53d6\u968f\u673a\u6570");
        String url = "/v1/cmp";
        byte[] recipNonce = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transId", transId);
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, paramMap, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            recipNonce = (byte[])getResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CMP\u8bf7\u6c42\u968f\u673a\u6570\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_CMP_RANDOM_IS_EXCEPTION);
            return sdkResult;
        }
        if (recipNonce == null) {
            this.logger.info("============== CA\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        ASN1ObjectIdentifier signAlgIde = null;
        if ("SM3withSM2".equalsIgnoreCase(signAlg)) {
            signAlgIde = SM2ObjectIdentifiers.sm2SignWithSm3;
        } else if ("sha-1WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha1WithRSA;
        } else if ("sha256WithRSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = RsaObjectIdentifiers.sha256WithRSA;
        } else if ("SHA256WithECDSA".equalsIgnoreCase(signAlg)) {
            signAlgIde = NISTObjectIdentifiers.nistSignAlgorithm;
        } else {
            this.logger.error("===============  \u8bc1\u4e66\u7b7e\u540d\u7b97\u6cd5\u4e0d\u652f\u6301\uff1a" + signAlg);
            sdkResult.setError(ErrorEnum.CERT_SIGN_ALG_IS_NOT_SUPPORT);
            return sdkResult;
        }
        long certReqId = System.currentTimeMillis();
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 2.\u5c01\u88c5CertRequest\u7ed3\u6784\u4f53");
        CertRequest[] certRequests = new CertRequest[1];
        CertRequest certRequest = null;
        try {
            certRequest = CmpMessageHelper.genCertRequest(0, certDN, signPubKey == null ? null : Base64.decode((String)signPubKey), signAlgIde, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
        }
        catch (Exception e) {
            this.logger.error(" ===============  \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
            return sdkResult;
        }
        certRequests[0] = certRequest;
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 3.\u5c01\u88c5CertReqMessages\u7ed3\u6784\u4f53");
        CertReqMessages certReqMessages = null;
        try {
            certReqMessages = CmpMessageHelper.genCertReqMessages(certRequests);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u5c01\u88c5certRequestMessage\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_CERT_REQUEST_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        byte[] senderNonce = new byte[16];
        try {
            senderNonce = CmpMessageHelper.genRandomByHsm(senderNonce.length);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u901a\u8fc7\u5bc6\u7801\u673a\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_RANDOM_BY_HSM_EXCEPTION);
            return sdkResult;
        }
        FreeText freeText = new FreeText();
        freeText.setRaSignSn(this.raSignSn);
        freeText.setSignSn(recoverySignCertSn);
        freeText.setKeyFormat(keyFormat);
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        headerMap.put(transId, new BaseCMPInfo(senderNonce, recipNonce, transId, certReqId, 0));
        this.logger.info("=============== sendRecoveryCertReqMessages.baseCMPInfo.map>> transId: " + transId + " ========== " + SdkJsonUtils.object2Json(headerMap));
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 4.\u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage pkiMessage = null;
        try {
            pkiMessage = CmpMessageHelper.genPKIMessage(this.keyIndex, this.pwd, this.raSignPriKey, this.caCert, raDN, caDN, 9, recipNonce, senderNonce, transId, (ASN1Encodable)certReqMessages, JSON.toJSONString((Object)freeText), this.isUseHsm);
        }
        catch (Exception e) {
            this.logger.error(" =============== \u5c01\u88c5PKIMessage\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 5.\u53d1\u9001\u8bc1\u4e66\u6062\u590d\u7533\u8bf7\u8bf7\u6c42");
        url = "/v1/cmp";
        byte[] pkiInfo = null;
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, pkiMessage.getEncoded(), null, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
            pkiInfo = (byte[])postResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        if (pkiInfo == null) {
            this.logger.info("============== \u63a5\u6536CA\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_INFO_IS_EMPTY);
            return sdkResult;
        }
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 6.\u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f");
        try {
            checkCRGSdkResult = CmpMessageHelper.checkCmpHeaderAndSign(pkiInfo, raDN, caDN, senderNonce, transId, this.caCert, this.isUseHsm);
        }
        catch (NamingException e) {
            this.logger.error(" ============= \u68c0\u67e5CA\u8fd4\u56de\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u4fe1\u606f:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CERT_DN_IS_NOT_FORMAT);
            return sdkResult;
        }
        if (!checkCRGSdkResult.isSuccess()) {
            this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 6.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u5934\u548c\u7b7e\u540d\u9519\u8bef");
            sdkResult.setErrorBean(checkCRGSdkResult.getErrorBean());
            return sdkResult;
        }
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 7.\u83b7\u53d6CA\u8fd4\u56de\u7684\u8bc1\u4e66\u4fe1\u606f");
        SdkResult resolveCmpRepSdkResult = CmpMessageHelper.resolveVarietyRepMessage(this.raSignPriKey, this.caCert, SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1, SdkConstants.CERT_APPLY_TYPE_RECOVERY_4, pkiInfo, transId, certDN, this.raSignSn, this.keyIndex, this.pwd, this.isUseHsm);
        if (!resolveCmpRepSdkResult.isSuccess()) {
            this.logger.info("\u6062\u590d\u7533\u8bf7 ======== 7.1 \u89e3\u6790CA\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u9519\u8bef");
            sdkResult.setErrorBean(resolveCmpRepSdkResult.getErrorBean());
            return sdkResult;
        }
        sdkResult.setInfo(resolveCmpRepSdkResult.getInfo());
        this.logger.info("\u6062\u590d\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return sdkResult;
    }

    public SdkResult sendCertConfirmContent(int applyUserType, String transId, String raDN, String caDN, X509Certificate caCert) {
        this.logger.info("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        SdkResult sdkResult = new SdkResult();
        if (applyUserType != SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1 && applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            this.logger.info(" ================ \u8bf7\u6c42\u7528\u6237\u7c7b\u578b\u9519\u8bef");
            sdkResult.setError(ErrorEnum.APPLY_USER_TYPE_IS_ERROR);
            return sdkResult;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN, caDN})) {
            this.logger.info("=============== \u53c2\u6570\u4e2dtransId,raDN,caDN,caDN\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        String url = "/v1/cmp";
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        if (headerMap == null) {
            sdkResult.setError(ErrorEnum.LOCAL_CMP_CACHE_IS_EMPTY);
            return sdkResult;
        }
        BaseCMPInfo baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
        if (baseCMPInfo == null) {
            this.logger.info(" ================== \u672a\u627e\u5230RA\u53d1\u4ece\u7684\u8be5transId:" + transId);
            sdkResult.setError(ErrorEnum.CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE);
            return sdkResult;
        }
        byte[] recipNonce = baseCMPInfo.getRecipientNonce();
        byte[] senderNonce = baseCMPInfo.getSenderNonce();
        long certReqId = baseCMPInfo.getRequestId();
        this.logger.info("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== 1.\u5c01\u88c5CertConfirmContent\u7ed3\u6784\u4f53");
        CertConfirmContent certConfirmContent = null;
        try {
            certConfirmContent = CmpMessageHelper.genCertConfirmContent(transId, certReqId);
        }
        catch (Exception e) {
            this.logger.info("\u5c01\u88c5CertConfirmContent\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_CERT_CONFIRM_CONTENT_EXCEPTION);
            return sdkResult;
        }
        FreeText freeText = new FreeText();
        freeText.setApplyUserType(applyUserType);
        freeText.setRaSignSn(this.raSignSn);
        this.logger.info("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== 2.\u5c01\u88c5PkiMessage\u7ed3\u6784\u4f53");
        PKIMessage certConfirmPKIMessage = null;
        try {
            certConfirmPKIMessage = CmpMessageHelper.genPKIMessage(this.keyIndex, this.pwd, this.raSignPriKey, caCert, raDN, caDN, 24, recipNonce, senderNonce, transId, (ASN1Encodable)certConfirmContent, SdkJsonUtils.object2Json(freeText), this.isUseHsm);
        }
        catch (Exception e) {
            this.logger.info("\u5c01\u88c5PKIMessage\u5f02\u5e38\uff1a{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== 3.\u53d1\u9001\u8bc1\u4e66\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f");
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, certConfirmPKIMessage.getEncoded(), null, this.caBaseUrl + url, "application/pkixcmp", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
        }
        catch (Exception e) {
            this.logger.info(" ============= \u53d1\u9001Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
            return sdkResult;
        }
        this.logger.info("sendCertConfirmContent.sendCmpHttpPost.result>>>>" + SdkJsonUtils.object2Json(sdkResult));
        headerMap.remove(transId);
        this.logger.info("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ========  \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{}", (Object)transId);
        return sdkResult;
    }

    public SdkResult sendErrorMsgContent(int applyUserType, String transId, String raDN, String caDN, int errorCode, String errorMsg) {
        byte[] senderNonce;
        this.logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        SdkResult sdkResult = new SdkResult();
        this.logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== \u53c2\u4e0e\u6821\u9a8c");
        if (applyUserType != SdkConstants.APPLY_USER_TYPE_NORMAL_USER_1 && applyUserType != SdkConstants.APPLY_USER_TYPE_ADMIN_2) {
            this.logger.info("\u8bf7\u6c42\u7528\u6237\u7c7b\u578b\u9519\u8bef");
            sdkResult.setError(ErrorEnum.APPLY_USER_TYPE_IS_ERROR);
            return sdkResult;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, raDN, caDN})) {
            this.logger.info("=============== \u53c2\u6570\u4e2dtransId,raDN,caDN\u5b58\u5728\u7a7a\u503c");
            sdkResult.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return sdkResult;
        }
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        if (headerMap == null) {
            this.logger.info("\u672c\u5730\u7f13\u5b58\u6570\u636e\u4e3a\u7a7a");
            sdkResult.setError(ErrorEnum.LOCAL_CMP_CACHE_IS_EMPTY);
            return sdkResult;
        }
        BaseCMPInfo baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
        if (baseCMPInfo == null) {
            this.logger.info(" ================== \u672a\u627e\u5230RA\u53d1\u4ece\u7684\u8be5transId:" + transId);
            sdkResult.setError(ErrorEnum.CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE);
            return sdkResult;
        }
        byte[] recipNonce = baseCMPInfo.getRecipientNonce();
        SdkResult errorResult = CmpMessageHelper.genErrorPKIMsg(this.keyIndex, this.pwd, this.raSignPriKey, this.caCert, this.caCerts, this.raSignSn, applyUserType, errorMsg, errorCode, raDN, caDN, recipNonce, senderNonce = baseCMPInfo.getSenderNonce(), transId, this.caBaseUrl + "/v1/cmp", this.protectAlgName, this.isHttps, this.isUseHsm);
        if (!errorResult.isSuccess()) {
            sdkResult.setErrorBean(errorResult.getErrorBean());
        }
        headerMap.remove(transId);
        this.logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return sdkResult;
    }

    public SdkResult getRaBaseDN() {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/ra/baseDn";
        String raBaseDN = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            raBaseDN = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6RA\u7cfb\u7edfBaseDN\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(raBaseDN);
        return sdkResult;
    }

    public SdkResult getCertStatus(String signSn) {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/cert/status/" + signSn;
        String certStatus = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            certStatus = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(certStatus);
        return sdkResult;
    }

    public SdkResult downloadCertByteInfo(String signSn) {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/cert/download/" + signSn;
        String certByte = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            certByte = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u4e0b\u8f7d\u7528\u6237\u8bc1\u4e66\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(certByte);
        return sdkResult;
    }

    public SdkResult getCertDetailInfo(String signSn) {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/cert/detail/" + signSn;
        String detail = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            detail = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(detail);
        return sdkResult;
    }

    public SdkResult getCertTemplateList() {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/template/list";
        String list = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            list = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(list);
        return sdkResult;
    }

    public SdkResult getCertTemplateDetailInfo(String tempNo) {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/template/detail/" + tempNo;
        String tempDetail = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            tempDetail = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(tempDetail);
        return sdkResult;
    }

    public SdkResult getRaOperatorCertTemp() {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/template/manage";
        String tempDetail = null;
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, null, null, this.caBaseUrl + url, null, this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "get");
            if (!getResult.isSuccess()) {
                sdkResult.setErrorBean(getResult.getErrorBean());
                return sdkResult;
            }
            tempDetail = new String((byte[])getResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6\u7ba1\u7406\u5458\u8bc1\u4e66\u6a21\u677f\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(tempDetail);
        return sdkResult;
    }

    public SdkResult raAdminLoginAuthen(String signSn) {
        SdkResult sdkResult = new SdkResult();
        String url = "/v1/api/ra/login";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sn", signSn);
        String authenInfo = null;
        try {
            SdkResult postResult = ClientHttpUtils.sendApacheClientRequest(this.keyIndex, this.pwd, this.raSignPriKey, SdkJsonUtils.object2Json(map).getBytes(), null, this.caBaseUrl + url, "application/json", this.raSignSn, this.caCerts, this.protectAlgName, this.isHttps, this.isUseHsm, "post");
            if (!postResult.isSuccess()) {
                sdkResult.setErrorBean(postResult.getErrorBean());
                return sdkResult;
            }
            authenInfo = new String((byte[])postResult.getInfo());
        }
        catch (Exception e) {
            this.logger.error("===============  \u7ba1\u7406\u5458\u767b\u5f55\u8ba4\u8bc1\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        sdkResult.setInfo(authenInfo);
        return sdkResult;
    }

    public SdkResult sendCaServerMessages(String caServerIp, int caServerPort, String p7bHashCode, X509Certificate[] caCerts) {
        this.logger.info("\u6d4b\u8bd5CA\u670d\u52a1\u8fde\u901a\u6027================");
        SdkResult sdkResult = new SdkResult();
        String url = caServerIp + ":" + caServerPort + "/ca-openapi/v1/api/interface/test";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("certChainHash", p7bHashCode);
        try {
            SdkResult getResult = ClientHttpUtils.sendApacheClientRequestInit(null, paramMap, url, null, this.protectAlgName, this.isHttps, "get");
            if (!getResult.isSuccess()) {
                if (getResult.getErrorBean().errCode != 11451) {
                    sdkResult.setError(ErrorEnum.TEST_CA_SERVER_CONNECT_ERROR);
                    return sdkResult;
                }
                return getResult;
            }
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CA\u7cfb\u7edf\u8fd0\u884c\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
            return sdkResult;
        }
        return sdkResult;
    }
}

