/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.sdk;

import com.xdja.ca.error.ErrorBean;
import com.xdja.ca.error.ErrorEnum;
import java.io.Serializable;

public class SdkResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    private int code;
    private Object info;
    private ErrorEnum error;
    private ErrorBean errorBean;

    public SdkResult() {
    }

    public SdkResult(int code, Object info) {
        this(code, info, null);
    }

    public SdkResult(int code, Object info, ErrorEnum error) {
        this.code = code;
        this.info = info;
        this.error = error;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public ErrorBean getErrorBean() {
        return this.errorBean;
    }

    public void setErrorBean(ErrorBean errorBean) {
        this.code = errorBean.getErrCode();
        this.errorBean = errorBean;
    }

    public ErrorEnum getError() {
        return this.error;
    }

    public void setError(ErrorEnum error) {
        ErrorBean errorBean;
        this.code = error.code;
        this.error = error;
        this.errorBean = errorBean = new ErrorBean(error.code, error.errMsg);
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public static SdkResult success(Object info) {
        return new SdkResult(0, info);
    }

    public static SdkResult failure(ErrorEnum errorEnum) {
        return SdkResult.failure(errorEnum.code, errorEnum.errMsg);
    }

    public static SdkResult failure(Integer errorCode, String errorMsg) {
        ErrorBean errorBean = new ErrorBean(errorCode, errorMsg);
        SdkResult result = new SdkResult();
        result.setErrorBean(errorBean);
        return result;
    }

    public static void main(String[] args) {
        System.out.println(SdkResult.failure(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION));
        SdkResult sdkResult = new SdkResult();
        sdkResult.setError(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
        System.out.println(sdkResult);
        SdkResult sdkResult1 = new SdkResult();
        sdkResult.setError(ErrorEnum.CONNECT_CA_OPEN_API_REFUSED);
        sdkResult1.setErrorBean(sdkResult.getErrorBean());
        System.out.println(sdkResult1);
        System.out.println(SdkResult.success());
        System.out.println(SdkResult.success("1111"));
    }

    public static SdkResult success() {
        return new SdkResult(0, null);
    }

    public static SdkResult failure(int code) {
        return new SdkResult(code, null);
    }

    public static SdkResult failure(Object info, ErrorEnum error) {
        return new SdkResult(-1, info, error);
    }

    public String toString() {
        return "SdkResult{code=" + this.code + ", info=" + this.info + ", errorBean=" + this.errorBean + '}';
    }
}

