/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import com.xdja.ca.utils.HttpRespons;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.Vector;

public class HttpRequesterUtils {
    private String defaultContentEncoding = Charset.defaultCharset().name();

    public static HttpRespons sendGet(String urlString) throws IOException {
        return HttpRequesterUtils.send(urlString, "GET", null, null);
    }

    public static HttpRespons sendGet(String urlString, Map<String, String> params) throws IOException {
        return HttpRequesterUtils.send(urlString, "GET", params, null);
    }

    public HttpRespons sendPost(String urlString, Map<String, String> params, Map<String, String> propertys) throws IOException {
        return HttpRequesterUtils.send(urlString, "POST", params, propertys);
    }

    public static HttpRespons sendPost(String urlString, String params, String contentType) throws IOException {
        return HttpRequesterUtils.sendHttp(urlString, "POST", params, contentType);
    }

    private static HttpRespons send(String urlString, String method, Map<String, String> parameters, Map<String, String> propertys) throws IOException {
        HttpURLConnection urlConnection = null;
        if (method.equalsIgnoreCase("GET") && parameters != null) {
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : parameters.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(parameters.get(key));
                ++i;
            }
            urlString = urlString + param;
        }
        URL url = new URL(urlString);
        urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("sn", "1");
        urlConnection.setRequestProperty("time", String.valueOf(new Date().getTime()));
        urlConnection.setRequestProperty("sign", "\u7b7e\u540d\u503c");
        if (propertys != null) {
            for (String key : propertys.keySet()) {
                urlConnection.addRequestProperty(key, propertys.get(key));
            }
        }
        if (method.equalsIgnoreCase("POST") && parameters != null) {
            StringBuffer param = new StringBuffer();
            for (String key : parameters.keySet()) {
                param.append("&");
                param.append(key).append("=").append(parameters.get(key));
            }
            urlConnection.getOutputStream().write(param.toString().getBytes());
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
        }
        return HttpRequesterUtils.makeContent(urlString, urlConnection);
    }

    private static HttpRespons sendHttp(String urlString, String reqMethod, String params, String contentType) throws IOException {
        HttpURLConnection urlConnection = null;
        URL url = new URL(urlString);
        urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(reqMethod);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("accept", "*/*");
        urlConnection.setRequestProperty("connection", "Keep-Alive");
        urlConnection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        urlConnection.setRequestProperty("Content-type", "application/json");
        urlConnection.setRequestProperty("sn", "1");
        urlConnection.setRequestProperty("time", String.valueOf(new Date().getTime()));
        urlConnection.setRequestProperty("sign", "\u7b7e\u540d\u503c");
        urlConnection.getOutputStream().write(params.getBytes());
        urlConnection.getOutputStream().flush();
        urlConnection.getOutputStream().close();
        return HttpRequesterUtils.makeContent(urlString, urlConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRespons makeContent(String urlString, HttpURLConnection urlConnection) throws IOException {
        HttpRespons httpResponser = new HttpRespons();
        try {
            InputStream in = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            httpResponser.contentCollection = new Vector<String>();
            StringBuffer temp = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null) {
                httpResponser.contentCollection.add(line);
                temp.append(line).append("\r\n");
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            String ecod = urlConnection.getContentEncoding();
            if (ecod == null) {
                ecod = Charset.defaultCharset().name();
            }
            httpResponser.urlString = urlString;
            httpResponser.defaultPort = urlConnection.getURL().getDefaultPort();
            httpResponser.file = urlConnection.getURL().getFile();
            httpResponser.host = urlConnection.getURL().getHost();
            httpResponser.path = urlConnection.getURL().getPath();
            httpResponser.port = urlConnection.getURL().getPort();
            httpResponser.protocol = urlConnection.getURL().getProtocol();
            httpResponser.query = urlConnection.getURL().getQuery();
            httpResponser.ref = urlConnection.getURL().getRef();
            httpResponser.userInfo = urlConnection.getURL().getUserInfo();
            httpResponser.content = new String(temp.toString().getBytes(), ecod);
            httpResponser.contentEncoding = ecod;
            httpResponser.code = urlConnection.getResponseCode();
            httpResponser.message = urlConnection.getResponseMessage();
            httpResponser.contentType = urlConnection.getContentType();
            httpResponser.method = urlConnection.getRequestMethod();
            httpResponser.connectTimeout = urlConnection.getConnectTimeout();
            httpResponser.readTimeout = urlConnection.getReadTimeout();
            HttpRespons httpRespons = httpResponser;
            return httpRespons;
        }
        catch (IOException e) {
            httpResponser.code = urlConnection.getResponseCode();
            InputStream in = urlConnection.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            httpResponser.contentCollection = new Vector<String>();
            StringBuffer temp = new StringBuffer();
            String line = bufferedReader.readLine();
            while (line != null) {
                httpResponser.contentCollection.add(line);
                temp.append(line).append("\r\n");
                line = bufferedReader.readLine();
            }
            httpResponser.content = temp.toString();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return httpResponser;
    }

    public String getDefaultContentEncoding() {
        return this.defaultContentEncoding;
    }

    public void setDefaultContentEncoding(String defaultContentEncoding) {
        this.defaultContentEncoding = defaultContentEncoding;
    }
}

