/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.util.encoders.Base64;

public class RsaAlgUtils {
    public static final BigInteger PUBLICNT_EXPONENT = BigInteger.valueOf(65537L);

    public static PublicKey getRsaPublicKey(String modulus, BigInteger publicExponent) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] publicKeyByte = Base64.decode((String)modulus);
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)publicKeyByte);
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
        }
        catch (IOException e) {
            throw new InvalidKeySpecException(e);
        }
    }
}

