/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.RFC4519StyleUpperCase;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class SdkP10Utils {
    private static String unFormatP10(String pemP10) {
        String p10Value = null;
        String P10_HEAD = "-----BEGIN CERTIFICATE REQUEST-----";
        String P10_TAIL = "-----END CERTIFICATE REQUEST-----";
        pemP10 = pemP10.replace(P10_HEAD, "");
        pemP10 = pemP10.replace(P10_TAIL, "");
        pemP10 = pemP10.replace("\r", "");
        p10Value = pemP10 = pemP10.replace("\n", "");
        return p10Value;
    }

    public static boolean verifyP10Info(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String p10ToCertDn(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return SdkP10Utils.getDnByPKCS10(re);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDnByPKCS10(PKCS10CertificationRequest pkcs10) throws IOException {
        CertificationRequest certificationRequest = CertificationRequest.getInstance((Object)pkcs10.getEncoded());
        byte[] encoded = certificationRequest.getCertificationRequestInfo().getEncoded();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
        int seqStart = 0;
        if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
            seqStart = -1;
        }
        ASN1Encodable objectAt = seq.getObjectAt(seqStart + 2);
        X500Name x500Name = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)objectAt.toASN1Primitive());
        return SdkP10Utils.reverseDnSeq(x500Name);
    }

    public static String reverseDnSeq(X500Name x500Name) {
        RDN[] rdns = x500Name.getRDNs();
        if (0 == rdns.length) {
            return "";
        }
        if (rdns[0].getFirst().getType().equals((Object)RFC4519StyleUpperCase.cn) || rdns[rdns.length - 1].getFirst().getType().equals((Object)RFC4519StyleUpperCase.c)) {
            x500Name = new X500Name(RFC4519StyleUpperCase.INSTANCE, DnUtil.reverseRdns(rdns));
        }
        return x500Name.toString();
    }

    public static PublicKey p10ToPublicKey(String p10) {
        String p10Value = SdkP10Utils.unFormatP10(p10);
        byte[] bsCert = Base64.decode((String)p10Value);
        PKCS10CertificationRequest re = new PKCS10CertificationRequest(bsCert);
        re.getCertificationRequestInfo();
        PublicKey pk = null;
        try {
            pk = re.getPublicKey("BC");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return pk;
    }

    public static byte[] p10ToReqInfo(String p10) {
        String p10Value = SdkP10Utils.unFormatP10(p10);
        byte[] bsCert = Base64.decode((String)p10Value);
        PKCS10CertificationRequest re = new PKCS10CertificationRequest(bsCert);
        CertificationRequestInfo certificationRequestInfo = re.getCertificationRequestInfo();
        byte[] reqInfo = new byte[]{};
        try {
            reqInfo = certificationRequestInfo.getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reqInfo;
    }

    public static String p10ToSignValue(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignature().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ASN1ObjectIdentifier p10ToSignAlgo(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignatureAlgorithm().getAlgorithm();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

