package com.xdja.ca.service;

/**
 * CA SDK用于数据缓存管理操作
 * @author wangtf
 * @date 王腾飞
 */
public interface CaSdkRedisCacheManagerService {

    /**
     * 保存SDK和CA交互时
     * <br/>SDK的transId与baseCMPInfo的对应关系
     * @param sdkTransId 事务ID
     * @param baseCmpInfo CMP请求内容【random/transId等】
     * @return Boolean true 成功；false 失败
     */
    Boolean cacheCaSdkCmpInfo(String sdkTransId, String baseCmpInfo);

    /**
     * 获取并删除缓存信息
     * @param sdkTransId 事务ID
     * @return String CMP请求内容【random/transId等】
     */
    String removeCaSdkCmpInfo(String sdkTransId);

    /**
     * 获取缓存信息
     * @param sdkTransId 事务ID
     * @return String CMP请求内容【random/transId等】
     */
    String getCaSdkCmpInfo(String sdkTransId);

    /**
     * 获取递增的ReqID
     * <br/> RA通过CMP协议与CA交互时的ReqID
     * @return string ReqID
     */
    Long getIncCaCmpReqId();
}
