package com.xdja.ca.utils;

import com.alibaba.fastjson.JSONException;
import org.bouncycastle.util.encoders.Base64;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author zjr
 * @Description: ca-openapi签名业务数据原文组装工具类
 * @date 2019年7月5日
 */
public class OpenApiReqSignDataUtil {
    /**
     * 组装GET请求签名业务数据原文; header参数json字节数组 + uri字节数组
     *
     * @param sn
     * @param time
     * @param uri
     * @return
     * @throws JSONException String
     */
    public static String buildGetReqSignData(String sn, String time, String uri) throws JSONException {
        byte[] uriByte = uri.getBytes();
        byte[] headerParms = convertHeaderParamsToJsonBytes(sn, time);
     //   System.out.println(Arrays.toString(headerParms));
        return Base64.toBase64String(getBusinessDataBtye(headerParms, uriByte));
    }

    /**
     * 组装POST请求签名业务数据原文;header参数json字节数组 + body字节数组
     *
     * @param sn
     * @param time
     * @param bodyData
     * @return
     * @throws JSONException String
     */
    public static String buildPostReqSignData(String sn, String time, byte[] bodyData) throws JSONException {
        byte[] headerParams = convertHeaderParamsToJsonBytes(sn, time);
        return Base64.toBase64String(getBusinessDataBtye(headerParams, bodyData));
    }

    /**
     * header参数转json字节数组
     *
     * @param sn
     * @param time
     * @return
     * @throws JSONException byte[]
     */
    public static byte[] convertHeaderParamsToJsonBytes(String sn, String time) throws JSONException {
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sn", sn);
        map.put("time", time);
        return SdkJsonUtils.object2Json(map).getBytes();
    }

    private static byte[] getBusinessDataBtye(byte[] headerParms, byte[] bodyData) {
        byte[] businessData = new byte[bodyData.length + headerParms.length];
        if (headerParms.length > 0) {
            System.arraycopy(headerParms, 0, businessData, 0, headerParms.length);
        }
        if (bodyData.length > 0) {
            System.arraycopy(bodyData, 0, businessData, headerParms.length, bodyData.length);
        }
        return businessData;
    }
}