package com.xdja.ca.utils;

import java.util.Hashtable;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.AbstractX500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class RFC4519StyleUpperCase
        extends AbstractX500NameStyle
{
    public static final ASN1ObjectIdentifier businessCategory = new ASN1ObjectIdentifier("2.5.4.15").intern();
    public static final ASN1ObjectIdentifier c = new ASN1ObjectIdentifier("2.5.4.6").intern();
    public static final ASN1ObjectIdentifier cn = new ASN1ObjectIdentifier("2.5.4.3").intern();
    public static final ASN1ObjectIdentifier dc = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25").intern();
    public static final ASN1ObjectIdentifier description = new ASN1ObjectIdentifier("2.5.4.13").intern();
    public static final ASN1ObjectIdentifier destinationIndicator = new ASN1ObjectIdentifier("2.5.4.27").intern();
    public static final ASN1ObjectIdentifier distinguishedName = new ASN1ObjectIdentifier("2.5.4.49").intern();
    public static final ASN1ObjectIdentifier dnQualifier = new ASN1ObjectIdentifier("2.5.4.46").intern();
    public static final ASN1ObjectIdentifier enhancedSearchGuide = new ASN1ObjectIdentifier("2.5.4.47").intern();
    public static final ASN1ObjectIdentifier facsimileTelephoneNumber = new ASN1ObjectIdentifier("2.5.4.23").intern();
    public static final ASN1ObjectIdentifier generationQualifier = new ASN1ObjectIdentifier("2.5.4.44").intern();
    public static final ASN1ObjectIdentifier givenName = new ASN1ObjectIdentifier("2.5.4.42").intern();
    public static final ASN1ObjectIdentifier houseIdentifier = new ASN1ObjectIdentifier("2.5.4.51").intern();
    public static final ASN1ObjectIdentifier initials = new ASN1ObjectIdentifier("2.5.4.43").intern();
    public static final ASN1ObjectIdentifier internationalISDNNumber = new ASN1ObjectIdentifier("2.5.4.25").intern();
    public static final ASN1ObjectIdentifier l = new ASN1ObjectIdentifier("2.5.4.7").intern();
    public static final ASN1ObjectIdentifier member = new ASN1ObjectIdentifier("2.5.4.31").intern();
    public static final ASN1ObjectIdentifier name = new ASN1ObjectIdentifier("2.5.4.41").intern();
    public static final ASN1ObjectIdentifier o = new ASN1ObjectIdentifier("2.5.4.10").intern();
    public static final ASN1ObjectIdentifier ou = new ASN1ObjectIdentifier("2.5.4.11").intern();
    public static final ASN1ObjectIdentifier owner = new ASN1ObjectIdentifier("2.5.4.32").intern();
    public static final ASN1ObjectIdentifier physicalDeliveryOfficeName = new ASN1ObjectIdentifier("2.5.4.19").intern();
    public static final ASN1ObjectIdentifier postalAddress = new ASN1ObjectIdentifier("2.5.4.16").intern();
    public static final ASN1ObjectIdentifier postalCode = new ASN1ObjectIdentifier("2.5.4.17").intern();
    public static final ASN1ObjectIdentifier postOfficeBox = new ASN1ObjectIdentifier("2.5.4.18").intern();
    public static final ASN1ObjectIdentifier preferredDeliveryMethod = new ASN1ObjectIdentifier("2.5.4.28").intern();
    public static final ASN1ObjectIdentifier registeredAddress = new ASN1ObjectIdentifier("2.5.4.26").intern();
    public static final ASN1ObjectIdentifier roleOccupant = new ASN1ObjectIdentifier("2.5.4.33").intern();
    public static final ASN1ObjectIdentifier searchGuide = new ASN1ObjectIdentifier("2.5.4.14").intern();
    public static final ASN1ObjectIdentifier seeAlso = new ASN1ObjectIdentifier("2.5.4.34").intern();
    public static final ASN1ObjectIdentifier serialNumber = new ASN1ObjectIdentifier("2.5.4.5").intern();
    public static final ASN1ObjectIdentifier sn = new ASN1ObjectIdentifier("2.5.4.4").intern();
    public static final ASN1ObjectIdentifier st = new ASN1ObjectIdentifier("2.5.4.8").intern();
    public static final ASN1ObjectIdentifier street = new ASN1ObjectIdentifier("2.5.4.9").intern();
    public static final ASN1ObjectIdentifier telephoneNumber = new ASN1ObjectIdentifier("2.5.4.20").intern();
    public static final ASN1ObjectIdentifier teletexTerminalIdentifier = new ASN1ObjectIdentifier("2.5.4.22").intern();
    public static final ASN1ObjectIdentifier telexNumber = new ASN1ObjectIdentifier("2.5.4.21").intern();
    public static final ASN1ObjectIdentifier title = new ASN1ObjectIdentifier("2.5.4.12").intern();
    public static final ASN1ObjectIdentifier uid = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1").intern();
    public static final ASN1ObjectIdentifier uniqueMember = new ASN1ObjectIdentifier("2.5.4.50").intern();
    public static final ASN1ObjectIdentifier userPassword = new ASN1ObjectIdentifier("2.5.4.35").intern();
    public static final ASN1ObjectIdentifier x121Address = new ASN1ObjectIdentifier("2.5.4.24").intern();
    public static final ASN1ObjectIdentifier x500UniqueIdentifier = new ASN1ObjectIdentifier("2.5.4.45").intern();
    /**
     * Email address (RSA PKCS#9 extension) - IA5String.
     * <p>Note: if you're trying to be ultra orthodox, don't use this! It shouldn't be in here.
     */
    public static final ASN1ObjectIdentifier EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;

    /**
     * email address in Verisign certificates
     */
    public static final ASN1ObjectIdentifier E = EmailAddress;
    /**
     * default look up table translating OID values into their common symbols following
     * the convention in RFC 2253 with a few extras
     */
    private static final Hashtable DefaultSymbols = new Hashtable();

    /**
     * look up table translating common symbols into their OIDS.
     */
    private static final Hashtable DefaultLookUp = new Hashtable();

    static
    {
        DefaultSymbols.put(businessCategory, "businessCategory".toUpperCase());
        DefaultSymbols.put(c, "c".toUpperCase());
        DefaultSymbols.put(cn, "CN");
        DefaultSymbols.put(dc, "dc".toUpperCase());
        DefaultSymbols.put(description, "description".toUpperCase());
        DefaultSymbols.put(destinationIndicator, "destinationIndicator".toUpperCase());
        DefaultSymbols.put(distinguishedName, "distinguishedName".toUpperCase());
        DefaultSymbols.put(dnQualifier, "dnQualifier".toUpperCase());
        DefaultSymbols.put(enhancedSearchGuide, "enhancedSearchGuide".toUpperCase());
        DefaultSymbols.put(facsimileTelephoneNumber, "facsimileTelephoneNumber".toUpperCase());
        DefaultSymbols.put(generationQualifier, "generationQualifier".toUpperCase());
        DefaultSymbols.put(givenName, "givenName".toUpperCase());
        DefaultSymbols.put(houseIdentifier, "houseIdentifier".toUpperCase());
        DefaultSymbols.put(initials, "initials".toUpperCase());
        DefaultSymbols.put(internationalISDNNumber, "internationalISDNNumber".toUpperCase());
        DefaultSymbols.put(l, "l".toUpperCase());
        DefaultSymbols.put(member, "member".toUpperCase());
        DefaultSymbols.put(name, "name".toUpperCase());
        DefaultSymbols.put(o, "o".toUpperCase());
        DefaultSymbols.put(ou, "ou".toUpperCase());
        DefaultSymbols.put(owner, "owner".toUpperCase());
        DefaultSymbols.put(physicalDeliveryOfficeName, "physicalDeliveryOfficeName".toUpperCase());
        DefaultSymbols.put(postalAddress, "postalAddress".toUpperCase());
        DefaultSymbols.put(postalCode, "postalCode".toUpperCase());
        DefaultSymbols.put(postOfficeBox, "postOfficeBox".toUpperCase());
        DefaultSymbols.put(preferredDeliveryMethod, "preferredDeliveryMethod".toUpperCase());
        DefaultSymbols.put(registeredAddress, "registeredAddress".toUpperCase());
        DefaultSymbols.put(roleOccupant, "roleOccupant".toUpperCase());
        DefaultSymbols.put(searchGuide, "searchGuide".toUpperCase());
        DefaultSymbols.put(seeAlso, "seeAlso".toUpperCase());
        DefaultSymbols.put(serialNumber, "serialNumber".toUpperCase());
        DefaultSymbols.put(sn, "sn".toUpperCase());
        DefaultSymbols.put(st, "st".toUpperCase());
        DefaultSymbols.put(street, "street".toUpperCase());
        DefaultSymbols.put(telephoneNumber, "telephoneNumber".toUpperCase());
        DefaultSymbols.put(teletexTerminalIdentifier, "teletexTerminalIdentifier".toUpperCase());
        DefaultSymbols.put(telexNumber, "telexNumber".toUpperCase());
        DefaultSymbols.put(title, "title".toUpperCase());
        DefaultSymbols.put(uid, "uid".toUpperCase());
        DefaultSymbols.put(uniqueMember, "uniqueMember".toUpperCase());
        DefaultSymbols.put(userPassword, "userPassword".toUpperCase());
        DefaultSymbols.put(x121Address, "x121Address".toUpperCase());
        DefaultSymbols.put(x500UniqueIdentifier, "x500UniqueIdentifier".toUpperCase());
        DefaultSymbols.put(EmailAddress, "E".toUpperCase());


        DefaultLookUp.put("businesscategory", businessCategory);
        DefaultLookUp.put("c", c);
        DefaultLookUp.put("cn", cn);
        DefaultLookUp.put("dc", dc);
        DefaultLookUp.put("description", description);
        DefaultLookUp.put("destinationindicator", destinationIndicator);
        DefaultLookUp.put("distinguishedname", distinguishedName);
        DefaultLookUp.put("dnqualifier", dnQualifier);
        DefaultLookUp.put("enhancedsearchguide", enhancedSearchGuide);
        DefaultLookUp.put("facsimiletelephonenumber", facsimileTelephoneNumber);
        DefaultLookUp.put("generationqualifier", generationQualifier);
        DefaultLookUp.put("givenname", givenName);
        DefaultLookUp.put("houseidentifier", houseIdentifier);
        DefaultLookUp.put("initials", initials);
        DefaultLookUp.put("internationalisdnnumber", internationalISDNNumber);
        DefaultLookUp.put("l", l);
        DefaultLookUp.put("member", member);
        DefaultLookUp.put("name", name);
        DefaultLookUp.put("o", o);
        DefaultLookUp.put("ou", ou);
        DefaultLookUp.put("owner", owner);
        DefaultLookUp.put("physicaldeliveryofficename", physicalDeliveryOfficeName);
        DefaultLookUp.put("postaladdress", postalAddress);
        DefaultLookUp.put("postalcode", postalCode);
        DefaultLookUp.put("postofficebox", postOfficeBox);
        DefaultLookUp.put("preferreddeliverymethod", preferredDeliveryMethod);
        DefaultLookUp.put("registeredaddress", registeredAddress);
        DefaultLookUp.put("roleoccupant", roleOccupant);
        DefaultLookUp.put("searchguide", searchGuide);
        DefaultLookUp.put("seealso", seeAlso);
        DefaultLookUp.put("serialnumber", serialNumber);
        DefaultLookUp.put("sn", sn);
        DefaultLookUp.put("st", st);
        DefaultLookUp.put("street", street);
        DefaultLookUp.put("telephonenumber", telephoneNumber);
        DefaultLookUp.put("teletexterminalidentifier", teletexTerminalIdentifier);
        DefaultLookUp.put("telexnumber", telexNumber);
        DefaultLookUp.put("title", title);
        DefaultLookUp.put("uid", uid);
        DefaultLookUp.put("uniquemember", uniqueMember);
        DefaultLookUp.put("userpassword", userPassword);
        DefaultLookUp.put("x121address", x121Address);
        DefaultLookUp.put("x500uniqueidentifier", x500UniqueIdentifier);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("e", E);
        // TODO: need to add correct matching for equality comparisons.
    }

    /**
     * Singleton instance.
     */
    public static final X500NameStyle INSTANCE = new RFC4519StyleUpperCase();

    protected final Hashtable defaultLookUp;
    protected final Hashtable defaultSymbols;

    protected RFC4519StyleUpperCase()
    {
        defaultSymbols = copyHashTable(DefaultSymbols);
        defaultLookUp = copyHashTable(DefaultLookUp);
    }

    @Override
    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier oid,
                                              String value) {
        if (oid.equals(dc) || oid.equals(EmailAddress))
        {
            return new DERIA5String(value);
        }
        else if (oid.equals(c) || oid.equals(serialNumber) || oid.equals(dnQualifier)
                || oid.equals(telephoneNumber))
        {
            return new DERPrintableString(value);
        }

        return super.encodeStringValue(oid, value);
    }

    @Override
    public String oidToDisplayName(ASN1ObjectIdentifier oid)
    {
        return (String)DefaultSymbols.get(oid);
    }

    @Override
    public String[] oidToAttrNames(ASN1ObjectIdentifier oid)
    {
        return IETFUtils.findAttrNamesForOID(oid, defaultLookUp);
    }

    @Override
    public ASN1ObjectIdentifier attrNameToOID(String attrName)
    {
        return IETFUtils.decodeAttrName(attrName, defaultLookUp);
    }

    // parse backwards
    @Override
    public RDN[] fromString(String dirName)
    {
        //return IETFUtils.rDNsFromString(dirName, this);
        RDN[] tmp = IETFUtils.rDNsFromString(dirName, this);
        RDN[] res = new RDN[tmp.length];

        for (int i = 0; i != tmp.length; i++)
        {
            res[res.length - i - 1] = tmp[i];
        }

        return res;
    }

    // convert in reverse
    @Override
    public String toString(X500Name name)
    {
        StringBuffer buf = new StringBuffer();
        boolean first = true;

        RDN[] rdns = name.getRDNs();

        for (int i = rdns.length - 1; i >= 0; i--)
        //for (int i=0; i<rdns.length; i++)
        {
            if (first)
            {
                first = false;
            }
            else
            {
                buf.append(',');
            }

            IETFUtils.appendRDN(buf, rdns[i], defaultSymbols);
        }

        //System.out.println(buf.toString());
        String dnResult  = buf.toString().replaceAll("\\\\,",",");
        return dnResult;
    }
}
