package com.xdja.ca.asn1;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;

/**
 * @author wly
 */
public interface NISTObjectIdentifiers {

    ASN1ObjectIdentifier nistSignAlgorithm = new ASN1ObjectIdentifier("1.2.840.10045.4.3.2");

    ASN1ObjectIdentifier ansi_X9_62 = new ASN1ObjectIdentifier("1.2.840.10045");

    ASN1ObjectIdentifier id_ecSigType = ansi_X9_62.branch("4");

    ASN1ObjectIdentifier ecdsa_with_SHA2 = id_ecSigType.branch("3");
    //等价于nistSignAlgorithm
    ASN1ObjectIdentifier sha256WithECDSA = ecdsa_with_SHA2.branch("2");

    ASN1ObjectIdentifier sha384WithECDSA = ecdsa_with_SHA2.branch("3");

    ASN1ObjectIdentifier sha512WithECDSA = ecdsa_with_SHA2.branch("4");

    ASN1ObjectIdentifier  nist256 = new ASN1ObjectIdentifier("1.2.840.10045.3.1.7");

    ASN1ObjectIdentifier nist384 = new ASN1ObjectIdentifier("1.3.132.0.34");

    ASN1ObjectIdentifier nist512 = new ASN1ObjectIdentifier("1.3.132.0.35");

}
