package com.xdja.ca.asn1;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;

/**
 * RSA算法OID定义
 * @author syg
 */
public interface RsaObjectIdentifiers {

    ASN1ObjectIdentifier rsaAlgorithm = new ASN1ObjectIdentifier("1.2.840.113549.1.1");
    ASN1ObjectIdentifier sha1WithRSA = rsaAlgorithm.branch("5");
    ASN1ObjectIdentifier sha256WithRSA = rsaAlgorithm.branch("11");
    ASN1ObjectIdentifier sha384WithRSA = rsaAlgorithm.branch("12");
    ASN1ObjectIdentifier sha512WithRSA = rsaAlgorithm.branch("13");
    /** OID: 1.2.840.113549.1.1.1 */
    ASN1ObjectIdentifier rsaEncryption = rsaAlgorithm.branch("1");

}
