package com.xdja.ca.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class CertPolicyVO implements Serializable {

    //证书策略OID
    private String attrId;

    //CPSUri列表
    private List<String> cps;

    //用户通告列表
    private List<String> userNotice;

    public String getAttrId() {
        return attrId;
    }

    public void setAttrId(String attrId) {
        this.attrId = attrId;
    }

    public List<String> getCps() {
        return cps;
    }

    public void setCps(List<String> cps) {
        this.cps = cps;
    }

    public List<String> getUserNotice() {
        return userNotice;
    }

    public void setUserNotice(List<String> userNotice) {
        this.userNotice = userNotice;
    }

    @Override
    public String toString() {
        return "CertPolicyVO{" +
                "attrId='" + attrId + '\'' +
                ", cps=" + cps.toString() +
                ", userNotice=" + userNotice.toString() +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertPolicyVO that = (CertPolicyVO) o;
        return Objects.equals(attrId, that.attrId) && Objects.equals(cps, that.cps) && Objects.equals(userNotice, that.userNotice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(attrId, cps, userNotice);
    }
}
