package com.xdja.ca.utils;

import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.util.encoders.Base64;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class RsaAlgUtils {

    /**
     * RSA公钥默认e值
     */
    public static final BigInteger PUBLICNT_EXPONENT = BigInteger.valueOf(65537L);

    /**
     * 根据m和e生成rsa公钥
     * @param modulus
     * @param publicExponent
     * @return
     * @throws InvalidKeySpecException
     * @throws NoSuchProviderException
     * @throws NoSuchAlgorithmException
     */
    public static PublicKey getRsaPublicKey(String modulus, BigInteger publicExponent) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] publicKeyByte = Base64.decode(modulus);
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(publicKeyByte);
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
        } catch (IOException e) {
            throw new InvalidKeySpecException(e);
        }
    }

}
