package com.xdja.ca.asn1;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;

/**
 * HMAC的Oid定义
 * @author syg
 */
public interface HmacObjectIdentifiers {
    ASN1ObjectIdentifier digestAlgorithm = new ASN1ObjectIdentifier("1.2.840.113549.2");
    ASN1ObjectIdentifier HmacWithSHA1 = digestAlgorithm.branch("7").intern();
    ASN1ObjectIdentifier HmacWithSHA224 = digestAlgorithm.branch("8").intern();
    ASN1ObjectIdentifier HmacWithSHA256 = digestAlgorithm.branch("9").intern();
    ASN1ObjectIdentifier HmacWithSHA384 = digestAlgorithm.branch("10").intern();
    ASN1ObjectIdentifier HmacWithSHA512 = digestAlgorithm.branch("11").intern();
}
