package com.xdja.ca.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 证书核心扩展项
 * @author syg
 */
public class CertCoreExtendInfoVO implements Serializable {
    // 本级CA路径长度约束值
    private Integer pathLengthConstraint;

    // 本级CA的名称限制值base64编码数据
    private Map<String, Map<String,Set>> nameConstraint;

    // 本级CA禁止任意长度值
    private Integer inhibitAnyPolicy;

    // 本级CA策略限制长度值
    private Integer requireExplicitPolicy;

    // 本级CA禁止策略映射值
    private Integer inhibitPolicyMapping;

    // 本级CA拥有的策略集合列表
    private List<CertPolicyVO> certPolicyList;

    // 本级CA私钥使用期开始时间
    private String privateKeyUsageStart;

    // 本级CA私钥使用期结束时间
    private String privateKeyUsageEnd;

    // 本级CA是否包含主体替换名称
    private boolean caIsContainSubjectAltName;

    public Integer getPathLengthConstraint() {
        return pathLengthConstraint;
    }

    public void setPathLengthConstraint(Integer pathLengthConstraint) {
        this.pathLengthConstraint = pathLengthConstraint;
    }

    public Map<String, Map<String, Set>> getNameConstraint() {
        return nameConstraint;
    }

    public void setNameConstraint(Map<String, Map<String, Set>> nameConstraint) {
        this.nameConstraint = nameConstraint;
    }

    public Integer getInhibitAnyPolicy() {
        return inhibitAnyPolicy;
    }

    public void setInhibitAnyPolicy(Integer inhibitAnyPolicy) {
        this.inhibitAnyPolicy = inhibitAnyPolicy;
    }

    public Integer getRequireExplicitPolicy() {
        return requireExplicitPolicy;
    }

    public void setRequireExplicitPolicy(Integer requireExplicitPolicy) {
        this.requireExplicitPolicy = requireExplicitPolicy;
    }

    public Integer getInhibitPolicyMapping() {
        return inhibitPolicyMapping;
    }

    public void setInhibitPolicyMapping(Integer inhibitPolicyMapping) {
        this.inhibitPolicyMapping = inhibitPolicyMapping;
    }

    public List<CertPolicyVO> getCertPolicyList() {
        return certPolicyList;
    }

    public void setCertPolicyList(List<CertPolicyVO> certPolicyList) {
        this.certPolicyList = certPolicyList;
    }

    public String getPrivateKeyUsageStart() {
        return privateKeyUsageStart;
    }

    public void setPrivateKeyUsageStart(String privateKeyUsageStart) {
        this.privateKeyUsageStart = privateKeyUsageStart;
    }

    public String getPrivateKeyUsageEnd() {
        return privateKeyUsageEnd;
    }

    public void setPrivateKeyUsageEnd(String privateKeyUsageEnd) {
        this.privateKeyUsageEnd = privateKeyUsageEnd;
    }

    public boolean isCaIsContainSubjectAltName() {
        return caIsContainSubjectAltName;
    }

    public void setCaIsContainSubjectAltName(boolean caIsContainSubjectAltName) {
        this.caIsContainSubjectAltName = caIsContainSubjectAltName;
    }

    @Override
    public String toString() {
        return "CertCoreExtendInfoVO{" +
                "pathLengthConstraint=" + pathLengthConstraint +
                ", nameConstraint=" + nameConstraint +
                ", inhibitAnyPolicy=" + inhibitAnyPolicy +
                ", requireExplicitPolicy=" + requireExplicitPolicy +
                ", inhibitPolicyMapping=" + inhibitPolicyMapping +
                ", certPolicyList=" + certPolicyList +
                ", privateKeyUsageStart='" + privateKeyUsageStart + '\'' +
                ", privateKeyUsageEnd='" + privateKeyUsageEnd + '\'' +
                ", caIsContainSubjectAltName=" + caIsContainSubjectAltName +
                '}';
    }
}
