package com.xdja.ca.constant;

public enum KeyAlgEnum {

    /**
     * 算法类型 1-RSA
     */
    RSA(1,"RSA"),
    /**
     * 算法类型 2-SM2
     */
    SM2(2,"SM2"),

    /**
     * 算法类型 3-NISTP256
     */
    ECC(3,"NISTP256"),

    ED25519(4,"ED25519");

    public int value;

    public String desc;

    KeyAlgEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getValueFromId(int id) {
        for (KeyAlgEnum d : KeyAlgEnum.values()) {
            if (d.value == id) {
                return d.desc;
            }
        }
        throw new IllegalArgumentException(String.format("KeyAlgEnum 枚举转换异常[id=%d]", id));
    }
}
