package com.xdja.ca.constant;

/**
 * 系统常量定义
 *
 * @author syg
 */
public class SdkConstants {

    /**
     * 模板状态  1:未启用
     */
    public static final int TEMP_STATUS_NOT_RUN_1 = 1;

    /**
     * 模板状态  2：使用中
     */
    public static final int TEMP_STATUS_RUN_2 = 2;

    /**
     * 模板状态  3：停用
     */
    public static final int TEMP_STATUS_STOP_3 = 3;

    /**
     * 证书审核策略   1:自动审核
     */
    public static final int TEMP_CHECK_STRATEGY_AUTO_1 = 1;

    /**
     * 证书审核策略  2:人工审核
     */
    public static final int TEMP_CHECK_STRATEGY_MANUAL_2 = 2;

    /**
     * 分页查询状态  未传值标识：-1
     */

    public static final int USER_STATUS_1 = -1;
    /**
     * 用户状态  1:正常
     */
    public static final int USER_STATUS_NORMAL_0 = 0;

    /**
     * 用户状态  2:已停用
     */
    public static final int USER_STATUS_STOP_1 = 1;

    /**
     * 下载类型  1： 模板下载
     * 2： 错误信息下载
     */
    public static final int DOWNLOAD_TYPE_1 = 1;
    public static final int DOWNLOAD_TYPE_2 = 2;
    /**
     * 用户类型  1:个人用户批量注册信息表模板
     */
    public static final int USER_TYPE_PERSON_1 = 1;

    public static final String PERSON_1 = "个人用户批量注册信息表模板";

    /**
     * 用户类型  2:机构用户批量注册信息表模板
     */
    public static final int USER_TYPE_ORGAN_2 = 2;

    public static final String ORGAN_1 = "机构用户批量注册信息表模板";

    /**
     * 用户类型  3:设备用户批量注册信息表模板
     */
    public static final int USER_TYPE_DEVICE_3 = 3;

    public static final String DEVICE_1 = "设备用户批量注册信息表模板";
    /**
     * 文件下载
     * filename 后缀拼接
     */
    public static final String EXCEL_SUFFIX = ".xlsx";
    /**
     * 机构用户--读excel部分
     */
    /**
     * excel 后缀判断
     */
    public static final String EXCEL_TYPE_1 = "xls";
    public static final String EXCEL_TYPE_2 = "xlsx";

    /**
     * 签名算法
     */
    public static final String SIGN_ALG_NAME_SM3_WHIT_SM2 = "SM3withSM2";
    public static final String SIGN_ALG_NAME_SHA1_WHIT_RSA = "SHA-1withRSA";
    public static final String SIGN_ALG_NAME_SHA1_WHIT_RSA_2 = "SHA1withRSA";
    public static final String SIGN_ALG_NAME_SHA256_WHIT_RSA = "SHA256withRSA";
    public static final String SIGN_ALG_NAME_SHA384_WHIT_RSA = "SHA384withRSA";//sprint14
    public static final String SIGN_ALG_NAME_SHA512_WHIT_RSA = "SHA512withRSA";
    public static final String SIGN_ALG_NAME_SHA256_WHIT_ECDSA = "SHA256withECDSA";
    public static final String SIGN_ALG_NAME_SHA384_WHIT_ECDSA = "SHA384withECDSA";
    public static final String SIGN_ALG_NAME_SHA512_WHIT_ECDSA = "SHA512withECDSA";
    public static final String SIGN_ALG_NAME_ED25519 = "Ed25519";

    public static final String KEY_ALG_NAME_SM2 = "SM2";
    public static final String KEY_ALG_NAME_RSA = "RSA";
    public static final String KEY_ALG_NAME_NIST = "NISTP256";
    public static final String KEY_ALG_NAME_NIST_2 = "ECC";

    /**
     * Nist384,512长度定义
     */
    public static final int NIST_384 = 384;
    public static final int NIST_521 = 521;

    /**
     * 机构用户--机构licenseType 定义
     * 企业工商注册号：1
     * 企业组织机构代码：2
     * 企业税号：3
     * 其他：4
     * 空：5
     */
    public static final String ORGAN_LICENSE_TYPE_1 = "企业工商注册号";
    public static final int LICENSE_TYPE_1 = 1;

    public static final String ORGAN_LICENSE_TYPE_2 = "企业组织机构代码";
    public static final int LICENSE_TYPE_2 = 2;

    public static final String ORGAN_LICENSE_TYPE_3 = "企业税号";
    public static final int LICENSE_TYPE_3 = 3;

    public static final String ORGAN_LICENSE_TYPE_4 = "其他";
    public static final int LICENSE_TYPE_4 = 4;

    public static final int LICENSE_TYPE_5 = 5;

    /**
     * 用户--sex定义
     * 性别错误：2
     */
    public static final String USER_PERSON_SEX_0 = "男";
    public static final int PERSON_SEX_0 = 0;

    public static final String USER_PERSON_SEX_1 = "女";
    public static final int PERSON_SEX_1 = 1;

    public static final int PERSON_SEX_2 = 2;

    /**
     * 用户--联系人licenseType 定义
     * 身份证：1
     * 军官证：2
     * 护照：3
     * 其他：4
     * 空或者非以上：5
     */
    public static final String USER_PERSON_LICENSE_TYPE_1 = "身份证";

    public static final int PERSON_LICENSE_TYPE_1 = 1;

    public static final String USER_PERSON_LICENSE_TYPE_2 = "军官证";

    public static final int PERSON_LICENSE_TYPE_2 = 2;

    public static final String USER_PERSON_LICENSE_TYPE_3 = "护照";

    public static final int PERSON_LICENSE_TYPE_3 = 3;

    public static final String USER_PERSON_LICENSE_TYPE_4 = "其他";

    public static final int PERSON_LICENSE_TYPE_4 = 4;

    public static final int PERSON_LICENSE_TYPE_5 = 5;

    /**
     * excel解析成功：0
     * excel解析失败：1
     */
    public static final int ANALYSIS_EXCEL_0 = 0;

    public static final int ANALYSIS_EXCEL_1 = 1;

    /**
     * 申请状态  1:待审核
     */
    public static final int CERT_APPLY_STATUS_NOT_CHECK_1 = 1;

    /**
     * 申请状态  2:审核未通过
     */
    public static final int CERT_APPLY_STATUS_CHECK_FAIL_2 = 2;

    /**
     * 申请状态  3:待签发
     */
    public static final int CERT_APPLY_STATUS_NOT_ISSUE_3 = 3;

    /**
     * 申请状态 4:签发未通过
     */
    public static final int CERT_APPLY_STATUS_ISSUE_FAIL_4 = 4;

    /**
     * 申请状态  5:已签发
     */
    public static final int CERT_APPLY_STATUS_ISSUED_5 = 5;

    /**
     * 申请状态  6:撤销失败
     */
    public static final int CERT_APPLY_STATUS_REVOKE_FAIL_6 = 6;

    /**
     * 申请状态  7:已撤销
     */
    public static final int CERT_APPLY_STATUS_REVOKED_7 = 7;

    /**
     * 申请类型  1:签发证书申请
     */
    public static final int CERT_APPLY_TYPE_ISSUE_1 = 1;

    /**
     * 申请类型  2:更新证书申请
     */
    public static final int CERT_APPLY_TYPE_UPDATE_2 = 2;

    /**
     * 申请类型  3:撤销证书申请
     */
    public static final int CERT_APPLY_TYPE_REVOKE_3 = 3;

    /**
     * 申请类型  4:恢复证书申请
     */
    public static final int CERT_APPLY_TYPE_RECOVERY_4 = 4;
    /**
     * 申请类型  5:冻结证书申请
     */
    public static final int CERT_APPLY_TYPE_FREEZE_5 = 5;
    /**
     * 申请类型  6:解冻证书申请
     */
    public static final int CERT_APPLY_TYPE_UNFREEZE_6 = 6;

    /**
     * 操作类型 1-录入
     */
    public static final int OPERATE_TYPE_ENTRY_1 = 1;

    /**
     * 操作类型 2-修改
     */
    public static final int OPERATE_TYPE_UPDATE_2 = 2;

    /**
     * 操作类型 3-审核
     */
    public static final int OPERATE_TYPE_CHECK_3 = 3;

    /**
     * 操作类型 4-撤销
     */
    public static final int OPERATE_TYPE_REVOKE_4 = 4;

    /**
     * 操作类型 5-签发
     */
    public static final int OPERATE_TYPE_ISSUE_5 = 5;

    /**
     * 证书类型  1:单证
     */
    public static final int CERT_TYPE_SINGLE_1 = 1;

    /**
     * 证书类型 2:签名证书
     */
    public static final int CERT_TYPE_SIGN_2 = 2;

    /**
     * 证书类型 3:加密证书
     */
    public static final int CERT_TYPE_ENC_3 = 3;

    /**
     * 证书状态  0:待确认
     */
    public static final int CERT_STATUS_NO_CONFIRM_0 = 0;

    /**
     * 证书状态  1:正常
     */
    public static final int CERT_STATUS_NORMAL_1 = 1;

    /**
     * 证书状态   2:已过期
     */
    public static final int CERT_STATUS_EXPIRED_2 = 2;

    /**
     * 证书状态   3:已撤销
     */
    public static final int CERT_STATUS_REVOKED_3 = 3;

    /**
     * 批量注册格式错误
     */
    public static final int FORMAT_DEVICE_USER_FAIL = 1;

    /**
     * 批量注册格式正确
     */
    public static final int FORMAT_DEVICE_USER_SUCESS = 0;

    /**
     * 操作结果 1:提交成功
     */
    public static final int CERT_APPLY_OPERATE_TYPE_SUBMIT_SUCCESS_1 = 1;

    /**
     * 操作结果 2:修改成功
     */
    public static final int CERT_APPLY_OPERATE_TYPE_UPDATE_SUCCESS_2 = 2;

    /**
     * 操作结果  3:审核拒绝
     */
    public static final int CERT_APPLY_OPERATE_TYPE_CHECK_FAIL_3 = 3;

    /**
     * 操作结果  4:审核通过
     */
    public static final int CERT_APPLY_OPERATE_TYPE_CHECK_SUCCESS_4 = 4;

    /**
     * 操作结果  5:撤销失败
     */
    public static final int CERT_APPLY_OPERATE_TYPE_REVOKE_FAIL_5 = 5;

    /**
     * 操作结果  6:撤销成功
     */
    public static final int CERT_APPLY_OPERATE_TYPE_REVOKE_SUCCESS_6 = 6;

    /**
     * 操作结果  7:签发失败
     */
    public static final int CERT_APPLY_OPERATE_TYPE_ISSUE_FAIL_7 = 7;

    /**
     * 操作结果 8:签发成功
     */
    public static final int CERT_APPLY_OPERATE_TYPE_ISSUE_SUCCESS_8 = 8;

    /**
     * 发起申请的用户类型  1 普通用户
     */
    public static final int APPLY_USER_TYPE_NORMAL_USER_1 = 1;

    /**
     * 发起申请的用户类型  2 管理员
     */
    public static final int APPLY_USER_TYPE_ADMIN_2 = 2;

    /**
     * 使用ukey申请证书  1
     */
    public static final int APPLY_CERT_TYPE_BY_UKEY_1 = 1;

    /**
     * 使用P10申请证书  2
     */
    public static final int APPLY_CERT_TYPE_BY_P10_2 = 2;

    /**
     * 是否更新证书公私钥  1 更新
     */
    public static final int UPDATE_CERT_KEY_1 = 1;

    /**
     * 是否更新证书公私钥  0 不更新
     */
    public static final int CANNOT_UPDATE_CERT_KEY_0 = 0;

    /**
     * 管理员类型  0 其他
     */
    public static final int ADMIN_TYPE_OTHER_0 = 0;
    /**
     * 管理员类型  1 业务管理员
     */
    public static final int ADMIN_TYPE_BUSINESS_1 = 1;

    /**
     * 管理员类型  2 审计员
     */
    public static final int ADMIN_TYPE_AUDIT_2 = 2;

    /**
     * 管理员类型  3 业务操作员
     */
    public static final int ADMIN_TYPE_OPERATOR_3 = 3;


    /**
     * 管理员角色  1 业务管理员
     */
    public static final int ADMIN_ROLE_BUSINESS_1 = 1;

    /**
     * 管理员角色  2 审计员
     */
    public static final int ADMIN_ROLE_AUDIT_2 = 2;

    /**
     * 管理员角色  3 业务操作员-录入员
     */
    public static final int ADMIN_ROLE_OPERATOR_INPUT_3 = 3;

    /**
     * 管理员角色  4 业务操作员-审核员
     */
    public static final int ADMIN_ROLE_OPERATOR_AUDIT_4 = 4;

    /**
     * 管理员角色  5 业务操作员-制证员
     */
    public static final int ADMIN_ROLE_OPERATOR_ISSUE_5 = 5;

    /**
     * 测试CA服务连接成功 200
     */
    public static final int TEST_CaServerConf_SUCCESS = 200;

    /**
     * 初始化状态  1   已初始化
     */
    public static final int ISINIT_STATUS_TRUE = 1;

    /**
     * 初始化状态  0   未初始化
     */
    public static final int ISINIT_STATUS_FALSE = 0;


    /**
     * 系统重启  1   已重启
     */
    public static final int ISREBOOT_TRUE = 1;

    /**
     * 系统重启  0   未重启
     */
    public static final int IISREBOOT_FALSE = 0;

    public static final String TRUSTFILE_END_WITH = "p7b";
    /**
     * 证书文件类型
     */
    public static final String CERT_FORMAT_TYPE = "application/x-pkcs12";

    public static final String CHAIN_FORMAT_TYPE = "application/x-pkcs7-certificates";
    /**
     * 密码机连接状态  0连接失败，1连接成功
     */
    public static final int HSM_CONNECT_SUCCESS = 1;

    public static final int HSM_CONNECT_FAIL = 0;

    /**
     * 获取初始化记录步骤
     * 0 代表欢迎页面 1 代表密码机配置   2代表CA服务配置  3代表RA服务配置  4代表配置业务管理员  5代表配置审计员 6 代表系统重启
     */
    public static final int WELCOME_PAGE = 0;

    public static final int HSM_SERVER_PAGE = 1;

    public static final int CA_SERVER_PAGE = 2;

    public static final int RA_SERVER_PAGE = 3;

    public static final int BUSINESS_ADMIN_PAGE = 4;

    public static final int AUDITOR_ADMIN_PAGE = 5;

    public static final int SYSTEM_RESTART = 6;

    /**
     * RSA算法
     */
    public static final Integer RSA_ALG_1 = 1;
    /**
     * SM2算法
     */
    public static final Integer SM2_ALG_2 = 2;

    /************************* 撤销原因 ***********************************/
    /**
     * 未指定撤销原因
     */
    public static final int REV_REASON_UNSPECIFIED_0 = 0;
    /**
     * 私钥泄露
     */
    public static final int REV_REASON_KEY_COMPROMISE_1 = 1;
    /**
     * CA泄露
     */
    public static final int REV_REASON_CA_COMPROMISE_2 = 2;
    /**
     * 从属关系改变
     */
    public static final int REV_REASON_AFFILIATION_CHANGED_3 = 3;
    /**
     * 证书被替代
     */
    public static final int REV_REASON_SUPERSEDED_4 = 4;
    /**
     * 停止操作
     */
    public static final int REV_REASON_CESSATION_OF_OPERATION_5 = 5;
    /**
     * 证书冻结
     */
    public static final int REV_REASON_CERTIFICATE_HOLD_6 = 6;
    /**
     * 从CRL中去除
     */
    public static final int REV_REASON_REMOVE_FROM_CRL_8 = 8;
    /**
     * 权限撤回
     */
    public static final int REV_REASON_PRIVILEGE_WITH_DRAWN_9 = 9;
    /**
     * 妥协
     */
    public static final int REV_REASON_AA_COMPROMISE_10 = 10;
}
