/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.security.filter;

import com.xdja.pki.ca.security.service.SecurityService;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuthorizationFilter
extends PermissionsAuthorizationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAuthorizationFilter.class);
    private SecurityService securityService;

    public CustomAuthorizationFilter(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        boolean isAjax = false;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Subject subject = this.getSubject(request, response);
        if (subject.getPrincipal() == null) {
            if (!this.isAjaxRequest(req)) {
                this.saveRequestAndRedirectToLogin(request, response);
            } else {
                resp.setStatus(401);
                this.render(resp, this.securityService.unAuthenticationContent());
            }
        } else {
            String unauthorizedUrl = this.getUnauthorizedUrl();
            if (StringUtils.hasText((String)unauthorizedUrl)) {
                isAjax = this.isAjaxRequest(req);
                if (!isAjax) {
                    WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
                }
            } else {
                isAjax = this.isAjaxRequest(req);
                if (!isAjax) {
                    WebUtils.toHttp((ServletResponse)response).sendError(401);
                }
            }
        }
        if (isAjax) {
            resp.setStatus(403);
            this.render(resp, this.securityService.unAuthorizationContent());
        }
        return false;
    }

    private boolean isAjaxRequest(HttpServletRequest req) {
        return req.getHeader("x-requested-with") != null && req.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest");
    }

    private void render(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            LOG.error(String.format("Shiro\u81ea\u5b9a\u4e49\u6743\u9650\u8fc7\u6ee4\u5668\u54cd\u5e94Ajax\u8bf7\u6c42\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
        }
    }
}

