/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.security.realm;

import com.xdja.pki.ca.security.bean.Operator;
import com.xdja.pki.ca.security.service.SecurityService;
import com.xdja.pki.ca.security.util.OperatorUtil;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class CustomShiroRealm
extends AuthorizingRealm {
    private SecurityService securityService;

    public CustomShiroRealm(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Operator operator = OperatorUtil.getOperator();
        if (null != operator && !operator.getPermissions().isEmpty()) {
            info.addStringPermissions(operator.getPermissions());
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        com.xdja.pki.ca.security.bean.AuthenticationInfo info = this.securityService.doAuthen(authToken);
        if (null == info) {
            throw new AuthenticationException("\u672a\u8fd4\u56de\u8ba4\u8bc1\u4fe1\u606f");
        }
        if (info.isLocked()) {
            throw new LockedAccountException("\u8d26\u53f7\u88ab\u9501\u5b9a");
        }
        return new SimpleAuthenticationInfo((Object)info.getUserName(), (Object)info.getPassword(), this.getName());
    }
}

