/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.security;

import com.xdja.pki.ca.security.bean.Function;
import com.xdja.pki.ca.security.filter.CustomAuthorizationFilter;
import com.xdja.pki.ca.security.filter.KickoutSessionControlFilter;
import com.xdja.pki.ca.security.filter.SessionTimeoutFilter;
import com.xdja.pki.ca.security.realm.CustomShiroRealm;
import com.xdja.pki.ca.security.service.SecurityService;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SecurityService securityService;

    @Bean
    public CustomShiroRealm customShiroRealm() {
        return new CustomShiroRealm(this.securityService);
    }

    @Bean
    public SessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO(this.sessionDAO());
        return sessionManager;
    }

    @Bean
    public SessionDAO sessionDAO() {
        return new MemorySessionDAO();
    }

    @Bean
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.customShiroRealm());
        securityManager.setSessionManager(this.sessionManager());
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean() {
        this.logger.info("==>\u5f00\u59cb\u52a0\u8f7dShiro\u6743\u9650");
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(this.securityManager());
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("authc", (Object)new SessionTimeoutFilter(this.securityService));
        filters.put("kickout", (Object)new KickoutSessionControlFilter(this.securityService));
        filters.put("perms", (Object)new CustomAuthorizationFilter(this.securityService));
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitions = new LinkedHashMap<String, String>();
        Collection<String> whiteLinks = this.securityService.getWhiteLink();
        if (null != whiteLinks && !whiteLinks.isEmpty()) {
            for (String link : whiteLinks) {
                filterChainDefinitions.put(link, "anon");
            }
        }
        this.processPermission(filterChainDefinitions, this.securityService.getFunctions());
        filterChainDefinitions.put("/**", "kickout, authc, perms");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("==>\u7cfb\u7edf\u5df2\u52a0\u8f7d\u6743\u9650\u5217\u8868\u4e3a\uff1a{}", filterChainDefinitions);
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitions);
        this.logger.info("==>Shiro\u6743\u9650\u52a0\u8f7d\u5b8c\u6210");
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(this.securityManager());
        return authorizationAttributeSourceAdvisor;
    }

    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Function> functions) {
        if (null != functions && !functions.isEmpty()) {
            for (Function function : functions) {
                if (StringUtils.isNotBlank((CharSequence)function.getKey()) && StringUtils.isNotBlank((CharSequence)function.getPermission())) {
                    filterChainDefinitions.put(function.getKey(), "perms[" + function.getPermission() + "]");
                }
                this.processPermission(filterChainDefinitions, function.getChildren());
            }
        }
    }
}

