/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.racert.bean;

import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.km.SignedAndEnvelopedData;
import com.xdja.pki.ca.core.pkcs7.EnvelopedDataUtil;
import com.xdja.pki.ca.core.pkcs7.SM2EnvelopedData;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Base64;

public class RACertResponseVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String signCert;
    private String encCert;
    private String encPriKey;

    public RACertResponseVO() {
    }

    public RACertResponseVO(X509Certificate signCert, X509Certificate encCert, SignedAndEnvelopedData signedAndEnvelopedData) {
        try {
            this.signCert = CertUtil.writeObject((Object)signCert);
            this.encCert = CertUtil.writeObject((Object)encCert);
            this.encPriKey = null != signedAndEnvelopedData ? Base64.toBase64String((byte[])signedAndEnvelopedData.getDEREncoded()) : "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RACertResponseVO(X509Certificate signCert, X509Certificate encCert, String signedAndEnvelopedData) {
        try {
            this.signCert = CertUtil.writeObject((Object)signCert);
            this.encCert = CertUtil.writeObject((Object)encCert);
            this.encPriKey = signedAndEnvelopedData;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RACertResponseVO(X509Certificate signCert, X509Certificate encCert, Integer keyAlg) {
        try {
            this.signCert = CertUtil.writeObject((Object)signCert);
            SM2EnvelopedData sm2EnvelopedData = EnvelopedDataUtil.getEnvelopedData((Integer)keyAlg, (X509Certificate)encCert);
            this.encCert = new String(Base64.toBase64String((byte[])sm2EnvelopedData.getEncoded("DER")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSignCert() {
        return this.signCert;
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public String getEncCert() {
        return this.encCert;
    }

    public void setEncCert(String encCert) {
        this.encCert = encCert;
    }

    public String getEncPriKey() {
        return this.encPriKey;
    }

    public void setEncPriKey(String encPriKey) {
        this.encPriKey = encPriKey;
    }
}

