/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlExtensionVO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.enums.CrlExtensionEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.springframework.util.CollectionUtils;

public class CrlExtensionUtil {
    public static List<Extension> changeExtensionFormat(List<CrlExtensionVO> crlExtensionVOList, Integer crlSn, Integer baseCrlSn, String distCrlUrl, String distDrlUrl, Boolean isCaCrl, Boolean isDelta) throws NoSuchAlgorithmException, CertificateEncodingException, IOException, CertificateParsingException {
        Extension extension = null;
        Boolean isCritical = null;
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        ArrayList<Extension> extensionList = new ArrayList<Extension>();
        if (!CollectionUtils.isEmpty(crlExtensionVOList)) {
            for (CrlExtensionVO item : crlExtensionVOList) {
                DistributionPointName distributionPointName;
                isCritical = item.getIsCritical() == CrlExtensionEnum.IS_CRITICAL.value;
                if (item.getExtenOid().equals(Extension.authorityKeyIdentifier.getId()) && null != (extension = CrlExtensionUtil.genAuthorityKeyIdentifier(isCritical, caInfoVO.getRootCert()))) {
                    extensionList.add(extension);
                }
                if (item.getExtenOid().equals(Extension.issuerAlternativeName.getId()) && null != (extension = CrlExtensionUtil.genIssueAlternativeNameExtension(isCritical, caInfoVO.getRootCert()))) {
                    extensionList.add(extension);
                }
                if (item.getExtenOid().equals(Extension.cRLNumber.getId())) {
                    CRLNumber crlNumber = new CRLNumber(BigInteger.valueOf(crlSn.intValue()));
                    extension = new Extension(Extension.cRLNumber, isCritical.booleanValue(), crlNumber.getEncoded());
                    extensionList.add(extension);
                }
                if (isDelta.booleanValue() && item.getExtenOid().equals(Extension.deltaCRLIndicator.getId())) {
                    CRLNumber baseCrlNumber = new CRLNumber(BigInteger.valueOf(baseCrlSn.intValue()));
                    new Extension(Extension.deltaCRLIndicator, isCritical.booleanValue(), baseCrlNumber.getEncoded());
                    extensionList.add(extension);
                }
                if (item.getExtenOid().equals(Extension.issuingDistributionPoint.getId()) && caInfoVO != null) {
                    distributionPointName = CrlExtensionUtil.genDistributionPointName(isDelta != false ? distDrlUrl : distCrlUrl);
                    IssuingDistributionPoint distributionPoint = new IssuingDistributionPoint(distributionPointName, isCaCrl == false, isCaCrl.booleanValue(), null, false, false);
                    extension = new Extension(Extension.issuingDistributionPoint, isCritical.booleanValue(), distributionPoint.getEncoded());
                    extensionList.add(extension);
                }
                if (isDelta.booleanValue() || !item.getExtenOid().equals(Extension.freshestCRL.getId())) continue;
                distributionPointName = CrlExtensionUtil.genDistributionPointName(distDrlUrl);
                DistributionPoint[] points = new DistributionPoint[]{new DistributionPoint(distributionPointName, null, null)};
                CRLDistPoint crlDistPoint = new CRLDistPoint(points);
                extension = new Extension(Extension.freshestCRL, isCritical.booleanValue(), crlDistPoint.getEncoded());
                extensionList.add(extension);
            }
        }
        return extensionList;
    }

    public static Extension genAuthorityKeyIdentifier(boolean isCritical, X509Certificate rootCert) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        if (null != rootCert) {
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(rootCert);
            return new Extension(Extension.authorityKeyIdentifier, isCritical, authorityKeyIdentifier.getEncoded());
        }
        return null;
    }

    public static Extension genIssueAlternativeNameExtension(boolean isCritical, X509Certificate rootCert) throws IOException, CertificateParsingException {
        if (null != rootCert.getExtensionValue(Extension.subjectAlternativeName.getId())) {
            byte[] authority = rootCert.getExtensionValue(Extension.subjectAlternativeName.getId());
            GeneralNames generalNames = GeneralNames.getInstance((Object)ASN1OctetString.getInstance((Object)authority).getOctets());
            return new Extension(Extension.issuerAlternativeName, isCritical, generalNames.getEncoded());
        }
        return null;
    }

    public static DistributionPointName genDistributionPointName(String ldapUrl) {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        GeneralName gn = new GeneralName(6, (ASN1Encodable)instance);
        GeneralNames gns = new GeneralNames(gn);
        return new DistributionPointName(0, (ASN1Encodable)gns);
    }
}

