/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.xdja.pki.ca.certmanager.service.customizeExten.bean.TemplateCustomizeExtensionVO;
import com.xdja.pki.ca.core.ca.util.gm.IdentifyCode;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.KeyUsageEnum;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.extension.util.ExtensionAttr;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.service.vo.ExtensionVO;
import com.xdja.pki.gmssl.asn1.x509.SubjectInformationAccess;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.util.encoders.Base64;

public class ExtensionUtil {
    public static List<Extension> changeExtensionFormat(List<ExtensionVO> extensionVOList, Map<String, ExtensionAttr> params, PublicKey userPublicKey, String subjectDn, LdapOcspUrlVO ldapOcspUrlVO, boolean isSign) throws Exception {
        Extension extension = null;
        ArrayList<Extension> extensionList = new ArrayList<Extension>();
        for (int i = 0; i < extensionVOList.size(); ++i) {
            String value;
            String[] values;
            ExtensionAttr extensionAttr;
            boolean isCritical;
            ExtensionVO extensionVO = extensionVOList.get(i);
            int criticalFlag = extensionVO.getIsCritical();
            boolean bl = isCritical = criticalFlag == ExtensionVO.ExtensionInputEnum.YES.value;
            if (extensionVO.getExtnId().equals(Extension.keyUsage.getId()) && null != (extension = ExtensionUtil.genKeyUsageExtension(extensionVO, isCritical, isSign))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.basicConstraints.getId()) && null != (extension = ExtensionUtil.genBasicConstraintsExtension(extensionVO, isCritical))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.cRLDistributionPoints.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getCrlLdapUrl()) && null != (extension = ExtensionUtil.genCRLDistributionPointsExtension(extensionVO, isCritical, ldapOcspUrlVO.getCrlLdapUrl()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.authorityKeyIdentifier.getId()) && null != (extension = ExtensionUtil.genAuthorityKeyIdentifier(extensionVO, isCritical, ldapOcspUrlVO.getRootCert()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.subjectKeyIdentifier.getId()) && null != (extension = ExtensionUtil.genSubjectKeyIdentifierExtension(extensionVO, isCritical, userPublicKey))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.extendedKeyUsage.getId()) && null != (extension = ExtensionUtil.genExtKeyUsage(extensionVO, isCritical))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.authorityInfoAccess.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getNetworkUrl()) && null != (extension = ExtensionUtil.genAuthorityInfoAccessExtension(extensionVO, isCritical, ldapOcspUrlVO))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.subjectInfoAccess.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getNetworkUrl()) && null != (extension = ExtensionUtil.genSubjectInfoAccessExtension(extensionVO, isCritical, ldapOcspUrlVO))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.freshestCRL.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getDrlLdapUrl()) && null != (extension = ExtensionUtil.genFreshestCRLExtension(extensionVO, isCritical, ldapOcspUrlVO.getDrlLdapUrl()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals("1.2.156.10260.4.1.3") && null != (extension = ExtensionUtil.genIcregistrationNumber(extensionVO, isCritical, (extensionAttr = params.get("1.2.156.10260.4.1.3")).getAttrValue()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals("1.2.156.10260.4.1.2") && null != (extension = ExtensionUtil.genInsuranceNumber(extensionVO, isCritical, (extensionAttr = params.get("1.2.156.10260.4.1.2")).getAttrValue()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals("1.2.156.10260.4.1.1")) {
                extensionAttr = params.get("1.2.156.10260.4.1.1");
                String residenterCardNumber = "";
                String militaryOfficerCardNumber = "";
                String passportNumber = "";
                String type = extensionAttr.getAttrType();
                String[] typeStrs = type.split("#");
                String value2 = extensionAttr.getAttrValue();
                String[] valueStrs = value2.split("=");
                for (int n = 0; n < typeStrs.length; ++n) {
                    if ("0".equals(typeStrs[n])) {
                        residenterCardNumber = valueStrs[n];
                    }
                    if ("2".equals(typeStrs[n])) {
                        militaryOfficerCardNumber = valueStrs[n];
                    }
                    if (!"1".equals(typeStrs[n])) continue;
                    passportNumber = valueStrs[n];
                }
                extension = ExtensionUtil.genIdentifyCode(extensionVO, isCritical, residenterCardNumber, militaryOfficerCardNumber, passportNumber);
                if (null != extension) {
                    extensionList.add(extension);
                }
            }
            if (extensionVO.getExtnId().equals("1.2.156.10260.4.1.4") && StringUtils.isNotBlank((CharSequence)(extensionAttr = params.get("1.2.156.10260.4.1.4")).getAttrValue())) {
                extensionList.add(ExtensionUtil.genOrganizationCode(extensionVO, isCritical, extensionAttr.getAttrValue()));
            }
            if (extensionVO.getExtnId().equals("1.2.156.10260.4.1.5") && StringUtils.isNotBlank((CharSequence)(extensionAttr = params.get("1.2.156.10260.4.1.5")).getAttrValue())) {
                extensionList.add(ExtensionUtil.genTaxationNumber(extensionVO, isCritical, extensionAttr.getAttrValue()));
            }
            if (extensionVO.getExtnId().equals(Extension.issuerAlternativeName.getId()) && null != (extension = ExtensionUtil.genIssueAlternativeNameExtension(extensionVO, isCritical, ldapOcspUrlVO.getRootCert()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.subjectAlternativeName.getId()) && null != params && null != (extensionAttr = params.get(extensionVO.getExtnId())) && null != (extension = ExtensionUtil.genSubjectAltNameExtension(extensionVO, isCritical, extensionAttr))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.policyMappings.getId()) && null != (extension = ExtensionUtil.genPolicyMappings(extensionVO, isCritical))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.certificatePolicies.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getCertPolicy()) && null != (extension = ExtensionUtil.genCertificatePoliciesExtension(extensionVO, isCritical, ldapOcspUrlVO.getCertPolicy()))) {
                extensionList.add(extension);
            }
            if (extensionVO.getExtnId().equals(Extension.nameConstraints.getId())) {
                extensionList.add(ExtensionUtil.genNameConstraints(extensionVO, isCritical));
            }
            if (extensionVO.getExtnId().equals(Extension.policyConstraints.getId())) {
                extensionList.add(ExtensionUtil.genPolicyConstraints(extensionVO, isCritical));
            }
            if (extensionVO.getExtnId().equals(Extension.extendedKeyUsage.getId())) {
                String[] values2 = extensionVO.getValue().split("#");
                extensionList.add(ExtensionUtil.genExtKeyUsage(extensionVO, isCritical));
            }
            if (extensionVO.getExtnId().equals(Extension.privateKeyUsagePeriod.getId()) && (values = (value = (extensionAttr = params.get(extensionVO.getExtnId())).getAttrValue()).split("=")).length == 2) {
                Date notBefore = DateTimeUtil.strToDate((String)values[0].trim());
                Date endAfter = DateTimeUtil.strToDate((String)values[1].trim());
                extensionList.add(ExtensionUtil.genPrivateKeyUsagePeriodExtension(extensionVO, isCritical, notBefore, endAfter));
            }
            if (extensionVO.getExtnId().equals(Extension.inhibitAnyPolicy.getId())) {
                extensionList.add(ExtensionUtil.genInhibitAnyPolicy(extensionVO, isCritical));
            }
            if (!extensionVO.getExtnId().equals(Extension.subjectDirectoryAttributes.getId()) || null == (extension = ExtensionUtil.genSubjectDirectoryAttributesExtension(extensionVO, isCritical, subjectDn))) continue;
            extensionList.add(extension);
        }
        return ExtensionUtil.removeRepatExtension(extensionList);
    }

    public static List<Extension> removeRepatExtension(List<Extension> extensionList) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        HashMap<String, Extension> repeatMap = new HashMap<String, Extension>();
        for (Extension extensionVO : extensionList) {
            if (null == extensionVO || null == extensionVO.getExtnId() || StringUtils.isBlank((CharSequence)extensionVO.getExtnId().getId())) break;
            if (null == repeatMap.get(extensionVO.getExtnId().getId())) {
                result.add(extensionVO);
            }
            repeatMap.put(extensionVO.getExtnId().getId(), extensionVO);
        }
        return result;
    }

    private static Extension genFreshestCRLExtension(ExtensionVO extensionVO, boolean isCritical, String ladpUrl) throws IOException {
        DistributionPointName dpn = ExtensionUtil.genDistributionPointName(ladpUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.freshestCRL, isCritical, crlDistPoint.getEncoded());
    }

    private static Extension genFreshestCRLExtension(boolean isCritical, String ladpUrl) throws IOException {
        DistributionPointName dpn = ExtensionUtil.genDistributionPointName(ladpUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.freshestCRL, isCritical, crlDistPoint.getEncoded());
    }

    private static Extension genIcregistrationNumber(ExtensionVO extensionVO, boolean isCritical, String icregistrationNumber) {
        return new Extension(new ASN1ObjectIdentifier("1.2.156.10260.4.1.3"), isCritical, icregistrationNumber.getBytes());
    }

    private static Extension genInsuranceNumber(ExtensionVO extensionVO, boolean isCritical, String insuranceNumber) {
        return new Extension(new ASN1ObjectIdentifier("1.2.156.10260.4.1.2"), isCritical, insuranceNumber.getBytes());
    }

    private static Extension genOrganizationCode(ExtensionVO extensionVO, boolean isCritical, String organizationCode) {
        return new Extension(new ASN1ObjectIdentifier("1.2.156.10260.4.1.4"), isCritical, organizationCode.getBytes());
    }

    private static Extension genTaxationNumber(ExtensionVO extensionVO, boolean isCritical, String taxationNumber) {
        return new Extension(new ASN1ObjectIdentifier("1.2.156.10260.4.1.5"), isCritical, taxationNumber.getBytes());
    }

    private static Extension genIdentifyCode(ExtensionVO extensionVO, boolean isCritical, String residenterCardNumber, String militaryOfficerCardNumber, String passportNumber) throws IOException {
        DERPrintableString residenterCardNumberObj = null;
        DERUTF8String militaryOfficerCardNumberObj = null;
        DERPrintableString passportNumberObj = null;
        if (StringUtils.isNotBlank((CharSequence)residenterCardNumber)) {
            residenterCardNumberObj = new DERPrintableString(residenterCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)militaryOfficerCardNumber)) {
            militaryOfficerCardNumberObj = new DERUTF8String(militaryOfficerCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)passportNumber)) {
            passportNumberObj = new DERPrintableString(passportNumber);
        }
        IdentifyCode identifyCode = new IdentifyCode(residenterCardNumberObj, militaryOfficerCardNumberObj, passportNumberObj);
        Extension extension = new Extension(new ASN1ObjectIdentifier("1.2.156.10260.4.1.1"), isCritical, identifyCode.getEncoded());
        return extension;
    }

    public static Extension genKeyUsageExtension(ExtensionVO extensionVO, boolean isCritical, boolean isSign) throws IOException {
        if (null == extensionVO || StringUtils.isBlank((CharSequence)extensionVO.getValue()) || extensionVO.getValue().equalsIgnoreCase("#")) {
            return null;
        }
        String values = extensionVO.getValue();
        String[] valueArrays = values.split("#");
        if (valueArrays.length > 0) {
            if (isSign) {
                String[] usageValues = valueArrays[0].split(",");
                if (usageValues.length > 0) {
                    int usageValue = KeyUsageEnum.getKeyUsage((int)Integer.valueOf(usageValues[0]));
                    for (int n = 1; n < usageValues.length; ++n) {
                        usageValue |= KeyUsageEnum.getKeyUsage((int)Integer.valueOf(usageValues[n]));
                    }
                    return new Extension(Extension.keyUsage, isCritical, new KeyUsage(usageValue).getEncoded());
                }
            } else if (valueArrays.length == 2) {
                String[] usageValues = valueArrays[1].split(",");
                int usageValue = KeyUsageEnum.getKeyUsage((int)Integer.valueOf(usageValues[0]));
                for (int n = 1; n < usageValues.length; ++n) {
                    usageValue |= KeyUsageEnum.getKeyUsage((int)Integer.valueOf(usageValues[n]));
                }
                return new Extension(Extension.keyUsage, isCritical, new KeyUsage(usageValue).getEncoded());
            }
        }
        System.out.println("\u8bc1\u4e66\u6a21\u677f\u4e2d\u6709oid=" + extensionVO.getExtnId() + ",name=" + extensionVO.getName() + "\u7684\u6269\u5c55\u9879\u4fe1\u606f,\u4f46\u662f\u6a21\u677f\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u503c\uff0c\u6ca1\u6709\u5c01\u88c5\u5230\u8bc1\u4e66\u4e2d\u3002");
        return null;
    }

    public static Extension genBasicConstraintsExtension(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        String[] valueArray;
        String values = extensionVO.getValue();
        if (StringUtils.isNotBlank((CharSequence)values) && (valueArray = values.split("#")).length > 0) {
            boolean isCA = Integer.valueOf(valueArray[0]) == ExtensionVO.ExtensionInputEnum.YES.value;
            BasicConstraints basicConstraints = null;
            if (isCA) {
                if (valueArray.length == 2) {
                    int length = Integer.valueOf(valueArray[1]);
                    basicConstraints = new BasicConstraints(length);
                } else {
                    basicConstraints = new BasicConstraints(true);
                }
            } else {
                basicConstraints = new BasicConstraints(false);
            }
            return new Extension(Extension.basicConstraints, isCritical, basicConstraints.getEncoded());
        }
        System.out.println("\u8bc1\u4e66\u6a21\u677f\u4e2d\u6709oid=" + extensionVO.getExtnId() + ",name=" + extensionVO.getName() + "\u7684\u6269\u5c55\u9879\u4fe1\u606f,\u4f46\u662f\u6a21\u677f\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u503c\uff0c\u6ca1\u6709\u5c01\u88c5\u5230\u8bc1\u4e66\u4e2d\u3002");
        return null;
    }

    public static Extension genExtKeyUsage(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        String values = extensionVO.getValue();
        if (StringUtils.isNotBlank((CharSequence)values) && !values.equalsIgnoreCase("#")) {
            String[] strs = values.split("#");
            KeyPurposeId[] kk = new KeyPurposeId[strs.length];
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < strs.length; ++i) {
                kk[i] = KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(strs[i]));
            }
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(kk);
            return new Extension(Extension.extendedKeyUsage, isCritical, extendedKeyUsage.getEncoded());
        }
        System.out.println("\u8bc1\u4e66\u6a21\u677f\u4e2d\u6709oid=" + extensionVO.getExtnId() + ",name=" + extensionVO.getName() + "\u7684\u6269\u5c55\u9879\u4fe1\u606f,\u4f46\u662f\u6a21\u677f\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u503c\uff0c\u6ca1\u6709\u5c01\u88c5\u5230\u8bc1\u4e66\u4e2d\u3002");
        return null;
    }

    public static Extension genAuthorityKeyIdentifier(ExtensionVO extensionVO, boolean isCritical, X509Certificate rootCert) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        if (null != rootCert) {
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(rootCert);
            return new Extension(Extension.authorityKeyIdentifier, isCritical, authorityKeyIdentifier.getEncoded());
        }
        System.out.println("\u8bc1\u4e66\u6a21\u677f\u4e2d\u6709oid=" + extensionVO.getExtnId() + ",name=" + extensionVO.getName() + "\u7684\u6269\u5c55\u9879\u4fe1\u606f,\u4f46\u662f\u6a21\u677f\u4e2d\u7f3a\u5c11\u5fc5\u8981\u7684\u503c\uff0c\u6ca1\u6709\u5c01\u88c5\u5230\u8bc1\u4e66\u4e2d\u3002");
        return null;
    }

    public static Extension genAuthorityInfoAccessExtension(ExtensionVO extensionVO, boolean isCritical, LdapOcspUrlVO ldapOcspUrlVO) throws IOException {
        DEROctetString instance;
        AccessDescription accessDescriptionOcsp = null;
        AccessDescription accessDescriptionCa = null;
        if (StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getNetworkUrl())) {
            instance = new DEROctetString(ldapOcspUrlVO.getNetworkUrl().getBytes());
            accessDescriptionOcsp = new AccessDescription(AccessDescription.id_ad_ocsp, new GeneralName(6, (ASN1Encodable)instance));
        }
        if (StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getRootCertLdapUrl())) {
            instance = new DEROctetString(ldapOcspUrlVO.getRootCertLdapUrl().getBytes());
            accessDescriptionCa = new AccessDescription(AccessDescription.id_ad_caIssuers, new GeneralName(6, (ASN1Encodable)instance));
        }
        AccessDescription[] accessDescriptions = null;
        if (null != accessDescriptionOcsp) {
            accessDescriptions = new AccessDescription[]{accessDescriptionOcsp};
        }
        if (null != accessDescriptionCa) {
            accessDescriptions = new AccessDescription[]{accessDescriptionCa};
        }
        if (null != accessDescriptionOcsp && null != accessDescriptionCa) {
            accessDescriptions = new AccessDescription[]{accessDescriptionOcsp, accessDescriptionCa};
        }
        if (null != accessDescriptions) {
            AuthorityInformationAccess issueInfo = new AuthorityInformationAccess(accessDescriptions);
            return new Extension(Extension.authorityInfoAccess, isCritical, issueInfo.getEncoded());
        }
        return null;
    }

    public static Extension genSubjectInfoAccessExtension(ExtensionVO extensionVO, boolean isCritical, LdapOcspUrlVO ldapOcspUrlVO) throws IOException {
        DEROctetString instance;
        AccessDescription accessDescriptionOcsp = null;
        AccessDescription accessDescriptionCa = null;
        if (StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getNetworkUrl())) {
            instance = new DEROctetString(ldapOcspUrlVO.getNetworkUrl().getBytes());
            accessDescriptionOcsp = new AccessDescription(AccessDescription.id_ad_ocsp, new GeneralName(6, (ASN1Encodable)instance));
        }
        if (StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getCertLdapUrl())) {
            instance = new DEROctetString(ldapOcspUrlVO.getCertLdapUrl().getBytes());
            accessDescriptionCa = new AccessDescription(SubjectInformationAccess.id_ad_caRepository, new GeneralName(6, (ASN1Encodable)instance));
        }
        AccessDescription[] accessDescriptions = null;
        if (null != accessDescriptionOcsp) {
            accessDescriptions = new AccessDescription[]{accessDescriptionOcsp};
        }
        if (null != accessDescriptionCa) {
            accessDescriptions = new AccessDescription[]{accessDescriptionCa};
        }
        if (null != accessDescriptionOcsp && null != accessDescriptionCa) {
            accessDescriptions = new AccessDescription[]{accessDescriptionOcsp, accessDescriptionCa};
        }
        if (null != accessDescriptions) {
            SubjectInformationAccess issueInfo = new SubjectInformationAccess(accessDescriptions);
            return new Extension(Extension.subjectInfoAccess, isCritical, issueInfo.getEncoded());
        }
        return null;
    }

    public static Extension genSubjectKeyIdentifierExtension(ExtensionVO extensionVO, boolean isCritical, PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(publicKey);
        return new Extension(Extension.subjectKeyIdentifier, isCritical, subjectKeyIdentifier.getEncoded());
    }

    public static Extension genSubjectKeyIdentifierExtension(boolean isCritical, PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(publicKey);
        return new Extension(Extension.subjectKeyIdentifier, isCritical, subjectKeyIdentifier.getEncoded());
    }

    public static Extension genPrivateKeyUsagePeriodExtension(ExtensionVO extensionVO, boolean isCritical, Date notBefore, Date notAfter) throws NoSuchAlgorithmException, IOException {
        DERGeneralizedTime keyNotBefore = new DERGeneralizedTime(notBefore);
        DERGeneralizedTime keyNotAfter = new DERGeneralizedTime(notAfter);
        DERTaggedObject atokeyNotBefore = new DERTaggedObject(false, 0, (ASN1Encodable)keyNotBefore);
        DERTaggedObject atokeyNotAfter = new DERTaggedObject(false, 1, (ASN1Encodable)keyNotAfter);
        ASN1EncodableVector periodVector = new ASN1EncodableVector();
        periodVector.add((ASN1Encodable)atokeyNotBefore);
        periodVector.add((ASN1Encodable)atokeyNotAfter);
        PrivateKeyUsagePeriod privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance((Object)new DERSequence(periodVector));
        return new Extension(Extension.privateKeyUsagePeriod, isCritical, privateKeyUsagePeriod.getEncoded());
    }

    public static Extension genSubjectAltNameExtension(ExtensionVO extensionVO, boolean isCritical, ExtensionAttr extensionAttr) throws IOException, NamingException {
        if (null != extensionAttr) {
            String value = extensionAttr.getAttrValue();
            if (StringUtils.isBlank((CharSequence)value) || value.equalsIgnoreCase("#")) {
                return null;
            }
            String type = extensionAttr.getAttrType();
            if (StringUtils.isBlank((CharSequence)type) || type.equalsIgnoreCase("#")) {
                return null;
            }
            System.out.println("value:" + value + ",type:" + type);
            String[] types = type.split("#");
            String[] values = value.split("#");
            GeneralName[] generalNameArray = new GeneralName[types.length];
            for (int n = 0; n < types.length; ++n) {
                GeneralName generalName = null;
                if (Integer.valueOf(types[n]) == 4) {
                    X500Name x500Name = DnUtil.getRFC4519X500Name((String)values[n]);
                    generalName = new GeneralName(x500Name);
                } else {
                    generalName = new GeneralName(Integer.valueOf(types[n]).intValue(), values[n]);
                }
                generalNameArray[n] = generalName;
            }
            GeneralNames generalNames = new GeneralNames(generalNameArray);
            return new Extension(Extension.subjectAlternativeName, isCritical, generalNames.getEncoded());
        }
        return null;
    }

    public static Extension genIssueAlternativeNameExtension(ExtensionVO extensionVO, boolean isCritical, X509Certificate rootCert) throws IOException, CertificateParsingException {
        if (null != rootCert.getExtensionValue(Extension.subjectAlternativeName.getId())) {
            byte[] authority = rootCert.getExtensionValue(Extension.subjectAlternativeName.getId());
            GeneralNames generalNames = GeneralNames.getInstance((Object)ASN1OctetString.getInstance((Object)authority).getOctets());
            return new Extension(Extension.issuerAlternativeName, isCritical, generalNames.getEncoded());
        }
        return null;
    }

    public static Extension genSubjectDirectoryAttributesExtension(ExtensionVO extensionVO, boolean isCritical, String dn) throws IOException, NamingException {
        X500Name x500Name = DnUtil.getRFC4519X500Name((String)dn);
        RDN[] rdns = x500Name.getRDNs(new ASN1ObjectIdentifier("2.5.4.3"));
        String cn = null;
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            AttributeTypeAndValue value = rdn.getFirst();
            cn = value.getValue().toString();
        }
        return GMSSLExtensionUtils.genSubjectDirectoryAttributesExtension(cn, (boolean)isCritical);
    }

    public static Extension genSubjectDirectoryAttributesExtension(boolean isCritical, String dn) throws IOException, NamingException {
        X500Name x500Name = DnUtil.getRFC4519X500Name((String)dn);
        RDN[] rdns = x500Name.getRDNs(new ASN1ObjectIdentifier("2.5.4.3"));
        String cn = null;
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            AttributeTypeAndValue value = rdn.getFirst();
            cn = value.getValue().toString();
        }
        return GMSSLExtensionUtils.genSubjectDirectoryAttributesExtension(cn, (boolean)isCritical);
    }

    public static Extension genCRLDistributionPointsExtension(ExtensionVO extensionVO, boolean isCritical, String crlLdapUrl) throws IOException {
        DistributionPointName dpn = ExtensionUtil.genDistributionPointName(crlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.cRLDistributionPoints, isCritical, crlDistPoint.getEncoded());
    }

    public static Extension genCRLDistributionPointsExtension(boolean isCritical, String crlLdapUrl) throws IOException {
        DistributionPointName dpn = ExtensionUtil.genDistributionPointName(crlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.cRLDistributionPoints, isCritical, crlDistPoint.getEncoded());
    }

    public static DistributionPointName genDistributionPointName(String ldapUrl) {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        GeneralName gn = new GeneralName(6, (ASN1Encodable)instance);
        GeneralNames gns = new GeneralNames(gn);
        return new DistributionPointName(0, (ASN1Encodable)gns);
    }

    public static Extension genDRLExtension(int drlNumber) throws IOException {
        CRLNumber basecrlnum = new CRLNumber(BigInteger.valueOf(drlNumber));
        return new Extension(Extension.deltaCRLIndicator, true, basecrlnum.getEncoded());
    }

    public static Extension genPolicyMappings(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        String[] values = extensionVO.getValue().split("\\|\\|");
        CertPolicyId[] issuerDomainPolicy = new CertPolicyId[values.length];
        CertPolicyId[] subjectDomainPolicy = new CertPolicyId[values.length];
        for (int i = 0; i < values.length; ++i) {
            String[] oids = values[i].split("#");
            if (oids.length != 2) continue;
            issuerDomainPolicy[i] = CertPolicyId.getInstance((Object)new ASN1ObjectIdentifier(oids[0]));
            subjectDomainPolicy[i] = CertPolicyId.getInstance((Object)new ASN1ObjectIdentifier(oids[1]));
        }
        PolicyMappings policyMappings = new PolicyMappings(issuerDomainPolicy, subjectDomainPolicy);
        return new Extension(Extension.policyMappings, isCritical, policyMappings.getEncoded());
    }

    public static Extension genCertificatePoliciesExtension(ExtensionVO extensionVO, boolean isCritical, String uri) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)extensionVO.getValue())) {
            String[] values = extensionVO.getValue().split("#");
            PolicyInformation[] policyInformations = new PolicyInformation[values.length];
            for (int i = 0; i < values.length; ++i) {
                PolicyInformation policyInformation;
                PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(uri);
                DERSequence asn1Sequence = new DERSequence((ASN1Encodable)policyQualifierInfo);
                policyInformations[i] = policyInformation = new PolicyInformation(new ASN1ObjectIdentifier(values[i]), (ASN1Sequence)asn1Sequence);
            }
            CertificatePolicies gertificatePolicies = new CertificatePolicies(policyInformations);
            return new Extension(Extension.certificatePolicies, isCritical, gertificatePolicies.getEncoded());
        }
        return null;
    }

    public static Extension genNameConstraints(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        String[] values = extensionVO.getValue().split("\\|\\|");
        GeneralSubtree[] excluded = null;
        GeneralSubtree[] permitted = null;
        if (values.length == 2) {
            String noPermit;
            String permit = values[0];
            if (StringUtils.isNotBlank((CharSequence)permit)) {
                String[] permitteds = values[0].split("\\|");
                permitted = new GeneralSubtree[permitteds.length];
                for (int i = 0; i < permitteds.length; ++i) {
                    String[] key = permitteds[i].split("#");
                    if (0 == Integer.valueOf(key[0]) || 5 == Integer.valueOf(key[0])) continue;
                    String dnsName = new String(Base64.decode((String)key[1]));
                    GeneralName generalName = new GeneralName(Integer.valueOf(key[0]).intValue(), dnsName.trim());
                    permitted[i] = new GeneralSubtree(generalName, new BigInteger(String.valueOf(0)), null);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(noPermit = values[1]))) {
                String[] noPermitteds = values[1].split("\\|");
                excluded = new GeneralSubtree[noPermitteds.length];
                for (int i = 0; i < noPermitteds.length; ++i) {
                    String[] key = noPermitteds[i].split("#");
                    if (0 == Integer.valueOf(key[0]) || 5 == Integer.valueOf(key[0])) continue;
                    String dnsName = new String(Base64.decode((String)key[1]));
                    GeneralName generalName = new GeneralName(Integer.valueOf(key[0]).intValue(), dnsName);
                    excluded[i] = new GeneralSubtree(generalName, new BigInteger(String.valueOf(0)), null);
                }
            }
            NameConstraints nameConstraints = new NameConstraints(permitted, excluded);
            return new Extension(Extension.nameConstraints, isCritical, nameConstraints.getEncoded());
        }
        return null;
    }

    public static Extension genPolicyConstraints(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        String[] values = extensionVO.getValue().split("#");
        BigInteger requireExplicitPolicy = null;
        BigInteger inhibitPolicyMapping = null;
        if (values.length >= 1) {
            requireExplicitPolicy = new BigInteger(values[0]);
        }
        if (values.length >= 2) {
            inhibitPolicyMapping = new BigInteger(values[1]);
        }
        PolicyConstraints policyConstraints = new PolicyConstraints(requireExplicitPolicy, inhibitPolicyMapping);
        return new Extension(Extension.policyConstraints, isCritical, policyConstraints.getEncoded());
    }

    public static Extension genInhibitAnyPolicy(ExtensionVO extensionVO, boolean isCritical) throws IOException {
        ASN1Integer integer = new ASN1Integer(Long.valueOf(extensionVO.getValue()).longValue());
        return new Extension(Extension.inhibitAnyPolicy, isCritical, integer.getEncoded());
    }

    public static Extension genCrlNumber(boolean isCritical, String crlNumber) {
        return new Extension(Extension.cRLNumber, isCritical, crlNumber.getBytes());
    }

    public static void main(String[] args) throws IOException {
        ExtensionVO extensionVO = new ExtensionVO();
        extensionVO.setValue("2.16.156.112.115");
        Extension extension = ExtensionUtil.genCertificatePoliciesExtension(extensionVO, true, "http://1.1.1.1/crl");
        System.out.println(extension.getExtnValue());
        System.out.println(extension);
    }

    public static List<Extension> updateExtension(List<Extension> extensions, LdapOcspUrlVO ldapOcspUrlVO, String subjectDn, PublicKey userPublickey) throws Exception {
        Iterator<Extension> it = extensions.iterator();
        Extension crlExtension = null;
        Extension drlExtension = null;
        Extension subjectKeyExtension = null;
        Extension subjectDirectory = null;
        Extension authorityKeyIdentifier = null;
        Extension subjectInfoAccessKeyIdentifer = null;
        Extension authorityInfoAccessKeyIdentifer = null;
        while (it.hasNext()) {
            Extension extension = it.next();
            if (extension.getExtnId().getId().equals(Extension.cRLDistributionPoints.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getCrlLdapUrl())) {
                crlExtension = ExtensionUtil.genCRLDistributionPointsExtension(extension.isCritical(), ldapOcspUrlVO.getCrlLdapUrl());
                it.remove();
            }
            if (extension.getExtnId().getId().equals(Extension.freshestCRL.getId()) && StringUtils.isNotBlank((CharSequence)ldapOcspUrlVO.getDrlLdapUrl())) {
                drlExtension = ExtensionUtil.genFreshestCRLExtension(extension.isCritical(), ldapOcspUrlVO.getDrlLdapUrl());
                it.remove();
            }
            if (extension.getExtnId().getId().equals(Extension.subjectKeyIdentifier.getId())) {
                subjectKeyExtension = ExtensionUtil.genSubjectKeyIdentifierExtension(extension.isCritical(), userPublickey);
                it.remove();
            }
            if (extension.getExtnId().getId().equals(Extension.subjectDirectoryAttributes.getId())) {
                subjectDirectory = ExtensionUtil.genSubjectDirectoryAttributesExtension(extension.isCritical(), subjectDn);
                it.remove();
            }
            if (extension.getExtnId().getId().equals(Extension.authorityKeyIdentifier.getId())) {
                authorityKeyIdentifier = ExtensionUtil.genAuthorityKeyIdentifier(null, extension.isCritical(), ldapOcspUrlVO.getRootCert());
                it.remove();
            }
            if (extension.getExtnId().getId().equals(Extension.subjectInfoAccess.getId())) {
                subjectInfoAccessKeyIdentifer = ExtensionUtil.genSubjectInfoAccessExtension(null, extension.isCritical(), ldapOcspUrlVO);
                it.remove();
            }
            if (!extension.getExtnId().getId().equals(Extension.authorityInfoAccess.getId())) continue;
            authorityInfoAccessKeyIdentifer = ExtensionUtil.genAuthorityInfoAccessExtension(null, extension.isCritical(), ldapOcspUrlVO);
            it.remove();
        }
        if (null != crlExtension) {
            extensions.add(crlExtension);
        }
        if (null != drlExtension) {
            extensions.add(drlExtension);
        }
        if (null != subjectKeyExtension) {
            extensions.add(subjectKeyExtension);
        }
        if (null != subjectDirectory) {
            extensions.add(subjectDirectory);
        }
        if (null != authorityKeyIdentifier) {
            extensions.add(authorityKeyIdentifier);
        }
        if (null != subjectInfoAccessKeyIdentifer) {
            extensions.add(subjectInfoAccessKeyIdentifer);
        }
        if (null != authorityInfoAccessKeyIdentifer) {
            extensions.add(authorityInfoAccessKeyIdentifer);
        }
        return extensions;
    }

    public static List<Extension> buildTemplateCustomizeExtensions(List<TemplateCustomizeExtensionVO> templateCustomizeExtensionVOList, Map<String, ExtensionAttr> extensionAttrs) {
        ArrayList<Extension> extensionList = new ArrayList<Extension>();
        for (TemplateCustomizeExtensionVO templateCustomizeExtensionVO : templateCustomizeExtensionVOList) {
            String customizeExtenOid = templateCustomizeExtensionVO.getCustomizeExtenOid();
            ExtensionAttr extensionAttr = extensionAttrs.get(customizeExtenOid);
            if (extensionAttr == null) continue;
            Integer encodeType = Integer.valueOf(extensionAttr.getAttrType());
            String value = extensionAttr.getAttrValue();
            byte[] extensionValueByEncodeType = new byte[]{};
            try {
                extensionValueByEncodeType = ExtensionUtil.getExtensionValueByEncodeType(encodeType, value);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Extension extension = new Extension(new ASN1ObjectIdentifier(customizeExtenOid).intern(), templateCustomizeExtensionVO.getIsCritical() != 0, extensionValueByEncodeType);
            extensionList.add(extension);
        }
        return extensionList;
    }

    public static byte[] getExtensionValueByEncodeType(int encodeType, String extensionValue) throws IOException {
        byte[] encodeValue = null;
        switch (encodeType) {
            case 1: {
                encodeValue = new DERPrintableString(extensionValue, true).getOctets();
                break;
            }
            case 2: {
                encodeValue = new DERIA5String(extensionValue, true).getOctets();
                break;
            }
            case 3: {
                if (!"true".equalsIgnoreCase(extensionValue) && !"false".equalsIgnoreCase(extensionValue)) break;
                encodeValue = new DERBoolean("true".equalsIgnoreCase(extensionValue)).getEncoded();
                break;
            }
            case 4: {
                encodeValue = new DERInteger(extensionValue.getBytes()).getEncoded();
                break;
            }
            case 5: 
            case 6: {
                encodeValue = new DERUTF8String(extensionValue).getEncoded();
                break;
            }
        }
        return encodeValue;
    }
}

