/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.TemplateCustomizeExtensionVO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.util.json.JSONException;
import com.xdja.pki.ca.core.util.json.JsonMapper;
import com.xdja.pki.ca.extension.util.ExtensionAttr;
import com.xdja.pki.ca.securitymanager.service.vo.ExtensionVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TemplateParamsUtil {
    public static Result validity(TemplateInfoVO templateInfoVO, String tempParas) {
        String oid;
        int i;
        ExtensionAttr extensionAttr;
        HashMap<String, ExtensionAttr> result = new HashMap<String, ExtensionAttr>();
        List<TemplateCustomizeExtensionVO> customizeExtens = templateInfoVO.getCustomizeExtens();
        for (TemplateCustomizeExtensionVO customizeExten : customizeExtens) {
            if (customizeExten.getIsClient() != 0) continue;
            extensionAttr = new ExtensionAttr();
            extensionAttr.setAttrOid(customizeExten.getCustomizeExtenOid());
            extensionAttr.setAttrName(customizeExten.getCustomizeExtenName());
            extensionAttr.setAttrType(customizeExten.getEncodeType().toString());
            extensionAttr.setAttrCustomize("1");
            extensionAttr.setAttrRequired(customizeExten.getIsRequest().toString());
            extensionAttr.setAttrValue(customizeExten.getValue());
            result.put(customizeExten.getCustomizeExtenOid(), extensionAttr);
        }
        if (StringUtils.isNotBlank((CharSequence)tempParas)) {
            List<ExtensionAttr> extensionAttrList = TemplateParamsUtil.formatExtensionJon(tempParas);
            for (int i2 = 0; i2 < extensionAttrList.size(); ++i2) {
                extensionAttr = extensionAttrList.get(i2);
                if ("1".equalsIgnoreCase(extensionAttr.getAttrCustomize())) {
                    try {
                        ExtensionUtil.getExtensionValueByEncodeType(Integer.valueOf(extensionAttr.getAttrType()), extensionAttr.getAttrValue());
                    }
                    catch (IOException e) {
                        return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_VALUE_ENCODE_EXCEPTION);
                    }
                }
                result.put(extensionAttr.getAttrOid(), extensionAttr);
            }
        }
        List<ExtensionVO> extensionVOList = templateInfoVO.getExtensions();
        for (i = 0; i < extensionVOList.size(); ++i) {
            ExtensionVO extensionVO = extensionVOList.get(i);
            oid = extensionVO.getExtnId();
            if (1 != extensionVO.getIsInput() || null != result.get(oid)) continue;
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        for (i = 0; i < customizeExtens.size(); ++i) {
            TemplateCustomizeExtensionVO templateCustomizeExtensionVO = customizeExtens.get(i);
            oid = templateCustomizeExtensionVO.getCustomizeExtenOid();
            if (1 != templateCustomizeExtensionVO.getIsRequest() || null != result.get(oid)) continue;
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return Result.success(result);
    }

    public static List<ExtensionAttr> formatExtensionJon(String json) {
        JsonMapper jsonMapper = JsonMapper.alwaysMapper();
        try {
            List atrList = (List)JsonMapper.alwaysMapper().fromJson(json, (TypeReference)new TypeReference<List<ExtensionAttr>>(){});
            return atrList;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

