/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.archivecert;

import com.xdja.pki.ca.certmanager.dao.ArchiveCertDao;
import com.xdja.pki.ca.certmanager.dao.models.ArchiveCertDO;
import com.xdja.pki.ca.certmanager.service.archivecert.ArchiveCertService;
import com.xdja.pki.ca.certmanager.service.archivecert.bean.ArchiveCertQueryDTO;
import com.xdja.pki.ca.certmanager.service.convert.CertConverter;
import com.xdja.pki.ca.certmanager.service.outdatecert.OutDateCertService;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveCertServiceImpl
implements ArchiveCertService {
    private static final Logger log = LoggerFactory.getLogger(ArchiveCertServiceImpl.class);
    @Autowired
    private OutDateCertService outDateCertService;
    @Autowired
    private ArchiveCertDao archiveCertDao;

    public Result archiveOutDateCert(String archiveTime, long current) {
        Result result = this.outDateCertService.queryOutDateCertToArchive(archiveTime);
        if (null == result.getInfo() || CollectionUtils.isEmpty((Collection)((List)result.getInfo()))) {
            log.info("[ArchiveCertServiceImpl#archiveOutDateCert]archiveTime {} need archive 's outDateCert is null.", (Object)archiveTime);
            return Result.success();
        }
        List<ArchiveCertDO> archiveCertList = CertConverter.outToArchiveCertList((List)result.getInfo(), current);
        return this.doArchiveCertProcess(archiveTime, archiveCertList);
    }

    public Result doArchiveCertProcess(String archiveTime, List<ArchiveCertDO> archiveCertList) {
        this.archiveCertDao.saveBatch(archiveCertList);
        return this.outDateCertService.deleteOutDateCertBetweenDate(archiveTime);
    }

    public Result recoveryArchivedCert(String sn, Integer keyAlg, long current) {
        return this.outDateCertService.doRecoveryArchivedCertToOutDateCert(sn, keyAlg, current);
    }

    public Result queryArchiveCertList(ArchiveCertQueryDTO query) {
        PageInfo pageInfo;
        try {
            pageInfo = this.archiveCertDao.queryArchiveCertList(CertConverter.queryToArchiveDO(query), query.getPageNo(), query.getPageSize());
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f52\u6863\u8bc1\u4e66\u5217\u8868\u5f02\u5e38");
            throw new ServiceException("\u5206\u9875\u67e5\u8be2\u5f52\u6863\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getDatas())) {
            List archiveCertList = (List)pageInfo.getDatas();
            pageInfo.setDatas(CertConverter.dataListToArchiveVOList(archiveCertList));
        }
        return Result.success((Object)pageInfo);
    }
}

