/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.camanagecert;

import com.xdja.pki.ca.certmanager.dao.CaAdminCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.CaManageCertListVO;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.CaManageCertQueryVO;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.IssueCaCertReqVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.IssueRaCertVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.CaSoftServerPwdBean;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.TomcatUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.AdminRoleDao;
import com.xdja.pki.ca.securitymanager.dao.CaServerCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.dao.ManagerCertIdDao;
import com.xdja.pki.ca.securitymanager.dao.RoleDao;
import com.xdja.pki.ca.securitymanager.dao.model.AdminRoleDO;
import com.xdja.pki.ca.securitymanager.dao.model.CaServerCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.RoleDO;
import com.xdja.pki.ca.securitymanager.service.CommonService;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.util.CaServerPwdUtil;
import com.xdja.pki.ca.securitymanager.service.util.TomcatHttpsUtil;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerCertVO;
import com.xdja.pki.ca.securitymanager.service.vo.ServerCertIsCurrentEnum;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class CaManageCertServiceImpl
implements ICaManageCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CaAdminCertDao caAdminCertDao;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;
    @Autowired
    private InitService initService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private ManagerCertDao managereCertDao;
    @Autowired
    private ManagerCertDataDao managerCertDataDao;
    @Autowired
    private AdminRoleDao adminRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RaManagerCertService raManagerCertService;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private CaServerCertDao caServerCertDao;
    @Autowired
    private DicDao dicDao;
    @Autowired
    private RevokeManagerCertDao revokeManagerCertDao;
    @Autowired
    private OutDateManagerCertDao outDateManagerCertDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private Environment environment;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ManagerCertIdDao managerCertIdDao;
    @Autowired
    private ConfigFileService configFileService;
    @Value(value="${config.path}")
    private String configPath;

    public Result getCaManageCertList(CaManageCertQueryVO caCertQueryCnd) {
        Pager pager = new Pager(caCertQueryCnd.getPageNo(), caCertQueryCnd.getPageSize());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("certDn", caCertQueryCnd.getCertDn());
        param.put("sn", caCertQueryCnd.getSn());
        param.put("caManageRoleType", caCertQueryCnd.getRoleType());
        param.put("status", caCertQueryCnd.getStatus());
        PageInfo pageInfo = null;
        ArrayList<CaManageCertListVO> caManageCertList = new ArrayList<CaManageCertListVO>();
        try {
            pageInfo = this.caAdminCertDao.getCaAdminCertLists(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                for (Object item : datas) {
                    Map dataMap = (Map)item;
                    CaManageCertListVO caManageCertVO = new CaManageCertListVO();
                    Integer status = Integer.valueOf(String.valueOf(dataMap.get("status")));
                    caManageCertVO.setCertDn((String)dataMap.get("subject"));
                    caManageCertVO.setSignSn((String)dataMap.get("sn"));
                    caManageCertVO.setEncSn((String)dataMap.get("pair_cert_sn"));
                    caManageCertVO.setStatus(status);
                    caManageCertVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(status));
                    caManageCertVO.setSignAlg((String)dataMap.get("sign_alg"));
                    caManageCertVO.setSignAlgStr(this.dicDataConverUtil.coneverSingAlgToStr((String)dataMap.get("sign_alg")));
                    caManageCertVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("before_time"))));
                    caManageCertVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("after_time"))));
                    caManageCertList.add(caManageCertVO);
                }
                pageInfo.setDatas(caManageCertList);
            }
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5217\u8868\u5f02\u5e38");
            throw new ServiceException("\u67e5\u8be2CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    public Result doIssueCaManagerCert(IssueCaCertReqVO issueCaCertReqVO) {
        CaManagerCertVO caManagerCertVO = new CaManagerCertVO();
        BeanUtils.copyProperties((Object)issueCaCertReqVO, (Object)caManagerCertVO);
        caManagerCertVO.setDn(issueCaCertReqVO.getCertDn());
        caManagerCertVO.setType(issueCaCertReqVO.getRoleType());
        Result issueCaManageCertResult = null;
        try {
            issueCaManageCertResult = this.initService.doIssueCaAdminCert(caManagerCertVO, true);
        }
        catch (ServiceException e) {
            throw new ServiceException("\u7b7e\u53d1CA\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        return issueCaManageCertResult;
    }

    public Result doUpdateCaManagerCert(IssueCaCertReqVO issueCaCertReqVO) {
        try {
            List oldCerts;
            Long roleId = null;
            try {
                RoleDO roleDO = this.roleDao.getRoleByType(issueCaCertReqVO.getRoleType().intValue());
                roleId = roleDO.getId();
            }
            catch (Exception e) {
                this.logger.error("\u6ca1\u6709\u627e\u5230\u8be5\u7ba1\u7406\u5458\u89d2\u8272\u5bf9\u5e94\u6743\u9650id\uff0ctype=" + issueCaCertReqVO.getRoleType());
                throw new ServiceException("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            }
            TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.MANAGER.value);
            if (null == templateInfoVO) {
                this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
                this.logger.info("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_NOT_NORMAL);
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
                this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueCaCertReqVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
                this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueCaCertReqVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
            }
            if (issueCaCertReqVO.isDnUpdate()) {
                if (!issueCaCertReqVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)issueCaCertReqVO);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                try {
                    X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueCaCertReqVO.getCertDn());
                }
                catch (Exception e) {
                    this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueCaCertReqVO.getCertDn());
                    return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
                }
            }
            PublicKey newEncPublicKey = null;
            PublicKey newSignPublicKey = null;
            if (issueCaCertReqVO.isKeyUpdate()) {
                newSignPublicKey = CertUtil.getPublicKeyFromP10((String)issueCaCertReqVO.getP10());
                if (null == newSignPublicKey) {
                    this.logger.debug("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)issueCaCertReqVO);
                    return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
                }
                try {
                    newEncPublicKey = CertUtil.convertPublicKey((PublicKey)newSignPublicKey, (String)issueCaCertReqVO.getSubjectPublicKeyInfo());
                }
                catch (Exception e) {
                    this.logger.debug(String.format("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:%s", issueCaCertReqVO.getSubjectPublicKeyInfo()), (Throwable)e);
                    return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
                }
            }
            if (null == (oldCerts = this.managereCertDao.getCertsBySignSn(issueCaCertReqVO.getSn(), Constants.BASE_ALG_TYPE)) || oldCerts.size() == 0) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u7ba1\u7406\u5458\u8bc1\u4e66\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)issueCaCertReqVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            ManageCertDO certDO = (ManageCertDO)oldCerts.get(0);
            if (certDO.getAfterTime().before(new Date())) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671fsignSN=[{}]", (Object)issueCaCertReqVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            if (certDO.getStatus() == 2) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)issueCaCertReqVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
            }
            ManageCertDataDO certDataDO1 = this.managereCertDao.queryCertDataNoById(certDO.getId());
            ManageCertDataDO certDataDO2 = this.managereCertDao.queryCertDataNoById(certDO.getPairCertId());
            Long oldSignCertId = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            Long oldEncCertId = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            X509Certificate oldSignCert = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            X509Certificate oldEncCert = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            PublicKey signPublicKey = issueCaCertReqVO.isKeyUpdate() ? newSignPublicKey : oldSignCert.getPublicKey();
            PublicKey encPublicKey = issueCaCertReqVO.isKeyUpdate() ? newEncPublicKey : oldEncCert.getPublicKey();
            Date beginTime = new Date();
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date afterTime = issueCaCertReqVO.isValidityUpdate() ? IssueTimeUtil.getCertUpdateTime((Long)issueCaCertReqVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)oldSignCert.getNotAfter(), (Date)beginTime) : oldSignCert.getNotAfter();
            String dn = issueCaCertReqVO.isDnUpdate() ? issueCaCertReqVO.getCertDn() : CertUtil.getSubjectByX509Cert((X509Certificate)oldSignCert);
            List signExtensions = CertUtil.genExtensions((X509Certificate)oldSignCert);
            List encExtensions = CertUtil.genExtensions((X509Certificate)oldEncCert);
            BigInteger signSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueCaCertReqVO.getCertDn(), caInfoVO, false, null, null);
            signExtensions = ExtensionUtil.updateExtension((List)signExtensions, (LdapOcspUrlVO)signLdapOcspUrlVO, (String)issueCaCertReqVO.getCertDn(), (PublicKey)signPublicKey);
            X509Certificate newSignCert = this.hsmService.genX509Certificate(issueCaCertReqVO.getCertDn(), signSn, beginTime, afterTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            BigInteger encSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, dn, caInfoVO, false, null, null);
            encExtensions = ExtensionUtil.updateExtension((List)signExtensions, (LdapOcspUrlVO)encLdapOcspUrlVO, (String)issueCaCertReqVO.getCertDn(), (PublicKey)encPublicKey);
            X509Certificate newEncCert = this.hsmService.genX509Certificate(dn, encSn, beginTime, afterTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            ManageCertDataDO signManageCertDataDo = new ManageCertDataDO();
            ManageCertDataDO encManageCertDataDo = new ManageCertDataDO();
            AdminRoleDO caAdminRoleDO = this.adminRoleDao.getCaAdminCertByManageId(oldSignCertId);
            this.buildManagerCertData(newSignCert, newEncCert, certDO, signManageCertDataDo, encManageCertDataDo);
            this.updateCaAdminCert(caInfoVO.getCertId(), newSignCert, newEncCert, templateInfoVO, oldSignCertId, oldEncCertId, signManageCertDataDo, encManageCertDataDo, caAdminRoleDO, roleId);
            this.logger.info("\u66f4\u65b0CA\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f\uff0cnewSignSn=" + CertUtil.writeObject((Object)newSignCert) + ",newEncSn=" + newEncCert);
            return Result.success((Object)CertUtil.enPEncCert((X509Certificate)newSignCert, (X509Certificate)newEncCert, (Integer)templateInfoVO.getKeyAlg()), (String)CertUtil.getSubjectByX509Cert((X509Certificate)oldSignCert));
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getCurrentCaServer() {
        try {
            Map map = this.caServerCertDao.getCurrentCaServerCertSn();
            if (null == map || null == map.get("sn")) {
                this.logger.info("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff0c\u670d\u52a1\u5668\u8bc1\u4e66\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
            }
            String sn = map.get("sn").toString();
            return this.raManagerCertService.getCertDetail(sn, Integer.valueOf(CertTypeEnum.SERVER_CERT.value));
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public Object getCaServerCertList(Integer pageNo, Integer pageSize) {
        try {
            PageInfo pageInfo = this.caServerCertDao.querySubSystemList(pageNo.intValue(), pageSize.intValue());
            return this.commonService.CertFormatConverse(pageInfo);
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2CA\u5b50\u7cfb\u7edf\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doUpdateCaServerCert(IssueRaCertVO issueRaCertVO) {
        try {
            String oldSignSn = issueRaCertVO.getSn();
            List oldCerts = this.managereCertDao.getCertsBySignSn(oldSignSn, Constants.BASE_ALG_TYPE);
            if (null == oldCerts || oldCerts.size() == 0) {
                RevokedManageCertDO revokedCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(oldSignSn, Constants.BASE_ALG_TYPE);
                if (null != revokedCertDO) {
                    this.logger.debug("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)oldSignSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                }
                OutdateManageCertDO outdateCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(oldSignSn, Constants.BASE_ALG_TYPE);
                if (null != outdateCertDO) {
                    this.logger.debug("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)oldSignSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                }
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66\uff0csignSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            ManageCertDO certDO = (ManageCertDO)oldCerts.get(0);
            if (certDO.getAfterTime().before(new Date())) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671fsignSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            if (certDO.getStatus() == 2) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
            }
            TemplateDO templateDO = this.templateDao.getTemplateById(certDO.getTemplateId());
            if (null == templateDO) {
                this.logger.debug("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateDO.getStatus()) {
                this.logger.info("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateDO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_NOT_NORMAL);
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateDO.getKeyAlg());
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
                this.logger.debug("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueRaCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
                this.logger.debug("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueRaCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
            }
            if (issueRaCertVO.isDnUpdate()) {
                if (!issueRaCertVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                try {
                    X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueRaCertVO.getCertDn());
                    issueRaCertVO.setCertDn(x500Name.toString());
                }
                catch (Exception e) {
                    this.logger.debug("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueRaCertVO.getCertDn());
                    return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
                }
            }
            ManageCertDataDO certDataDO1 = this.managereCertDao.queryCertDataNoById(certDO.getId());
            ManageCertDataDO certDataDO2 = this.managereCertDao.queryCertDataNoById(certDO.getPairCertId());
            Long oldSignCertId = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            Long oldEncCertId = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            X509Certificate oldSignCert = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            X509Certificate oldEncCert = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            PublicKey signPublicKey = oldSignCert.getPublicKey();
            PublicKey encPublicKey = oldEncCert.getPublicKey();
            CaPwdBean oldCaPwdBean = caInfoVO.getCaServerPwdConfig();
            if (issueRaCertVO.isKeyUpdate() || issueRaCertVO.getKeyIndex() != null && issueRaCertVO.getKeyIndex().intValue() != oldCaPwdBean.getKeyIndex().intValue()) {
                boolean flag;
                if (Constants.BASE_ALG_TYPE == AlgTypeEnum.SM2.value && Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue() && !(flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)issueRaCertVO.getKeyIndex(), (String)issueRaCertVO.getPrivateKeyPin()))) {
                    this.logger.debug("\u66f4\u65b0ca\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1a\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650[{}]", (Object)issueRaCertVO);
                    return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                }
                signPublicKey = this.hsmService.getCaSignServerPwd(templateDO.getKeyAlg(), templateDO.getKeySize(), issueRaCertVO.getKeyIndex());
                encPublicKey = this.hsmService.getCaEncServerPwd(templateDO.getKeyAlg(), templateDO.getKeySize(), issueRaCertVO.getKeyIndex());
            } else if (Constants.BASE_ALG_TYPE == AlgTypeEnum.SM2.value && Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                CaPwdBean caPwdBean = caInfoVO.getCaServerPwdConfig();
                issueRaCertVO.setKeyIndex(caPwdBean.getKeyIndex());
                issueRaCertVO.setPrivateKeyPin(caPwdBean.getPrivateKeyPin());
            }
            String dn = issueRaCertVO.isDnUpdate() ? issueRaCertVO.getCertDn() : CertUtil.getSubjectByX509Cert((X509Certificate)oldSignCert);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date beginTime = new Date();
            Date afterTime = issueRaCertVO.isValidityUpdate() ? IssueTimeUtil.getCertUpdateTime((Long)issueRaCertVO.getValidity(), (Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)oldSignCert.getNotAfter(), (Date)beginTime) : oldSignCert.getNotAfter();
            List signExtensions = CertUtil.genExtensions((X509Certificate)oldSignCert);
            List encExtensions = CertUtil.genExtensions((X509Certificate)oldEncCert);
            BigInteger signSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            signExtensions = ExtensionUtil.updateExtension((List)signExtensions, (LdapOcspUrlVO)signLdapOcspUrlVO, (String)issueRaCertVO.getCertDn(), (PublicKey)signPublicKey);
            X509Certificate newSignCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), signSn, beginTime, afterTime, caInfoVO, signPublicKey, signExtensions, templateDO.getSignAlg());
            BigInteger encSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            encExtensions = ExtensionUtil.updateExtension((List)encExtensions, (LdapOcspUrlVO)encLdapOcspUrlVO, (String)issueRaCertVO.getCertDn(), (PublicKey)encPublicKey);
            X509Certificate newEncCert = this.hsmService.genX509Certificate(dn, encSn, beginTime, afterTime, caInfoVO, encPublicKey, encExtensions, templateDO.getSignAlg());
            this.raManagerCertService.doRevokeManageDoubleCert(issueRaCertVO.getSn(), Constants.BASE_ALG_TYPE, 4, "\u8bc1\u4e66\u66f4\u65b0");
            this.caServerCertDao.updateIsCurrent(oldSignCertId);
            this.saveCAServerCert(caInfoVO.getCertId(), newEncCert, newSignCert, templateDO, oldSignCertId, oldEncCertId);
            TomcatHttpsUtil.setTomcatHttpsPort((Integer)templateDO.getKeyAlg(), (String)caInfoVO.getCertChain(), (X509Certificate)newSignCert, (X509Certificate)newEncCert, (Integer)issueRaCertVO.getKeyIndex(), (String)issueRaCertVO.getPrivateKeyPin(), (Integer)ConfigUtil.getTomcatHttpsPort((Environment)this.environment));
            CaServerPwdUtil.saveCaServerPwdCache((ConfigFileService)this.configFileService, (Integer)templateDO.getKeyAlg(), (Integer)issueRaCertVO.getKeyIndex(), (String)issueRaCertVO.getPrivateKeyPin());
            this.logger.info("\u66f4\u65b0CA\u670d\u52a1\u5668\u8bc1\u4e66\u6210\u529f\uff0cnewSignCert=" + CertUtil.writeObject((Object)newSignCert) + ",newEncCert=" + CertUtil.writeObject((Object)newEncCert));
            try {
                TomcatUtil.restart();
            }
            catch (Exception e) {
                this.logger.error("\u91cd\u542ftomcat\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.REBOOT_SERVICE_FAIL);
            }
            return Result.success((String)certDO.getSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getCurrentCaServerEncCert() {
        try {
            Map map = this.caServerCertDao.getCurrentCaServerCertEncSn();
            if (null == map || null == map.get("sn")) {
                this.logger.info("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff0c\u670d\u52a1\u5668\u8bc1\u4e66\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
            }
            String sn = map.get("sn").toString();
            return this.raManagerCertService.getCertDetail(sn, Integer.valueOf(CertTypeEnum.SERVER_CERT.value));
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaSoftServerPwdBean getCaCurrServerCert() {
        try {
            Map signCertMap = this.caServerCertDao.getCurrentCaSignServerCert();
            if (null == signCertMap || signCertMap.isEmpty()) {
                return null;
            }
            Object signCertObj = signCertMap.get("data");
            if (null == signCertObj) {
                return null;
            }
            String signCertData = signCertObj.toString();
            Map encCertMap = this.caServerCertDao.getCurrentCaEncServerCert();
            Object encCertObj = encCertMap.get("data");
            if (null == encCertObj) {
                return null;
            }
            String encCertData = encCertObj.toString();
            X509Certificate signCert = CertUtil.getCertFromStr((String)signCertData);
            X509Certificate encCert = CertUtil.getCertFromStr((String)encCertData);
            CaSoftServerPwdBean caSoftServerPwdBean = CaServerPwdUtil.getCaRSAServerPwdCache((ConfigFileService)this.configFileService, (X509Certificate)signCert, (X509Certificate)encCert);
            return caSoftServerPwdBean;
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaSoftServerPwdBean getCaCurrServerKey(String path) {
        try {
            CaSoftServerPwdBean caSoftServerPwdBean = new CaSoftServerPwdBean();
            PrivateKey signPrivateKey = CertUtils.readPrivateKeyByPath((String)(path + "caServerSignCert.key"));
            PrivateKey encPrivateKey = CertUtils.readPrivateKeyByPath((String)(path + "caServerENCCert.key"));
            caSoftServerPwdBean.setSignPrivateKey(signPrivateKey);
            caSoftServerPwdBean.setEncPrivateKey(encPrivateKey);
            return caSoftServerPwdBean;
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveCAServerCert(Long caCertId, X509Certificate encCert, X509Certificate signCert, TemplateDO templateDO, Long oldSignCertId, Long oldEncCertId) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateDO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateDO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateDO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateDO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_OK_ACK);
        manageCertDO.setGmtCreate(encCert.getNotBefore());
        manageCertDO.setOldCertId(oldEncCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setOldCertId(oldSignCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        CaServerCertDo caServerCertDo = new CaServerCertDo();
        caServerCertDo.setGmtCreate(encCert.getNotBefore());
        caServerCertDo.setIsCurrent(Integer.valueOf(ServerCertIsCurrentEnum.IS_CURRENT.value));
        caServerCertDo.setManageCertId(manageCertDO.getId());
        this.caServerCertDao.save(caServerCertDo);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.savePublishCert(manageCertDO.getId(), manageCertDO.getPairCertId(), Integer.valueOf(2));
    }

    private void buildManagerCertData(X509Certificate newSignCert, X509Certificate newEncCert, ManageCertDO certDO, ManageCertDataDO signManageCertDataDo, ManageCertDataDO encManageCertDataDo) throws Exception {
        signManageCertDataDo.setGmtCreate(newSignCert.getNotBefore());
        signManageCertDataDo.setData(CertUtil.writeObject((Object)newSignCert));
        encManageCertDataDo.setGmtCreate(newSignCert.getNotBefore());
        encManageCertDataDo.setData(CertUtil.writeObject((Object)newEncCert));
    }

    private void updateCaAdminCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, TemplateInfoVO templateInfoVO, Long oldSignCertId, Long oldEncCertId, ManageCertDataDO signManageCertDataDo, ManageCertDataDO encManageCertDataDo, AdminRoleDO adminRoleDO, Long roleId) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        manageCertDO.setGmtCreate(signCert.getNotBefore());
        manageCertDO.setOldCertId(oldEncCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDo.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDo);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setOldCertId(oldSignCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDo.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDo);
        adminRoleDO.setGmtCreate(signCert.getNotBefore());
        adminRoleDO.setRoleId(roleId);
        adminRoleDO.setManageCertId(manageCertDO.getId());
        adminRoleDO.setGmtModified(null);
        adminRoleDO.setId(null);
        this.adminRoleDao.save(adminRoleDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.saveCertConfirmStatus(null, signManageCertDataDo.getId());
    }
}

